<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" >
	<xsl:output method="html" encoding="ISO-8859-2"/>
	<!-- 		Dokumenum cim 			-->
	<xsl:template match="doc">
	<html>
		<head>
			<title>
				<xsl:value-of select="title"/>
			</title>
		</head>
		<link rel="stylesheet" href="http://www.inf.u-szeged.hu/css/start.css" type="text/css" />
		<body leftmargin="0" topmargin="0">
			<table border="0" cellpadding="0" cellspacing="0" width="100%" height="97%">
			<xsl:if test='/doc/@language="hu"'>
			<tr>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="155" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="10" height="1" border="0" alt=""/></td>
				<td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="50%" height="1" border="0" alt=""/></td>
				<td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="533" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="50%" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="32" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="1" height="1" border="0" alt=""/></td>
			</tr>
 			<tr>
			 <td valign="top" align="left" width="155" height="70"><img name="top_C1_R1" src="http://www.inf.u-szeged.hu/images/top_C1_R1.jpg" width="155" height="70" border="0" alt=""/></td>
			 <td background="http://www.inf.u-szeged.hu/images/top_C2_R1.jpg" valign="top" align="left" width="10" height="70"><font color="orange">.</font></td>
			 <td background="http://www.inf.u-szeged.hu/images/top_C2_R1.jpg" valign="top" align="left" width="50%" height="70"><font color="orange">.</font></td>
			 <td valign="top" align="left" width="533" height="70"><img name="top_C3_R1" src="http://www.inf.u-szeged.hu/images/top_C3_R1.jpg" width="533" height="70" border="0" alt=""/></td>
			 <td background="http://www.inf.u-szeged.hu/images/top_C4_R1.jpg" valign="top" align="left" width="50%" height="70"><font color="orange">.</font></td>
			 <td valign="top" align="left" width="32" height="70"><img name="top_C5_R1" src="http://www.inf.u-szeged.hu/images/top_C5_R1.jpg" width="32" height="70" border="0" alt=""/></td>
			  <td width="1" height="70"><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="1" height="70" border="0" alt=""/></td>
			</tr>
			</xsl:if>			
			
			<xsl:if test='/doc/@language="en"'>			
				<tr>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="155" height="1" border="0" alt=""/></td>
				<td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="10" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="50%" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="533" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="50%" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="32" height="1" border="0" alt=""/></td>
			  <td><img src="http://www.inf.u-szeged.hu/images/shim.gif" width="1" height="1" border="0" alt=""/></td>
			</tr>
 			<tr>
			 <td valign="top" align="left" width="155" height="70"><img name="top_C1_R1" src="http://www.inf.u-szeged.hu/images/top_C1_R1.jpg" width="155" height="70" border="0" alt=""/></td>
       <td background="http://www.inf.u-szeged.hu/images/top_C2_R1.jpg" valign="top" align="left" width="10" height="70"><font color="orange">.</font></td>
			 <td background="http://www.inf.u-szeged.hu/images/top_C2_R1.jpg" valign="top" align="left" width="50%" height="70"><font color="orange">.</font></td>
			 <td valign="top" align="left" width="533" height="70"><img name="top_C3_R1" src="http://www.inf.u-szeged.hu/images/top_C3_R1.jpg" width="533" height="70" border="0" alt=""/></td>
			 <td background="http://www.inf.u-szeged.hu/images/top_C4_R1.jpg" valign="top" align="left" width="50%" height="70"><font color="orange">.</font></td>
			 <td valign="top" align="left" width="32" height="70"><img name="top_C5_R1" src="http://www.inf.u-szeged.hu/images/top_C5_R1.jpg" width="32" height="70" border="0" alt=""/></td>
			  <td width="1" height="70"><img src="shim.gif" width="1" height="70" border="0" alt=""/></td>
			</tr>
			</xsl:if>			

			<tr>
			<td valign="top" align="center" bgcolor="#666666" width="15%">
			<table >			
			<xsl:if test='/doc/@language="hu"'>
        <tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/starthu.xml">Rólunk</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/oktatas/starthu.xml">Oktatás</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/kutatas/starthu.xml">Kutatás</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/oktatas/phd/starthu.xml">Doktori képzés</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/munkatarsak/starthu.xml">Munkatársak</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/kutatas/actacybernetica/starthu.xml">Acta Cybernetica</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/eroforrasok/starthu.xml">Erőforrások</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/konyvtar/starthu.xml">Könyvtár</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/kutatas/konferenciak/starthu.xml">Konferenciák</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/hirek/starthu.xml">Hírek/Aktualitások</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/kutatas/tamogatok/starthu.xml">Támogatók</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/hallgatok/starthu.xml">Hallgatók</a></td></tr>			
				<tr><td colspan="2"><a class='left' href='http://www.inf.u-szeged.hu/oktatas/felveteli/starthu.xml'>Felvételizőknek</a><img src="http://www.inf.u-szeged.hu/images/newanim.gif" alt=""/></td></tr>
				<tr><td colspan="2"><hr color="#ff9900"/><font color="#ffffff" face="arial"><b>Tanszékek:</b></font><hr color="#ff9900"/></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/alkalmazottinformatika/starthu.xml">Alkalmazott Informatika</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/kepfeldolgozasesszg/starthu.xml">Képfeldolgozás és Számítógépes Grafika</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/szamitastudomanyalapjai/starthu.xml">Számítástudomány Alapjai</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/szamitogepesalgoritmusokesmi/starthu.xml">Számítógépes Algoritmusok és Mesterséges Intelligencia </a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/szoftverfejlesztes/starthu.xml">Szoftverfejlesztés</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/rgai/starthu.xml">Mesterséges Intelligencia Kutatócsoport</a></td></tr>
				<tr><td colspan="2"><hr color="#ff9900"/></td></tr>
				<tr><td colspan="2"><a class='left' href='http://www.u-szeged.hu'>[SZTE] </a><a class='left' href='http://www.sci.u-szeged.hu'> [TTK]</a></td></tr>
				<tr><td colspan="2"><a class='left' href='http://www.cab.u-szeged.hu'> [Kabinet]</a><a class='left' href='https://www.etr.u-szeged.hu/etr/login.asp'> [ETR]</a></td></tr>
    		</xsl:if>
			<xsl:if test='/doc/@language="en"'>
			  <tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/starten.xml">About Us</a></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.inf.u-szeged.hu/oktatas/starten.xml">Education</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/kutatas/starten.xml">Research</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/oktatas/phd/starten.xml">PhD</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/munkatarsak/starten.xml">People</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/kutatas/actacybernetica/starten.xml">Acta Cybernetica</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/eroforrasok/starten.xml">Facilities</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/konyvtar/starten.xml">Library</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/kutatas/konferenciak/starten.xml">Conferences</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/hirek/starten.xml">News</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/kutatas/tamogatok/starten.xml">Sponsors</a></td></tr>
				<tr><td colspan="2"><a class="left"  href="http://www.inf.u-szeged.hu/hallgatok/starten.xml">Students</a></td></tr>
				<tr><td colspan="2"><hr color="#ff9900" /><font color="#ffffff" face="arial"><b>Departments:</b></font><hr color="#ff9900" /></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz" href="http://www.inf.u-szeged.hu/tanszekek/alkalmazottinformatika/starten.xml">Applied Informatics</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/kepfeldolgozasesszg/starten.xml">Image Processing and Computer Graphics</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/szamitastudomanyalapjai/starten.xml">Foundations of Computer Science</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/szamitogepesalgoritmusokesmi/starten.xml">Computer Algorithms and Artificial Intelligence</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/szoftverfejlesztes/starten.xml">Software Engineering</a></td></tr>
				<tr><td valign="top"><font color="#ffffff">-</font></td><td><a class="lefttsz"  href="http://www.inf.u-szeged.hu/tanszekek/rgai/starten.xml">Research Group on Artificial Intelligence</a></td></tr>
    		<tr><td colspan="2"><hr color="#ff9900"/></td></tr>
				<tr><td colspan="2"><a class="left" href="http://www.u-szeged.hu">[University of Szeged]</a></td></tr>
				</xsl:if>
			</table>
			</td>
			<td bgcolor="#dbdbdb" valign="top" align="left" ></td>
			<td colspan="5" bgcolor="#dbdbdb" valign="top" align="left" >
			<xsl:apply-templates />
			</td>
			</tr>
			</table>
			<table  bgcolor="#c0c0c0" width="100%" border="0">
							<xsl:if test='/doc/@language="hu"'>
											<tr><td align="right">Webmester:<a href="mailto:webmaster@inf.u-szeged.hu">webmaster@inf.u-szeged.hu</a></td></tr>
    					</xsl:if>
							<xsl:if test='/doc/@language="en"'>
											<tr><td align="right">Webmaster:<a href="mailto:webmaster@inf.u-szeged.hu">webmaster@inf.u-szeged.hu</a></td></tr>
    					</xsl:if>

			</table>	
		</body>
	</html>			
	</xsl:template>
	<xsl:template match="doc/path">
	</xsl:template>

	<!-- 		Body, h1, t1 			-->
	<xsl:template match="body">
    		<table width="100%">
				<tr>
				<td>
				<xsl:for-each select="//path/a"> 
               <a>
			   	<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
               	<xsl:value-of select="."/><xsl:text>>>></xsl:text> 
			   </a>
			   
     		</xsl:for-each>
				</td>
				<td align="right">				
			<xsl:if test='/doc[not(@file)]'>				
							<xsl:if test='/doc/@language="hu"'>						
											<a href="http://www.inf.u-szeged.hu/starten.xml">In English</a>				
    					</xsl:if>
							<xsl:if test='/doc/@language="en"'>
											<a href="http://www.inf.u-szeged.hu/starthu.xml">Magyarul</a>				
    					</xsl:if>
      </xsl:if>
			<xsl:if test='/doc[@file]'>				
							<xsl:if test='/doc/@language="hu"'>
							<a>
							  <xsl:attribute name="href"> 
												<xsl:value-of select="/doc/@file"/>								
								</xsl:attribute>
							In English</a>				
    					</xsl:if>
							<xsl:if test='/doc/@language="en"'>
							<a>
							  <xsl:attribute name="href"> 
												<xsl:value-of select="/doc/@file"/>								
								</xsl:attribute>
							Magyarul</a>				
    					</xsl:if>
      </xsl:if>
			</td>
				</tr>
				</table> 
			<h1>
				<xsl:value-of select="/doc/body/h1/title"/>
			</h1>
			<!-- <xsl:apply-templates select="@id"/>
			<xsl:for-each select="//h1">
				<xsl:apply-templates select="@id"/>
				<HR size="10" color="#000000"/>
				<xsl:apply-templates select="title/@id"/>
				<h2>
					<xsl:value-of select="position()"/>.
							<xsl:value-of select="title"/>
				</h2>

			</xsl:for-each> -->
				<xsl:apply-templates/>
	</xsl:template>
	<!-- 		h2 			-->
	<xsl:template match="h2">
		<xsl:apply-templates select="@id"/>
		<HR size="2" color="#c0c0c0"/>
		<xsl:apply-templates select="title/@id"/>
		<h2>
			<xsl:value-of select="title"/>
		</h2>
		<xsl:apply-templates/>
	</xsl:template>
	<!-- 		h3 			-->
	<xsl:template match="h3">
		<xsl:apply-templates select="@id"/>
		<HR size="1" color="#c0c0c0"/>
		<xsl:apply-templates select="title/@id"/>
		<h3>
			<xsl:value-of select="title"/>
		</h3>
		<xsl:apply-templates/>
	</xsl:template>
	<!-- 		h4 			-->
	<xsl:template match="h4">
		<xsl:apply-templates select="@id"/>
		<HR size="1" color="#000000"/>
		<xsl:apply-templates select="title/@id"/>
		<h4>
			<xsl:value-of select="title"/>
		</h4>
		<xsl:apply-templates/>
	</xsl:template>
	<!-- 		p 			-->
	<xsl:template match="p">
		<xsl:apply-templates select="@id"/>
		<p>
			<xsl:text disable-output-escaping="yes"> </xsl:text>
			<xsl:apply-templates/>
		</p>
	</xsl:template>
	<!-- 		ul 			-->
	<xsl:template match="ul">
		<xsl:apply-templates select="@id"/>
		<ul>
			<xsl:apply-templates/>
		</ul>
	</xsl:template>
	<!-- 		ol 			-->
	<xsl:template match="ol">
		<xsl:apply-templates select="@id"/>
		<ol>
			<xsl:apply-templates/>
		</ol>
	</xsl:template>
	<!-- 		li 			-->
	<xsl:template match="li">
		<xsl:apply-templates select="@id"/>
		<li>
			<xsl:apply-templates/>
		</li>
	</xsl:template>
	<!-- 		emph 			-->
	<xsl:template match="emph">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
	<!-- 		bold 			-->
	<xsl:template match="b">
		<b>
			<xsl:apply-templates/>
		</b>
	</xsl:template>

	<!-- 		table 			-->
	<xsl:template match="table">
		<xsl:apply-templates select="@id"/>
		<table>
			<xsl:attribute name="summary"><xsl:value-of select="@summary"/></xsl:attribute>
			<xsl:attribute name="cellpadding"><xsl:value-of select="@cellpadding"/></xsl:attribute>
			<xsl:attribute name="cellspacing"><xsl:value-of select="@cellspacing"/></xsl:attribute>
			<xsl:attribute name="border"><xsl:value-of select="@border"/></xsl:attribute>
			<xsl:apply-templates/>
		</table>
	</xsl:template>
	<!-- 		tr 			-->
	<xsl:template match="tr">
		<tr>
			<xsl:apply-templates/>
		</tr>
	</xsl:template>
	<!-- 		td 			-->
<xsl:template match="td">
		<td>
		<xsl:if test='@colspan'>			
			<xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute>
    </xsl:if>			
		<xsl:if test='@rowspan'>			
			<xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute>
    </xsl:if>			
		<xsl:if test='@valign'>			
			<xsl:attribute name="valign"><xsl:value-of select="@valign"/></xsl:attribute>
    </xsl:if>			
			<xsl:apply-templates/>
		</td>
</xsl:template>
	<!-- 		a 			-->
	<xsl:template match="a">
		<xsl:apply-templates select="@id"/>
		<a>
		<xsl:if test='@href'>			
			<xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
    		</xsl:if>			

		<xsl:if test='@name'>			
			<xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
    </xsl:if>			
			<xsl:apply-templates/>
		</a>
	</xsl:template>
	<!-- 		img 			-->
	<xsl:template match="img">
		<xsl:apply-templates select="@id"/>
		<img>
			<xsl:attribute name="src"><xsl:value-of select="@href"/></xsl:attribute>
			<xsl:attribute name="alt"><xsl:value-of select="@alt"/></xsl:attribute>
			<xsl:value-of select="."/>
		</img>
	</xsl:template>
	<!-- 		id 			-->
	<xsl:template match="@id">
		<label>
			<xsl:attribute name="href"><xsl:value-of select="."/></xsl:attribute>
		</label>
	</xsl:template>
	<xsl:template match="title">
	</xsl:template>
</xsl:stylesheet>
