% The Program implements the 2DPCA of Yang et al (2004). 

clear all

Class = 20;
%Class indicates the number of distinct monuments considered

Samples = 10;
%Samples indicates the number of training samples available per class

Total_Images = Class*Samples;


r = 112;
c = 92;
% 'r' and 'c' indicates the number of row and column element respectively
% for resizing the image for a lower a scale
r = uint32(r);
c = uint32(c);

vectors = 20;
% 'vectors' denote the number of Eigen vectors chosen 

fp = fopen('2DPCA_Output.txt','a');
% The output is written onto this file

I(1:r*c,1:Total_Images)=0;
Train(1:r*c,1:(Total_Images)/2)=0;
Test(1:r*c,1:(Total_Images)/2)=0;

files = dir('*.jpg');
% Fetch all the images from the current directory

flag = 0;
for j=1:Class
    for k =1:Samples
        clear T;
        flag = flag + 1;
        
        T = rgb2gray(imread(files(flag,1).name));
        % rgb2gray is used since the original images are in RGB color space
        
        clear U;
        U = imresize(T,[r c]);
        I(:,flag) = U(:);
    end
end




cd = 0;
cq = 0;

% Separate Training and Testing images from the corpus
for i=1:Total_Images
    if (mod(i,2) == 0)
        cd = cd+1;
        Train(:,cd) = I(:,i);
    else
        cq = cq+1;
        Test(:,cq) = I(:,i);
    end
end

% computation of the corpus mean
m = mean(Train')';


% computation of covariance matrix
cm(1:r,1:r) = 0;
for i=1:cd
    cm = cm + ((reshape(Train(:,i),r,c) - reshape(m,r,c))*(reshape(Train(:,i),r,c) - reshape(m,r,c))');
end

% Singular Value Decomposition
[V,D] = eig(cm);


t = 0;
labels(1:Class,1:Samples/2) = 0;
for i=1:Class
    for j=1:Samples/2
        t=t+1;
        labels(i,j) = t;
    end
end


for i=r:-1:r-vectors

    dist(1:cd,1:cq) = 0;
    recog = 0;
    
    % Creration of Confusion Matrix
    for j=1:cq
        for k=1:cd
            A = (V(:,i:r)'*reshape(Test(:,j),r,c));
            B =  (V(:,i:r)'*reshape(Train(:,k),r,c));
            dist(j,k) = (A(:) - B(:) )' * (A(:) - B(:) );
        end
    end
    for j=1:cq
        [val,idx] = min(dist(j,:));
        [r1,c1] = find(labels == idx);
        [r2,c2] = find(labels == j);
        if(r1 == r2)
            recog = recog+1;
        end
    end
    disp((recog/(Class*Samples/2))*100);
    fprintf(fp,'\n %d  %f',i,(recog/(Class*Samples/2))*100);
end

fclose(fp);











