function varargout = buildingGUI(varargin)
% BUILDINGGUI M-file for buildingGUI.fig
%      BUILDINGGUI, by itself, creates a new BUILDINGGUI or raises the existing
%      singleton*.
%
%      H = BUILDINGGUI returns the handle to a new BUILDINGGUI or the handle to
%      the existing singleton*.
%
%      BUILDINGGUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in BUILDINGGUI.M with the given input arguments.
%
%      BUILDINGGUI('Property','Value',...) creates a new BUILDINGGUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%       applied to the GUI before buildingGUI_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to buildingGUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help buildingGUI

% Last Modified by GUIDE v2.5 12-Jul-2008 18:50:23

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @buildingGUI_OpeningFcn, ...
                   'gui_OutputFcn',  @buildingGUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before buildingGUI is made visible.
function buildingGUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to buildingGUI (see VARARGIN)

% Choose default command line output for buildingGUI
handles.output = hObject;

% Update handles structure
guidata(hObject, handles);

% UIWAIT makes buildingGUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);

run 'vlfeat-0.9-bin\vlfeat\toolbox\vlfeat_setup.m';
imgDir = 'C:\code\SSIP08\Building_Photos_Small-Extended';
load([imgDir filesep 'names.mat']);
set(handles.ebFileName,'UserData',names);
set(handles.figure1,'Name','Recognition Of Buildings Using SIFT (ROBUST)');


% --- Outputs from this function are returned to the command line.
function varargout = buildingGUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;



function ebFileName_Callback(hObject, eventdata, handles)
% hObject    handle to ebFileName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of ebFileName as text
%        str2double(get(hObject,'String')) returns contents of ebFileName as a double


% --- Executes during object creation, after setting all properties.
function ebFileName_CreateFcn(hObject, eventdata, handles)
% hObject    handle to ebFileName (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in pbBrowse.
function pbBrowse_Callback(hObject, eventdata, handles)
% hObject    handle to pbBrowse (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
[FileName PathName FilterIndex] = uigetfile({'*.jpg;*.tif;*.png;*.gif','All Image Files';'*.*','All Files' },'Select an Image to Analyse','query');
set(handles.ebFileName,'String',[PathName FileName]);

% --- Executes on button press in pbUpload.
function pbUpload_Callback(hObject, eventdata, handles)
% hObject    handle to pbUpload (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
targetName = get(handles.ebFileName,'String');
targetImage = imread(targetName);

set(handles.figure1,'CurrentAxes',handles.axTarget);
imshow(targetImage);
set(handles.axTarget,'UserData',targetImage);


% --- Executes on button press in pbSIFT.
function pbSIFT_Callback(hObject, eventdata, handles)
% hObject    handle to pbSIFT (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

targetImage = get(handles.axTarget,'UserData');
targetGrayImage = single(rgb2gray(targetImage));
[F, D] = sift(targetGrayImage);
[F, D] = threshSIFT_one(targetImage,F,D);

set(handles.figure1,'CurrentAxes',handles.axFeatures);
imshow(targetImage);
hold on;
plot(F(1,:),F(2,:),'+');
hold off;
siftFeats = {F,D};
set(handles.axFeatures,'UserData',siftFeats);

% --- Executes on button press in pbMatches.
function pbMatches_Callback(hObject, eventdata, handles)
% hObject    handle to pbMatches (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
%how to compute distance from uploaded file

% Remove previous matches to avoid confusion.
set(handles.axMatch1,'Visible','off');
set(handles.axMatch2,'Visible','off');
set(handles.axMatch3,'Visible','off');
set(handles.axMatch4,'Visible','off');

% This determines what database to use.
imgDir = 'C:\code\SSIP08\Building_Photos_Small-Extended';
load([imgDir filesep 'siftfeat_new.mat']);
load([imgDir filesep 'names.mat']);
siftFeats = get(handles.axFeatures,'UserData');
[sift_dist, sift_matches] = comparesift(siftFeats{2}, sift_d_new);

nMatches = 4;
idxs = retrieveSIFT(sift_dist, 0, nMatches);

files=dir([imgDir filesep '*.jpg']);
sz=size(idxs,2);

n = 1;
file=files(idxs(n)).name;
matchClass = names{str2num(strtok(file,'_'))};
if (length(matchClass) > 25)
    set(handles.txMatch1,'Position',[50 167 201 42]);
else
    set(handles.txMatch1,'Position',[50 167 201 21]);
end
set(handles.txMatch1,'String',[matchClass ' (' num2str(abs(sift_dist(idxs(n)))) ')']);
set(handles.figure1,'CurrentAxes',handles.axMatch1);
imshow(imread([imgDir filesep file]));

n = 2;
file=files(idxs(n)).name;
matchClass = names{str2num(strtok(file,'_'))};
if (length(matchClass) > 25)
    set(handles.txMatch2,'Position',[266 167 201 42]);
else
    set(handles.txMatch2,'Position',[266 167 201 21]);
end
set(handles.txMatch2,'String',[matchClass ' (' num2str(abs(sift_dist(idxs(n)))) ')']);
set(handles.figure1,'CurrentAxes',handles.axMatch2);
imshow(imread([imgDir filesep file]));

n = 3;
file=files(idxs(n)).name;
matchClass = names{str2num(strtok(file,'_'))};
if (length(matchClass) > 25)
    set(handles.txMatch3,'Position',[483 167 201 42]);
else
    set(handles.txMatch3,'Position',[483 167 201 21]);
end
set(handles.txMatch3,'String',[matchClass ' (' num2str(abs(sift_dist(idxs(n)))) ')']);
set(handles.figure1,'CurrentAxes',handles.axMatch3);
imshow(imread([imgDir filesep file]));

n = 4;
file=files(idxs(n)).name;
matchClass = names{str2num(strtok(file,'_'))};
if (length(matchClass) > 25)
    set(handles.txMatch4,'Position',[699 167 201 42]);
else
    set(handles.txMatch4,'Position',[699 167 201 21]);
end
set(handles.txMatch4,'String',[matchClass ' (' num2str(abs(sift_dist(idxs(n)))) ')']);
set(handles.figure1,'CurrentAxes',handles.axMatch4);
imshow(imread([imgDir filesep file]));
