function [sift_dist, sift_matches] = comparesift( I_sift_d, sift_d_new )
% function [sift_dist, sift_matches] = comparesift( I_sift_d, sift_d_new )

sz=size(sift_d_new,2);
sift_matches=cell(1,sz);
sift_dist=zeros(1,sz);

h = waitbar(0,'Calculating Matches...','Name','Progress');
for j = 1:sz
    D1 = I_sift_d;
	D2 = sift_d_new{j};
	matches = ubcmatch( D1, D2 );
	sift_dist(j) = -size(matches,2);
	sift_matches{j} = matches;
    waitbar(j/sz);
end
close(h);