function idxs = retrieveSIFT( sift_dist, exclude, first_n )
%cmps2 column vector with comparison distances
%exclude index into cmps, this index will be omitted (used to no to include the original image)
%first_n retrieve first n images

sz = size(sift_dist);
mmax = max(sift_dist(:))+1;
idxs = zeros(1,first_n );

if (exclude)
    sift_dist(exclude) = mmax;
end

for i = 1:first_n
    [val,idx] = min(sift_dist(:));
    idxs(i) = idx;
    sift_dist(idx) = mmax;
end