%dir = 'Building_Photos_Small2\'

out = uipickfiles();

for i = 1:length(out)
    
    directory_name = out{i};
    jpg_files = dir(fullfile(directory_name,'*.jpg'));
    
    load([directory_name filesep 'siftfeat.mat']);
    
    sift_f_new = {};
    sift_d_new = {};
    
    for j = 1:length(jpg_files)
        
        img = imread([directory_name filesep jpg_files(j).name]);
        
        %[h s y] = rgb2hsy(img);
        b = img(:,:,3);
        
        % Get a graylevel threshold based on Otsu's method.
        level = graythresh(b);
        
        % Convert image to binary mask using the threshold plus a constant.
        bw = im2bw(b,level + 0.15);
        
        % Invert the mask
        bw = ~bw;
        
        % Perform 2 closings using increasing disk strels to remove holes.
        bw2 = imclose(bw,strel('disk',5));
        bw2 = imclose(bw2,strel('disk',10));
        
        % Remove 10 pixels from edge of mask
        bw2(:,1:10) = 0;
        bw2(:,size(bw2,2)-10:size(bw2,2)) = 0;
        bw2(1:10,:) = 0;
        bw2(size(bw2,1)-10:size(bw2,1),:) = 0;

        % Find number of regions in mask
        [L,num] = bwlabel(bw2,8);
        
        % If more than one region, perform opening to remove artifacts.
        bw3 = bw2;
        if (num > 1)
            bw3 = imopen(bw3,strel('disk',5));
            [L,num] = bwlabel(bw3,8);
            if (num > 1)
                bwStats = regionprops(L,'Area');
                L(L ~= find([bwStats.Area]==max([bwStats.Area]))) = 0;
                bw3 = L;
            end
        end
        
        % Check for holes in the mask.
        wb = ~bw3;
        [L2,num2] = bwlabel(wb,8);
        
        if (num2 > 1)
           wbStats = regionprops(L2,'Area');
           L2(L2 ~= find([wbStats.Area]==max([wbStats.Area]))) = 0;
           bw3 = ~L2;
        end
%         [L,num] = bwlabel(bw3,8);
%         
%         if (num > 1)
%            STATS = regionprops(L,'Area');
%         end
        
%         figure(1);
%         subplot(3,1,1),subimage(img);
%         subplot(3,1,2),subimage(bw2);
%         subplot(3,1,3),subimage(bw3);
                
        %Column Indices
        x = round(sift_f{j}(1,:));
        
        %Row Indices
        y = round(sift_f{j}(2,:));
        
        [r c] = size(bw3);
        
        k = ((x-1).*r)+y;
        sift_f{j}(:,~bw3(k)) = [];
        sift_d{j}(:,~bw3(k)) = [];
        
        sift_f_new{j} = sift_f{j};
        sift_d_new{j} = sift_d{j};        
        figure(2),imshow(img);
        hold on;
        plot(sift_f{j}(1,:),sift_f{j}(2,:),'+');
        hold off;
    end
    save([directory_name filesep 'siftfeat_new.mat'],'sift_f_new','sift_d_new');
end