% LOCALMAX  Find local maximizers
%   SEL=LOCALMAX(F) returns the indexes of the local maximizers of
%   the Q-dimensional array F.
%
%   A local maximizer is an element whose value is greater than the
%   value of all its neighbors.  The neighbors of an element i1...iQ
%   have subscripts j1...jQ such that iq-1 <= jq <= iq (excluding
%   i1...iQ itself).  For example, if Q=1 the neighbors of an element
%   are its predecessor and successor in the linear order; if Q=2, its
%   neighbors are the elements immediately to its north, south, west,
%   est, north-west, north-est, south-west and south-est
%   (8-neighborhood).
%
%   Points on the boundary of F are ignored (and never selected as
%   local maximizers).
%
%   SEL=LOCALMAX(F,THRESH) accepts an element as a mazimizer only if
%   it is not smaller thatn THRES.
%
%   SEL=LOCALMAX(F,THRESH,P) looks for neighbors only in the first P
%   dimensions of the Q-dimensional array F. This allows to process F
%   in ``slices''.
%
%   REMARK.  Matrices (2-array) with a singleton dimension are
%   interpreted as vectors (1-array). So for example LOCALMAX([0 1 0])
%   and LOCALMAX([0 1 0]') both return 2 as an aswer. However, if [0 1
%   0] is to be interpreted as a 1x2 matrix, then the correct answer
%   is the empty set, as all elements are on the boundary.
%   Unfortunately MATLAB does not distinguish between vectors and
%   2-matrices with a singleton dimension.  To forece the
%   interpretation of all matrices as 2-arrays, use
%   LOCALMAX(F,TRESH,2) (but note that in this case the result is
%   always empty!).

% AUTORIGHTS
% Copyright 2007 (c) Andrea Vedaldi and Brian Fulkerson
% 
% This file is part of VLFeat, available in the terms of the GNU
% General Public License version 2.

% TODO: Companion REFINELOCALMAX
% TODO: Do something smarter at boundaries

