function [allArea]=manual_recognition(original_image,res,Random_image,handleLabel,handleArea)
%% fix original image. features were extracted by rescaling the original
%% image at .6 memory problem
r1=imresize(original_image,res);
r1a=imresize(original_image,.6);
cform1 = makecform('srgb2lab');
lab_he1 = applycform(r1a,cform1);
lab_he1 = lab2double(lab_he1);
L1=lab_he1(:,:,1);

%% contains color U,V
U1=lab_he1(:,:,2);

% U=imadjust(U);

V1=lab_he1(:,:,3);

clear i  j
%% User select point to be classified
figure,imagesc(Random_image)
[x_d,y_d]=getpts;
magni=0.6/res;
j=round(x_d);
i=round(y_d);
figure,imshow(r1)
hold on
plot(j,i,'.r')
Label=Random_image(i,j);
[x_s,y_s]=size(Random_image);
TEST_c=zeros(x_s,y_s);
TEST_c(find(Random_image==Label))=1;
figure,imshow(TEST_c)
[r,c] =find(TEST_c>0);
figure,imshow(r1)
hold on
plot(c,r,'.r')
clear i j
ROI_SIZE=21;
j=round(magni*x_d);
i=round(magni*y_d);
%% crop roi 21x21 to extract features
a1(:,:)=U1(i-round(ROI_SIZE/2):round(ROI_SIZE/2)+i,j-round(ROI_SIZE/2):round(ROI_SIZE/2)+j);
a(:,:)=V1(i-round(ROI_SIZE/2):round(ROI_SIZE/2)+i,j-round(ROI_SIZE/2):round(ROI_SIZE/2)+j);
Meanval1=mean2(nonzeros(a1));
STDval1=std2(nonzeros(a1));
Meanval2=mean2(nonzeros(a));
STDval2=std2(nonzeros(a));
f=[Meanval1 STDval1 Meanval2 STDval2];
load test_knn
Class = knnclassify(f, PATT, LA);
if Class==1 || Class==5
    text = 'land';
elseif Class==2
    text = 'sea';
elseif Class==3
    text = 'clouds / snow';
elseif Class==4
    text = 'city';
end
% write to GUI
set(handleLabel,'String',text);

L = bwlabel(TEST_c);
stats = regionprops(L,'Area');
allArea = [stats.Area];
allArea=allArea*magni;
allArea=sum(allArea(:));

% write to GUI
set(handleArea,'String',num2str(allArea));