function Random_image = semisupervised(Image,NumberOfLabels,Beta,InitTemp,annealingRate,Stop,StopValue)


% MRF Segmentation 
% clc;close all;clear all

%% Read image
r1=Image;
cform = makecform('srgb2lab');
lab_he = applycform(r1,cform);
lab_he = lab2double(lab_he);
L=lab_he(:,:,1);

%% Create matrics containing color (U,V)
U=lab_he(:,:,2);
V=lab_he(:,:,3);

%% input number of classes,parameter b
K=NumberOfLabels;
rectangles = selectRectangles(r1,K);
B=Beta;
%% calculate mean values and standart deviation
for m=1:K
    TEM1=imcrop(U,[rectangles(m,:)]);
    TEM2=imcrop(V,[rectangles(m,:)]);
    Meanval1=mean2(nonzeros(TEM1));
    STDval1=std2(nonzeros(TEM1));
    Meanval2=mean2(nonzeros(TEM2));
    STDval2=std2(nonzeros(TEM2));
    Mean_std(:,m)=[Meanval1 STDval1 Meanval2 STDval2];
  
end




%% Radom initialization
[xx,yy,zz]=size(r1);
Random_image = randint(xx,yy,[1,K]);
figure('Name','Random Image'),imagesc(Random_image)

%% initial temperature
Temp=InitTemp;
%% Calculate Sigletron
for i=1:K
    Ev_term1=((V-Mean_std(3,i)).^2)/2*(Mean_std(4,i).^2);
    Eu_term1=((U-Mean_std(1,i)).^2)/2*(Mean_std(2,i).^2);
    Ev_term2=log(sqrt(2)*pi*Mean_std(4,i));
    Eu_term2=log(sqrt(2)*pi*Mean_std(2,i));
    Etext=Ev_term1+Eu_term1+Ev_term2+Eu_term2;
    EF(:,:,i)= (Etext);
end

%     a_in=(0.9^iter)+1/K;
a_in=1;

[xx,yy]=size(r1(:,:,1));
count2=1;
%% anealling step
while (ok(Stop,StopValue,count2,Temp))
    count2=count2+1
    Temp=Temp*annealingRate

%     Random_image = padarray(Random_image,[1 1],'replicate');

    for i=2:xx-1
        for j=2:yy-1
            value_pix=Random_image(i,j);

            singletron=EF(i,j,value_pix);

            c1=Random_image(i-1,j);
            c2=Random_image(i+1,j);
            c3=Random_image(i,j-1);
            c4=Random_image (i,j+1);
            doubletron=B*(Drac(value_pix,c1)+Drac(value_pix,c2)+Drac(value_pix,c3)+Drac(value_pix,c4));
            new_c = randint(1,1,[1,K]);
            singletron1=EF(i,j,new_c);
            doubletron1=B*(Drac(new_c,c1)+Drac(new_c,c2)+Drac(new_c,c3)+Drac(new_c,c4));
            energ0=doubletron+a_in*singletron;
            energ1=doubletron1+a_in*singletron1;
            Dif_ene=double(energ1-energ0);
            %                 m_val(i,j)=exp(-Dif_ene/Temp);
            if Dif_ene<=0
                Random_image(i,j)= new_c;
            elseif rand(1)<exp(-Dif_ene/Temp)
                %                     disp('______________________________________________')
                Random_image(i,j)= new_c;
            end

        end
    end

    %Random_image = Random_image(2:xx+1,2:yy+1);

    figure(7),imagesc(Random_image)
    %         input('ss');
    disp('.')
    pause(0.1)
end
figure,imagesc(Random_image)


function out = ok(Stop,StopValue,count2,Temp)
    if (Stop == 0) % min temperature
        out = (Temp < StopValue);
    else % iteration
        out = (count2 < StopValue);
    end
end

end

