function Random_image = unsupervised(Random_image,Image,NumberOfLabels,Beta,InitTemp,annealingRate,Stop,StopValue,iterMstep)

% Stop: 0:min temperature; 1:iteration
% MRF Segmentation Based on .....
%clc;close all;clear all

%% Read image

cform = makecform('srgb2lab');
lab_he = applycform(Image,cform);
lab_he = lab2double(lab_he);
L=lab_he(:,:,1);
% figure,imagesc(L)
%% contains color U,V
U=lab_he(:,:,2);
% figure,imagesc(U)
% U=imadjust(U);

V=lab_he(:,:,3);
% V=imadjust(V);
% figure,imagesc(V)
%% input number of classes,parameter b
K=NumberOfLabels;

B=Beta;
%% Radom initialization
% [xx,yy,zz]=size(r1);
% Random_image = randint(xx,yy,[1,K]);
%% Temperature

%%% k-means based initialization

% % %% E-Step
% ab = double(lab_he(:,:,2:3));
% nrows = size(ab,1);
% ncols = size(ab,2);
% ab = reshape(ab,nrows*ncols,2);
% 
% nColors = K;
% % repeat the clustering 3 times to avoid local minima
% [cluster_idx cluster_center] = kmeans(ab,nColors,'distance','city','Replicates',3);
% Random_image = reshape(cluster_idx,nrows,ncols);
% figure('Name','K-Means'),imagesc(Random_image)



[x_s,y_s]=size(Image(:,:,1));

%% EM STEP
count=0;
Temp = InitTemp;
for iter=1:iterMstep

    count=count+1;



    for m=1:K
        for ip=1:x_s
            for jp=1:y_s;
                if Random_image(ip,jp)==m
                    TEM1(ip,jp)=U(ip,jp);
                    TEM2(ip,jp)=V(ip,jp);
                else
                    TEM1(ip,jp)=0;
                    TEM2(ip,jp)=0;
                end
            end
        end
        Meanval1=mean2(nonzeros(TEM1));
        STDval1=std2(nonzeros(TEM1));
        Meanval2=mean2(nonzeros(TEM2));
        STDval2=std2(nonzeros(TEM2));
        Mean_std(:,m)=[Meanval1 STDval1 Meanval2 STDval2]
        clear x
    end
    clear Meanval1 STDval1 Meanval2 Temp_mat2 Temp_mat1 STDval2
%% calculate singletron
    for i=1:K
        Ev_term1=((V-Mean_std(3,i)).^2)/2*(Mean_std(4,i).^2);
        Eu_term1=((U-Mean_std(1,i)).^2)/2*(Mean_std(2,i).^2);
        Ev_term2=log(sqrt(2)*pi*Mean_std(4,i));
        Eu_term2=log(sqrt(2)*pi*Mean_std(2,i));
        Etext=Ev_term1+Eu_term1+Ev_term2+Eu_term2;
        EF(:,:,i)= (Etext);
    end

    %     a_in=(0.9^iter)+1/K;
    a_in=1;

    count2=1;
    [xx,yy]=size(Image(:,:,1));
%% anealling step
    while (ok(Stop,StopValue,count2,Temp))%(count2<StopValue || Temp<StopValue)
        count2=count2+1
        Temp=Temp*annealingRate


        for i=2:xx-2
            for j=2:yy-2
                value_pix=Random_image(i,j);

                singletron=EF(i,j,value_pix);

                c1=Random_image(i-1,j);
                c2=Random_image(i+1,j);
                c3=Random_image(i,j-1);
                c4=Random_image (i,j+1);
                doubletron=B*(Drac(value_pix,c1)+Drac(value_pix,c2)+Drac(value_pix,c3)+Drac(value_pix,c4));
                new_c = randint(1,1,[1,K]);
                singletron1=EF(i,j,new_c);
                doubletron1=B*(Drac(new_c,c1)+Drac(new_c,c2)+Drac(new_c,c3)+Drac(new_c,c4));
                energ0=doubletron+a_in*singletron;
                energ1=doubletron1+a_in*singletron1;
                Dif_ene=double(energ1-energ0);
%                 m_val(i,j)=exp(-Dif_ene/Temp);
                if Dif_ene<=0
                    Random_image(i,j)= new_c;
                elseif rand(1)<exp(-Dif_ene/Temp)
                    Random_image(i,j)= new_c;
                end

            end
        end

        figure(10),imagesc(Random_image)
        pause(0.1)
    end
    %figure,imagesc(Random_image)

end


function out = ok(Stop,StopValue,count2,Temp)
    if (Stop == 0) % min temperature
        out = (Temp < StopValue);
    else % iteration
        out = (count2 < StopValue);
    end
end

end

