function varargout = MRF_GUI(varargin)
% MRF_GUI M-file for MRF_GUI.fig
%      MRF_GUI, by itself, creates a new MRF_GUI or raises the existing
%      singleton*.
%
%      H = MRF_GUI returns the handle to a new MRF_GUI or the handle to
%      the existing singleton*.
%
%      MRF_GUI('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in MRF_GUI.M with the given input arguments.
%
%      MRF_GUI('Property','Value',...) creates a new MRF_GUI or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before start_OpeningFunction gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to MRF_GUI_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help MRF_GUI

% Last Modified by GUIDE v2.5 14-Jul-2008 18:22:53

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @MRF_GUI_OpeningFcn, ...
                   'gui_OutputFcn',  @MRF_GUI_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before MRF_GUI is made visible.
function MRF_GUI_OpeningFcn(hObject, eventdata, handles, varargin)
% This function has no output args, see OutputFcn.
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% varargin   command line arguments to MRF_GUI (see VARARGIN)

% Choose default command line output for MRF_GUI
handles.output = hObject;

%this command asks the user to confirm closing of GUI
set(handles.figure1,'CloseRequestFcn','closeGUI');
set(handles.figure1,'Name','MRF - Segmentation');
 handles.ComputeOpen = 0;
 handles.ComputeSegmentation = 0;
 handles.ComputeKmeans =0;
% Update handles structure
guidata(hObject, handles);

% UIWAIT makes MRF_GUI wait for user response (see UIRESUME)
% uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = MRF_GUI_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on button press in buttonLuv.
function buttonLuv_Callback(hObject, eventdata, handles)
% hObject    handle to buttonLuv (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    if handles.ComputeOpen == 0
        return
    end
    showLuv( handles.Luv );


% --- Executes on button press in buttonOpen.
function buttonOpen_Callback(hObject, eventdata, handles)
% hObject    handle to buttonOpen (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

%%%%%%%%OPEN IMAGE%%%%%%%%%%%%%%
    [FileName,PathName,FilterIndex] = uigetfile({'*.jpg;*.tif;*.png;*.gif;*.bmp','All Image Files';...
              '*.*','All Files' },'Open image..',pwd);
    if FileName==0
        return;
    end
    handles.I = imread(strcat(PathName,FileName));
    handles.Luv = RGB2Luv(handles.I); %!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    plotImage(handles.I,handles.OriginalImage);
    
    handles.ComputeOpen = 1;
    guidata(hObject, handles);


% --- Executes during object creation, after setting all properties.
function labels_CreateFcn(hObject, eventdata, handles)
% hObject    handle to labels (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function beta_CreateFcn(hObject, eventdata, handles)
% hObject    handle to beta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

% --- Executes during object creation, after setting all properties.
function OriginalImage_CreateFcn(hObject, eventdata, handles)
% hObject    handle to OriginalImage (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: place code in OpeningFcn to populate OriginalImage


function plotImage(I,axesName)
    cla(axesName);
    axes(axesName);
    hold on
    imshow(I)
    hold off


function disableButtons(handles)
set(handles.buttonOpen,'Enable','off');
set(handles.buttonLuv,'Enable','off');
set(handles.buttonStart,'Enable','off');
set(handles.buttonStart,'Enable','off');

function enableButtons(handles)
set(handles.buttonOpen,'Enable','on');
set(handles.buttonLuv,'Enable','on');
set(handles.buttonStart,'Enable','on');
set(handles.buttonStart,'Enable','on');


% --- Executes during object creation, after setting all properties.
function temperature_CreateFcn(hObject, eventdata, handles)
% hObject    handle to temperature (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function annealingRate_CreateFcn(hObject, eventdata, handles)
% hObject    handle to annealingRate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function iteration_CreateFcn(hObject, eventdata, handles)
% hObject    handle to iteration (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes during object creation, after setting all properties.
function mintemperature_CreateFcn(hObject, eventdata, handles)
% hObject    handle to mintemperature (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in radioIter.
function radioIter_Callback(hObject, eventdata, handles)
% hObject    handle to radioIter (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    set(handles.mintemperature,'Enable','off');
    set(handles.iteration,'Enable','on');
    set(hObject, 'Value', 1);
% Hint: get(hObject,'Value') returns toggle state of radioIter




% --- Executes on button press in radiomintemp.
function radiomintemp_Callback(hObject, eventdata, handles)
% hObject    handle to radiomintemp (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    set(handles.mintemperature,'Enable','on');
    set(handles.iteration,'Enable','off');
    set(hObject, 'Value', 1);
% Hint: get(hObject,'Value') returns toggle state of radiomintemp




% --- Executes on button press in buttonStart.
function buttonStart_Callback(hObject, eventdata, handles)
% hObject    handle to buttonStart (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    if handles.ComputeOpen == 0
        return
    end

    % resize the image
    rate = str2double(get(handles.resize,'String'));
    Image = imresize(handles.I,rate);

    % disable GUI
    disableButtons(handles);
    
    NumberOfLabels = str2double(get(handles.labels,'String'));
    Beta = str2double(get(handles.beta,'String'));
    InitTemp = str2double(get(handles.temperature,'String'));
    annealingRate = str2double(get(handles.annealingRate,'String'));
    
    % Stop: 0:min temperature; 1:iteration
    Stop = get(handles.radioIter,'Value');
    if (Stop == 1 ) % Stop: iteration
        StopValue = str2double(get(handles.iteration,'String'));
    else
        StopValue = str2double(get(handles.mintemperature,'String'));
    end
    
    % Texture = get(handles.texture,'Value');
    
    if get(handles.supervised,'Value')
        % Supervised
        if 0%Texture
            % Call: 
            % supervisedTexture(Image,NumberOfLabels,Beta,InitTemp,annealingRate,Stop,StopValue)
        else
            % Call:
            SI = semisupervised(Image,NumberOfLabels,Beta,InitTemp,annealingRate,Stop,StopValue);
        end
    else
        if handles.ComputeKmeans==0
           errordlg('First you compute K-means!','Error');
           return;
        end
        iterMstep = str2double(get(handles.iterMstep,'String'));
        % Unsupervised
        % Call: 
        Random_image=handles.Kmeans;
        SI = unsupervised(Random_image,Image,NumberOfLabels,Beta,InitTemp,annealingRate,Stop,StopValue,iterMstep);
    end
    
    % save result
    handles.segmented_image = SI;
    
    % enable GUI
    enableButtons(handles);
    
    % computing ready
    handles.ComputeSegmentation = 1;
    
    % save data
    guidata(hObject, handles);




% --- Executes on button press in computeKmean.
function computeKmean_Callback(hObject, eventdata, handles)
% hObject    handle to computeKmean (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

if handles.ComputeOpen == 0
    return
end

NumberOfLabels = str2double(get(handles.labels,'String'));
rate = str2double(get(handles.resize,'String'));
Image = imresize(handles.I,rate);
% Call:
handles.Kmeans=segmentationKmeans(Image,NumberOfLabels);
handles.ComputeKmeans=1;
% save data
guidata(hObject, handles);




% --- Executes during object creation, after setting all properties.
function resize_CreateFcn(hObject, eventdata, handles)
% hObject    handle to resize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end






% --- Executes on button press in supervised.
function supervised_Callback(hObject, eventdata, handles)
% hObject    handle to supervised (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    set(handles.iterMstep,'Enable','off');
    set(hObject, 'Value', 1);
% Hint: get(hObject,'Value') returns toggle state of supervised



function iterMstep_Callback(hObject, eventdata, handles)
% hObject    handle to iterMstep (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of iterMstep as text
%        str2double(get(hObject,'String')) returns contents of iterMstep as a double


% --- Executes during object creation, after setting all properties.
function iterMstep_CreateFcn(hObject, eventdata, handles)
% hObject    handle to iterMstep (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end




% --- Executes on button press in unsupervised.
function unsupervised_Callback(hObject, eventdata, handles)
% hObject    handle to unsupervised (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    set(handles.iterMstep,'Enable','on');
    set(hObject, 'Value', 1);
% Hint: get(hObject,'Value') returns toggle state of unsupervised





function iteration_Callback(hObject, eventdata, handles)
% hObject    handle to iteration (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of iteration as text
%        str2double(get(hObject,'String')) returns contents of iteration as a double



function mintemperature_Callback(hObject, eventdata, handles)
% hObject    handle to mintemperature (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of mintemperature as text
%        str2double(get(hObject,'String')) returns contents of mintemperature as a double



function annealingRate_Callback(hObject, eventdata, handles)
% hObject    handle to annealingRate (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of annealingRate as text
%        str2double(get(hObject,'String')) returns contents of annealingRate as a double



function temperature_Callback(hObject, eventdata, handles)
% hObject    handle to temperature (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of temperature as text
%        str2double(get(hObject,'String')) returns contents of temperature as a double



function beta_Callback(hObject, eventdata, handles)
% hObject    handle to beta (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of beta as text
%        str2double(get(hObject,'String')) returns contents of beta as a double



function resize_Callback(hObject, eventdata, handles)
% hObject    handle to resize (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of resize as text
%        str2double(get(hObject,'String')) returns contents of resize as a double



function labels_Callback(hObject, eventdata, handles)
% hObject    handle to labels (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of labels as text
%        str2double(get(hObject,'String')) returns contents of labels as a double




% --- Executes on button press in texture.
% function texture_Callback(hObject, eventdata, handles)
% hObject    handle to texture (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of texture


% --- Executes on button press in autoLabel.
function autoLabel_Callback(hObject, eventdata, handles)
% hObject    handle to autoLabel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Call:
if handles.ComputeSegmentation == 0 
    return;
end

original_image = handles.I;
NumberOfLabels = str2double(get(handles.labels,'String'));
res = str2double(get(handles.resize,'String'));
Random_image = handles.segmented_image;

  automatic_recognition(original_image,Random_image,res,NumberOfLabels);

% --- Executes on button press in manualLabel.
function manualLabel_Callback(hObject, eventdata, handles)
% hObject    handle to manualLabel (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
% Call:

if handles.ComputeSegmentation == 0 
    return;
end

original_image = handles.I;
res = str2double(get(handles.resize,'String'));
Random_image = handles.segmented_image;
manual_recognition(original_image,res,Random_image,handles.labelOut,handles.areaOut);





function area_Callback(hObject, eventdata, handles)
% hObject    handle to area (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of area as text
%        str2double(get(hObject,'String')) returns contents of area as a double


% --- Executes during object creation, after setting all properties.
function area_CreateFcn(hObject, eventdata, handles)
% hObject    handle to area (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function labelOut_Callback(hObject, eventdata, handles)
% hObject    handle to labelOut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of labelOut as text
%        str2double(get(hObject,'String')) returns contents of labelOut as a double


% --- Executes during object creation, after setting all properties.
function labelOut_CreateFcn(hObject, eventdata, handles)
% hObject    handle to labelOut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end





function edit21_Callback(hObject, eventdata, handles)
% hObject    handle to edit21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of edit21 as text
%        str2double(get(hObject,'String')) returns contents of edit21 as a double


% --- Executes during object creation, after setting all properties.
function edit21_CreateFcn(hObject, eventdata, handles)
% hObject    handle to edit21 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end



function areaOut_Callback(hObject, eventdata, handles)
% hObject    handle to areaOut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hints: get(hObject,'String') returns contents of areaOut as text
%        str2double(get(hObject,'String')) returns contents of areaOut as a double


% --- Executes during object creation, after setting all properties.
function areaOut_CreateFcn(hObject, eventdata, handles)
% hObject    handle to areaOut (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: edit controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


