/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.util.locks.RecursiveLock;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindowException;

public abstract class ProxySurface
implements NativeSurface {
    protected RecursiveLock surfaceLock = new RecursiveLock();
    protected AbstractGraphicsConfiguration config;
    protected long displayHandle;
    protected int height;
    protected int scrnIndex;
    protected int width;

    public ProxySurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        this.invalidate();
        this.config = abstractGraphicsConfiguration;
        this.displayHandle = abstractGraphicsConfiguration.getScreen().getDevice().getHandle();
    }

    void invalidate() {
        this.displayHandle = 0L;
        this.invalidateImpl();
    }

    protected abstract void invalidateImpl();

    @Override
    public final long getDisplayHandle() {
        return this.displayHandle;
    }

    @Override
    public final AbstractGraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public final int getScreenIndex() {
        return this.config.getScreen().getIndex();
    }

    @Override
    public abstract long getSurfaceHandle();

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    @Override
    public boolean surfaceSwap() {
        return false;
    }

    @Override
    public void surfaceUpdated(Object object, NativeSurface nativeSurface, long l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lockSurface() throws NativeWindowException {
        int n;
        this.surfaceLock.lock();
        int n2 = n = this.surfaceLock.getRecursionCount() == 0 ? 1 : 3;
        if (1 == n) {
            try {
                AbstractGraphicsDevice abstractGraphicsDevice = this.config.getScreen().getDevice();
                abstractGraphicsDevice.lock();
                try {
                    n = this.lockSurfaceImpl();
                }
                finally {
                    if (1 >= n) {
                        abstractGraphicsDevice.unlock();
                    }
                }
            }
            finally {
                if (1 >= n) {
                    this.surfaceLock.unlock();
                }
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unlockSurface() {
        this.surfaceLock.validateLocked();
        if (this.surfaceLock.getRecursionCount() == 0) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.config.getScreen().getDevice();
            try {
                this.unlockSurfaceImpl();
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        }
        this.surfaceLock.unlock();
    }

    protected abstract int lockSurfaceImpl();

    protected abstract void unlockSurfaceImpl();

    public final void validateSurfaceLocked() {
        this.surfaceLock.validateLocked();
    }

    @Override
    public final boolean isSurfaceLocked() {
        return this.surfaceLock.isLocked();
    }

    @Override
    public final boolean isSurfaceLockedByOtherThread() {
        return this.surfaceLock.isLockedByOtherThread();
    }

    @Override
    public final Thread getSurfaceLockOwner() {
        return this.surfaceLock.getOwner();
    }

    public final int getSurfaceRecursionCount() {
        return this.surfaceLock.getRecursionCount();
    }

    public abstract String toString();
}

