/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.awt;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.image.ColorModel;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.CapabilitiesImmutable;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.awt.AWTGraphicsDevice;
import javax.media.nativewindow.awt.AWTGraphicsScreen;
import jogamp.nativewindow.Debug;

public class AWTGraphicsConfiguration
extends DefaultGraphicsConfiguration
implements Cloneable {
    private GraphicsConfiguration config;
    AbstractGraphicsConfiguration encapsulated;

    public AWTGraphicsConfiguration(AWTGraphicsScreen aWTGraphicsScreen, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, GraphicsConfiguration graphicsConfiguration, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(aWTGraphicsScreen, capabilitiesImmutable, capabilitiesImmutable2);
        this.config = graphicsConfiguration;
        this.encapsulated = abstractGraphicsConfiguration;
    }

    public AWTGraphicsConfiguration(AWTGraphicsScreen aWTGraphicsScreen, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, GraphicsConfiguration graphicsConfiguration) {
        super(aWTGraphicsScreen, capabilitiesImmutable, capabilitiesImmutable2);
        this.config = graphicsConfiguration;
        this.encapsulated = null;
    }

    public static AWTGraphicsConfiguration create(Component component, CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2) {
        AWTGraphicsScreen aWTGraphicsScreen = null;
        AWTGraphicsDevice aWTGraphicsDevice = null;
        GraphicsDevice graphicsDevice = null;
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        if (null != graphicsConfiguration && null != (graphicsDevice = graphicsConfiguration.getDevice())) {
            aWTGraphicsDevice = new AWTGraphicsDevice(graphicsDevice, 0);
            aWTGraphicsScreen = new AWTGraphicsScreen(aWTGraphicsDevice);
        }
        if (null == aWTGraphicsScreen) {
            aWTGraphicsScreen = (AWTGraphicsScreen)AWTGraphicsScreen.createScreenDevice(-1, 0);
            aWTGraphicsDevice = (AWTGraphicsDevice)aWTGraphicsScreen.getDevice();
            graphicsDevice = aWTGraphicsDevice.getGraphicsDevice();
        }
        if (null == capabilitiesImmutable) {
            GraphicsConfiguration graphicsConfiguration2 = graphicsDevice.getDefaultConfiguration();
            capabilitiesImmutable = AWTGraphicsConfiguration.setupCapabilitiesRGBABits(capabilitiesImmutable, graphicsConfiguration2);
        }
        return new AWTGraphicsConfiguration(aWTGraphicsScreen, capabilitiesImmutable, capabilitiesImmutable2, graphicsConfiguration);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.config;
    }

    @Override
    public AbstractGraphicsConfiguration getNativeGraphicsConfiguration() {
        return null != this.encapsulated ? this.encapsulated : this;
    }

    public static CapabilitiesImmutable setupCapabilitiesRGBABits(CapabilitiesImmutable capabilitiesImmutable, GraphicsConfiguration graphicsConfiguration) {
        Capabilities capabilities = (Capabilities)capabilitiesImmutable.cloneMutable();
        ColorModel colorModel = graphicsConfiguration.getColorModel();
        if (null == colorModel) {
            throw new NativeWindowException("Could not determine AWT ColorModel");
        }
        int n = colorModel.getPixelSize();
        int n2 = 0;
        int[] nArray = colorModel.getComponentSize();
        if (nArray.length >= 3) {
            capabilities.setRedBits(nArray[0]);
            n2 += nArray[0];
            capabilities.setGreenBits(nArray[1]);
            n2 += nArray[1];
            capabilities.setBlueBits(nArray[2]);
            n2 += nArray[2];
        }
        if (nArray.length >= 4) {
            capabilities.setAlphaBits(nArray[3]);
            n2 += nArray[3];
        } else {
            capabilities.setAlphaBits(0);
        }
        if (Debug.debugAll() && n != n2) {
            System.err.println("AWT Colormodel bits per components/pixel mismatch: " + n2 + " != " + n);
        }
        return capabilities;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getScreen() + ",\n\tchosen    " + this.capabilitiesChosen + ",\n\trequested " + this.capabilitiesRequested + ",\n\t" + this.config + ",\n\tencapsulated " + this.encapsulated + "]";
    }
}

