/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow.x11;

import javax.media.nativewindow.DefaultGraphicsDevice;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.ToolkitLock;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.x11.X11Util;

public class X11GraphicsDevice
extends DefaultGraphicsDevice
implements Cloneable {
    public static final boolean DEBUG = Debug.debug("GraphicsDevice");
    boolean closeDisplay = false;

    public X11GraphicsDevice(String string, int n) {
        super("X11", string, n);
    }

    public X11GraphicsDevice(long l, int n) {
        super("X11", X11Util.XDisplayString(l), n, l);
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
    }

    public X11GraphicsDevice(long l, int n, ToolkitLock toolkitLock) {
        super("X11", X11Util.XDisplayString(l), n, l, toolkitLock);
        if (0L == l) {
            throw new NativeWindowException("null display");
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public void setCloseDisplay(boolean bl) {
        this.closeDisplay = bl;
        if (DEBUG && bl) {
            System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.setCloseDisplay(true): " + this);
        }
    }

    @Override
    public boolean close() {
        if (this.closeDisplay && 0L != this.handle) {
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - X11GraphicsDevice.close(): " + this);
            }
            X11Util.closeDisplay(this.handle);
            this.handle = 0L;
            return true;
        }
        return false;
    }
}

