/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.windows;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.StructAccessor;
import com.jogamp.common.os.Platform;
import java.nio.ByteBuffer;
import jogamp.nativewindow.windows.RECT32;
import jogamp.nativewindow.windows.RECT64;

public abstract class RECT {
    StructAccessor accessor;

    public static int size() {
        if (Platform.is32Bit()) {
            return RECT32.size();
        }
        return RECT64.size();
    }

    public static RECT create() {
        return RECT.create(Buffers.newDirectByteBuffer((int)RECT.size()));
    }

    public static RECT create(ByteBuffer byteBuffer) {
        if (Platform.is32Bit()) {
            return new RECT32(byteBuffer);
        }
        return new RECT64(byteBuffer);
    }

    RECT(ByteBuffer byteBuffer) {
        this.accessor = new StructAccessor(byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this.accessor.getBuffer();
    }

    public abstract RECT setLeft(int var1);

    public abstract int getLeft();

    public abstract RECT setTop(int var1);

    public abstract int getTop();

    public abstract RECT setRight(int var1);

    public abstract int getRight();

    public abstract RECT setBottom(int var1);

    public abstract int getBottom();
}

