/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.util.LongObjectHashMap;
import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.nativewindow.ToolkitLock;
import javax.media.nativewindow.util.Point;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NWJNILibLoader;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.XVisualInfo;

public class X11Util {
    public static final boolean MULTITHREADING_BUG = Debug.getBooleanProperty("nativewindow.x11.mt-bug", true, AccessController.getContext());
    public static final boolean XINITTHREADS_ALWAYS_ENABLED = true;
    private static final boolean DEBUG = Debug.debug("X11Util");
    private static final boolean TRACE_DISPLAY_LIFECYCLE = Debug.getBooleanProperty("nativewindow.debug.X11Util.TraceDisplayLifecycle", true, AccessController.getContext());
    private static volatile String nullDisplayName = null;
    private static boolean requiresX11Lock = false;
    private static boolean isInit = false;
    private static int setX11ErrorHandlerRecCount = 0;
    private static Object setX11ErrorHandlerLock = new Object();
    private static Object globalLock = new Object();
    private static LongObjectHashMap globalNamedDisplayMap = new LongObjectHashMap();
    private static List openDisplayList = new ArrayList();
    private static List pendingDisplayList = new ArrayList();

    public static synchronized void initSingleton(boolean bl) {
        if (!isInit) {
            NWJNILibLoader.loadNativeWindow("x11");
            X11Util.initialize0(true);
            boolean bl2 = requiresX11Lock = !bl || MULTITHREADING_BUG;
            if (DEBUG) {
                System.out.println("X11Util firstX11ActionOnProcess: " + bl + ", XINITTHREADS_ALWAYS_ENABLED " + true + ", MULTITHREADING_BUG " + MULTITHREADING_BUG + ", requiresX11Lock " + requiresX11Lock);
            }
            isInit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setX11ErrorHandler(boolean bl, boolean bl2) {
        Object object = setX11ErrorHandlerLock;
        synchronized (object) {
            if (bl) {
                if (0 == setX11ErrorHandlerRecCount) {
                    X11Util.setX11ErrorHandler0(true, bl2);
                }
                ++setX11ErrorHandlerRecCount;
            } else {
                if (0 >= setX11ErrorHandlerRecCount) {
                    throw new InternalError();
                }
                if (0 == --setX11ErrorHandlerRecCount) {
                    X11Util.setX11ErrorHandler0(false, false);
                }
            }
        }
    }

    public static boolean requiresToolkitLock() {
        return requiresX11Lock;
    }

    public static void lockDefaultToolkit(long l) {
        NativeWindowFactory.getDefaultToolkitLock().lock();
        if (requiresX11Lock) {
            X11Util.XLockDisplay(l);
        }
    }

    public static void unlockDefaultToolkit(long l) {
        if (requiresX11Lock) {
            X11Util.XUnlockDisplay(l);
        }
        NativeWindowFactory.getDefaultToolkitLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getNullDisplayName() {
        if (null != nullDisplayName) return nullDisplayName;
        Class<X11Util> clazz = X11Util.class;
        synchronized (X11Util.class) {
            if (null != nullDisplayName) return nullDisplayName;
            NativeWindowFactory.getDefaultToolkitLock().lock();
            long l = X11Lib.XOpenDisplay(null);
            try {
                nullDisplayName = X11Lib.XDisplayString(l);
            }
            finally {
                X11Lib.XCloseDisplay(l);
                NativeWindowFactory.getDefaultToolkitLock().unlock();
            }
            if (!DEBUG) return nullDisplayName;
            System.out.println("X11 Display(NULL) <" + nullDisplayName + ">");
            // ** MonitorExit[var0] (shouldn't be in output)
            return nullDisplayName;
        }
    }

    private X11Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int shutdown(boolean bl, boolean bl2) {
        Object object;
        int n = 0;
        if (DEBUG || bl2 || pendingDisplayList.size() > 0) {
            object = "X11Util.Display: Shutdown (close open / pending Displays: " + bl + ", open (no close attempt): " + globalNamedDisplayMap.size() + "/" + openDisplayList.size() + ", open (no close attempt and uncloseable): " + pendingDisplayList.size() + ")";
            if (DEBUG) {
                Exception exception = new Exception((String)object);
                exception.printStackTrace();
            } else {
                System.err.println((String)object);
            }
            if (openDisplayList.size() > 0) {
                X11Util.dumpOpenDisplayConnections();
            }
            if (pendingDisplayList.size() > 0) {
                X11Util.dumpPendingDisplayConnections();
            }
        }
        object = globalLock;
        synchronized (object) {
            if (bl) {
                X11Util.closePendingDisplayConnections();
            }
            openDisplayList.clear();
            pendingDisplayList.clear();
            globalNamedDisplayMap.clear();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int closePendingDisplayConnections() {
        int n = 0;
        Object object = globalLock;
        synchronized (object) {
            if (DEBUG) {
                System.err.println("X11Util: Closing Pending X11 Display Connections: " + pendingDisplayList.size());
            }
            for (int i = pendingDisplayList.size() - 1; i >= 0; --i) {
                NamedDisplay namedDisplay = (NamedDisplay)pendingDisplayList.get(i);
                if (DEBUG) {
                    System.err.println("X11Util.closePendingDisplayConnections(): Closing [" + i + "]: " + namedDisplay);
                }
                X11Util.XCloseDisplay(namedDisplay.getHandle());
                ++n;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getOpenDisplayConnectionNumber() {
        Object object = globalLock;
        synchronized (object) {
            return openDisplayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpOpenDisplayConnections() {
        Object object = globalLock;
        synchronized (object) {
            System.err.println("X11Util: Open X11 Display Connections: " + openDisplayList.size());
            for (int i = 0; i < pendingDisplayList.size(); ++i) {
                Throwable throwable;
                NamedDisplay namedDisplay = (NamedDisplay)openDisplayList.get(i);
                System.err.println("X11Util: [" + i + "]: " + namedDisplay);
                if (null == namedDisplay || null == (throwable = namedDisplay.getCreationStack())) continue;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getPendingDisplayConnectionNumber() {
        Object object = globalLock;
        synchronized (object) {
            return pendingDisplayList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpPendingDisplayConnections() {
        Object object = globalLock;
        synchronized (object) {
            System.err.println("X11Util: Pending X11 Display Connections: " + pendingDisplayList.size());
            for (int i = 0; i < pendingDisplayList.size(); ++i) {
                Throwable throwable;
                NamedDisplay namedDisplay = (NamedDisplay)pendingDisplayList.get(i);
                System.err.println("X11Util: [" + i + "]: " + namedDisplay);
                if (null == namedDisplay || null == (throwable = namedDisplay.getCreationStack())) continue;
                throwable.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean markDisplayUncloseable(long l) {
        NamedDisplay namedDisplay;
        Object object = globalLock;
        synchronized (object) {
            namedDisplay = (NamedDisplay)globalNamedDisplayMap.get(l);
        }
        if (null != namedDisplay) {
            namedDisplay.setUncloseable(true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createDisplay(String string) {
        long l = X11Util.XOpenDisplay(string = X11Util.validateDisplayName(string));
        if (0L == l) {
            throw new NativeWindowException("X11Util.Display: Unable to create a display(" + string + ") connection. Thread " + Thread.currentThread().getName());
        }
        NamedDisplay namedDisplay = new NamedDisplay(string, l);
        Object object = globalLock;
        synchronized (object) {
            globalNamedDisplayMap.put(l, (Object)namedDisplay);
            openDisplayList.add(namedDisplay);
            pendingDisplayList.add(namedDisplay);
        }
        if (DEBUG) {
            object = new Exception("X11Util.Display: Created new " + namedDisplay + ". Thread " + Thread.currentThread().getName());
            ((Throwable)object).printStackTrace();
        }
        return namedDisplay.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeDisplay(long l) {
        NamedDisplay namedDisplay;
        Object object = globalLock;
        synchronized (object) {
            namedDisplay = (NamedDisplay)globalNamedDisplayMap.remove(l);
            if (namedDisplay != null && !openDisplayList.remove(namedDisplay)) {
                throw new RuntimeException("Internal: " + namedDisplay);
            }
        }
        if (null == namedDisplay) {
            X11Util.dumpPendingDisplayConnections();
            throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") with given handle is not mapped. Thread " + Thread.currentThread().getName());
        }
        if (namedDisplay.getHandle() != l) {
            X11Util.dumpPendingDisplayConnections();
            throw new RuntimeException("X11Util.Display: Display(0x" + Long.toHexString(l) + ") Mapping error: " + namedDisplay + ". Thread " + Thread.currentThread().getName());
        }
        if (DEBUG) {
            object = new Exception("X11Util.Display: Closing new " + namedDisplay + ". Thread " + Thread.currentThread().getName());
            ((Throwable)object).printStackTrace();
        }
        if (!namedDisplay.isUncloseable()) {
            object = globalLock;
            synchronized (object) {
                if (!pendingDisplayList.remove(namedDisplay)) {
                    throw new RuntimeException("Internal: " + namedDisplay);
                }
            }
            X11Util.XCloseDisplay(namedDisplay.getHandle());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamedDisplay getNamedDisplay(long l) {
        Object object = globalLock;
        synchronized (object) {
            return (NamedDisplay)globalNamedDisplayMap.get(l);
        }
    }

    public static String validateDisplayName(String string) {
        return null == string || "decon".equals(string) ? X11Util.getNullDisplayName() : string;
    }

    public static String validateDisplayName(String string, long l) {
        if ((null == string || "decon".equals(string)) && 0L != l) {
            string = X11Util.XDisplayString(l);
        }
        return X11Util.validateDisplayName(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long XOpenDisplay(String string) {
        NativeWindowFactory.getDefaultToolkitLock().lock();
        try {
            long l = X11Lib.XOpenDisplay(string);
            if (TRACE_DISPLAY_LIFECYCLE) {
                Throwable throwable = new Throwable(Thread.currentThread() + " - X11Util.XOpenDisplay(" + string + ") 0x" + Long.toHexString(l));
                throwable.printStackTrace();
            }
            long l2 = l;
            return l2;
        }
        finally {
            NativeWindowFactory.getDefaultToolkitLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int XCloseDisplay(long l) {
        NativeWindowFactory.getDefaultToolkitLock().lock();
        try {
            if (TRACE_DISPLAY_LIFECYCLE) {
                Throwable throwable = new Throwable(Thread.currentThread() + " - X11Util.XCloseDisplay() 0x" + Long.toHexString(l));
                throwable.printStackTrace();
            }
            int n = X11Lib.XCloseDisplay(l);
            return n;
        }
        finally {
            NativeWindowFactory.getDefaultToolkitLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int XFree(Buffer buffer) {
        NativeWindowFactory.getDefaultToolkitLock().lock();
        try {
            int n = X11Lib.XFree(buffer);
            return n;
        }
        finally {
            NativeWindowFactory.getDefaultToolkitLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int XSync(long l, boolean bl) {
        X11Util.lockDefaultToolkit(l);
        try {
            int n = X11Lib.XSync(l, bl);
            return n;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void XSynchronize(long l, boolean bl) {
        X11Util.lockDefaultToolkit(l);
        try {
            X11Lib.XSynchronize(l, bl);
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean XineramaEnabled(long l) {
        X11Util.lockDefaultToolkit(l);
        try {
            boolean bl = X11Lib.XineramaEnabled(l);
            return bl;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int DefaultScreen(long l) {
        X11Util.lockDefaultToolkit(l);
        try {
            int n = X11Lib.DefaultScreen(l);
            return n;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long RootWindow(long l, int n) {
        X11Util.lockDefaultToolkit(l);
        try {
            long l2 = X11Lib.RootWindow(l, n);
            return l2;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long XCreatePixmap(long l, long l2, int n, int n2, int n3) {
        X11Util.lockDefaultToolkit(l);
        try {
            long l3 = X11Lib.XCreatePixmap(l, l2, n, n2, n3);
            return l3;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String XDisplayString(long l) {
        X11Util.lockDefaultToolkit(l);
        try {
            String string = X11Lib.XDisplayString(l);
            return string;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int XFlush(long l) {
        X11Util.lockDefaultToolkit(l);
        try {
            int n = X11Lib.XFlush(l);
            return n;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int XFreePixmap(long l, long l2) {
        X11Util.lockDefaultToolkit(l);
        try {
            int n = X11Lib.XFreePixmap(l, l2);
            return n;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long DefaultVisualID(long l, int n) {
        X11Util.lockDefaultToolkit(l);
        try {
            long l2 = X11Lib.DefaultVisualID(l, n);
            return l2;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long CreateDummyWindow(long l, int n, long l2, int n2, int n3) {
        X11Util.lockDefaultToolkit(l);
        try {
            long l3 = X11Lib.CreateDummyWindow(l, n, l2, n2, n3);
            return l3;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DestroyDummyWindow(long l, long l2) {
        X11Util.lockDefaultToolkit(l);
        try {
            X11Lib.DestroyDummyWindow(l, l2);
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point GetRelativeLocation(long l, int n, long l2, long l3, int n2, int n3) {
        X11Util.lockDefaultToolkit(l);
        try {
            Point point = X11Lib.GetRelativeLocation(l, n, l2, l3, n2, n3);
            return point;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XVisualInfo[] XGetVisualInfo(long l, long l2, XVisualInfo xVisualInfo, int[] nArray, int n) {
        X11Util.lockDefaultToolkit(l);
        try {
            XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l, l2, xVisualInfo, nArray, n);
            return xVisualInfoArray;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean XF86VidModeGetGammaRamp(long l, int n, int n2, ShortBuffer shortBuffer, ShortBuffer shortBuffer2, ShortBuffer shortBuffer3) {
        X11Util.lockDefaultToolkit(l);
        try {
            boolean bl = X11Lib.XF86VidModeGetGammaRamp(l, n, n2, shortBuffer, shortBuffer2, shortBuffer3);
            return bl;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean XF86VidModeGetGammaRamp(long l, int n, int n2, short[] sArray, int n3, short[] sArray2, int n4, short[] sArray3, int n5) {
        X11Util.lockDefaultToolkit(l);
        try {
            boolean bl = X11Lib.XF86VidModeGetGammaRamp(l, n, n2, sArray, n3, sArray2, n4, sArray3, n5);
            return bl;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean XF86VidModeGetGammaRampSize(long l, int n, IntBuffer intBuffer) {
        X11Util.lockDefaultToolkit(l);
        try {
            boolean bl = X11Lib.XF86VidModeGetGammaRampSize(l, n, intBuffer);
            return bl;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean XF86VidModeGetGammaRampSize(long l, int n, int[] nArray, int n2) {
        X11Util.lockDefaultToolkit(l);
        try {
            boolean bl = X11Lib.XF86VidModeGetGammaRampSize(l, n, nArray, n2);
            return bl;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean XF86VidModeSetGammaRamp(long l, int n, int n2, ShortBuffer shortBuffer, ShortBuffer shortBuffer2, ShortBuffer shortBuffer3) {
        X11Util.lockDefaultToolkit(l);
        try {
            boolean bl = X11Lib.XF86VidModeSetGammaRamp(l, n, n2, shortBuffer, shortBuffer2, shortBuffer3);
            return bl;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean XF86VidModeSetGammaRamp(long l, int n, int n2, short[] sArray, int n3, short[] sArray2, int n4, short[] sArray3, int n5) {
        X11Util.lockDefaultToolkit(l);
        try {
            boolean bl = X11Lib.XF86VidModeSetGammaRamp(l, n, n2, sArray, n3, sArray2, n4, sArray3, n5);
            return bl;
        }
        finally {
            X11Util.unlockDefaultToolkit(l);
        }
    }

    public static void XLockDisplay(long l) {
        if (ToolkitLock.TRACE_LOCK) {
            System.out.println("+++ X11 Display Lock get 0x" + Long.toHexString(l));
        }
        X11Lib.XLockDisplay(l);
    }

    public static void XUnlockDisplay(long l) {
        if (ToolkitLock.TRACE_LOCK) {
            System.out.println("--- X11 Display Lock rel 0x" + Long.toHexString(l));
        }
        X11Lib.XUnlockDisplay(l);
    }

    private static native void initialize0(boolean var0);

    private static native void setX11ErrorHandler0(boolean var0, boolean var1);

    public static class NamedDisplay {
        String name;
        long handle;
        int refCount;
        boolean unCloseable;
        Throwable creationStack;

        protected NamedDisplay(String string, long l) {
            this.name = string;
            this.handle = l;
            this.refCount = 1;
            this.unCloseable = false;
            this.creationStack = DEBUG ? new Throwable("NamedDisplay Created at:") : null;
        }

        public final String getName() {
            return this.name;
        }

        public final long getHandle() {
            return this.handle;
        }

        public final int getRefCount() {
            return this.refCount;
        }

        public final void setUncloseable(boolean bl) {
            this.unCloseable = bl;
        }

        public final boolean isUncloseable() {
            return this.unCloseable;
        }

        public final Throwable getCreationStack() {
            return this.creationStack;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        public String toString() {
            return "NamedX11Display[" + this.name + ", 0x" + Long.toHexString(this.handle) + ", refCount " + this.refCount + ", unCloseable " + this.unCloseable + "]";
        }
    }
}

