/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.jvm;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.HashSet;
import jogamp.common.Debug;

public class JNILibLoaderBase {
    public static final boolean DEBUG;
    private static final AccessControlContext localACC;
    private static final HashSet loaded;
    private static LoaderAction loaderAction;
    private static final Class customLauncherClass;
    private static final Method customLoadLibraryMethod;

    public static boolean isLoaded(String string) {
        return loaded.contains(string);
    }

    public static void addLoaded(String string) {
        loaded.add(string);
        if (DEBUG) {
            System.err.println("JNILibLoaderBase Loaded Native Library: " + string);
        }
    }

    public static void disableLoading() {
        JNILibLoaderBase.setLoadingAction(null);
    }

    public static void enableLoading() {
        JNILibLoaderBase.setLoadingAction(new DefaultAction());
    }

    public static synchronized void setLoadingAction(LoaderAction loaderAction) {
        JNILibLoaderBase.loaderAction = loaderAction;
    }

    protected static synchronized boolean loadLibrary(String string, boolean bl) {
        if (loaderAction != null) {
            return loaderAction.loadLibrary(string, bl);
        }
        return false;
    }

    protected static synchronized void loadLibrary(String string, String[] stringArray, boolean bl) {
        if (loaderAction != null) {
            loaderAction.loadLibrary(string, stringArray, bl);
        }
    }

    private static void loadLibraryInternal(String string) {
        if (null != customLoadLibraryMethod && !string.equals("jawt")) {
            try {
                customLoadLibraryMethod.invoke(null, string);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = ((InvocationTargetException)throwable).getTargetException();
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("can not load library " + string).initCause(exception);
            }
        } else {
            System.loadLibrary(string);
        }
    }

    static {
        String string;
        DEBUG = Debug.debug("JNILibLoader");
        localACC = AccessController.getContext();
        loaded = new HashSet();
        loaderAction = new DefaultAction();
        Class<?> clazz = null;
        Method method = null;
        if (Debug.getBooleanProperty("sun.jnlp.applet.launcher", false, localACC)) {
            try {
                clazz = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                method = clazz.getDeclaredMethod("loadLibrary", String.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (DEBUG) {
                    classNotFoundException.printStackTrace();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (DEBUG) {
                    noSuchMethodException.printStackTrace();
                }
                clazz = null;
            }
        }
        if (null == clazz && null != (string = Debug.getProperty("jnlp.launcher.class", false, localACC))) {
            try {
                clazz = Class.forName(string);
                method = clazz.getDeclaredMethod("loadLibrary", String.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (DEBUG) {
                    classNotFoundException.printStackTrace();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (DEBUG) {
                    noSuchMethodException.printStackTrace();
                }
                clazz = null;
            }
        }
        customLauncherClass = clazz;
        customLoadLibraryMethod = method;
    }

    private static class DefaultAction
    implements LoaderAction {
        private DefaultAction() {
        }

        @Override
        public boolean loadLibrary(String string, boolean bl) {
            boolean bl2;
            block5: {
                bl2 = true;
                if (!JNILibLoaderBase.isLoaded(string)) {
                    try {
                        JNILibLoaderBase.loadLibraryInternal(string);
                        JNILibLoaderBase.addLoaded(string);
                        if (DEBUG) {
                            System.err.println("JNILibLoaderBase loaded " + string);
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        bl2 = false;
                        if (DEBUG) {
                            unsatisfiedLinkError.printStackTrace();
                        }
                        if (bl || unsatisfiedLinkError.getMessage().indexOf("already loaded") >= 0) break block5;
                        throw unsatisfiedLinkError;
                    }
                }
            }
            return bl2;
        }

        @Override
        public void loadLibrary(String string, String[] stringArray, boolean bl) {
            if (!JNILibLoaderBase.isLoaded(string)) {
                if (null != stringArray) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.loadLibrary(stringArray[i], bl);
                    }
                }
                this.loadLibrary(string, false);
            }
        }
    }

    public static interface LoaderAction {
        public boolean loadLibrary(String var1, boolean var2);

        public void loadLibrary(String var1, String[] var2, boolean var3);
    }
}

