/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.NativeBuffer;
import com.jogamp.common.nio.PointerBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class Buffers {
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_SHORT = 2;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_DOUBLE = 8;

    protected Buffers() {
    }

    public static ByteBuffer newDirectByteBuffer(int n) {
        return Buffers.nativeOrder(ByteBuffer.allocateDirect(n));
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n, int n2) {
        return (ByteBuffer)Buffers.newDirectByteBuffer(n2).put(byArray, n, n2).rewind();
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray, int n) {
        return Buffers.newDirectByteBuffer(byArray, n, byArray.length - n);
    }

    public static ByteBuffer newDirectByteBuffer(byte[] byArray) {
        return Buffers.newDirectByteBuffer(byArray, 0);
    }

    public static DoubleBuffer newDirectDoubleBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 8).asDoubleBuffer();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n, int n2) {
        return (DoubleBuffer)Buffers.newDirectDoubleBuffer(n2).put(dArray, n, n2).rewind();
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n) {
        return Buffers.newDirectDoubleBuffer(dArray, n, dArray.length - n);
    }

    public static DoubleBuffer newDirectDoubleBuffer(double[] dArray) {
        return Buffers.newDirectDoubleBuffer(dArray, 0);
    }

    public static FloatBuffer newDirectFloatBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 4).asFloatBuffer();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n, int n2) {
        return (FloatBuffer)Buffers.newDirectFloatBuffer(n2).put(fArray, n, n2).rewind();
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray, int n) {
        return Buffers.newDirectFloatBuffer(fArray, n, fArray.length - n);
    }

    public static FloatBuffer newDirectFloatBuffer(float[] fArray) {
        return Buffers.newDirectFloatBuffer(fArray, 0);
    }

    public static IntBuffer newDirectIntBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 4).asIntBuffer();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n, int n2) {
        return (IntBuffer)Buffers.newDirectIntBuffer(n2).put(nArray, n, n2).rewind();
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray, int n) {
        return Buffers.newDirectIntBuffer(nArray, n, nArray.length - n);
    }

    public static IntBuffer newDirectIntBuffer(int[] nArray) {
        return Buffers.newDirectIntBuffer(nArray, 0);
    }

    public static LongBuffer newDirectLongBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 8).asLongBuffer();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n, int n2) {
        return (LongBuffer)Buffers.newDirectLongBuffer(n2).put(lArray, n, n2).rewind();
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray, int n) {
        return Buffers.newDirectLongBuffer(lArray, n, lArray.length - n);
    }

    public static LongBuffer newDirectLongBuffer(long[] lArray) {
        return Buffers.newDirectLongBuffer(lArray, 0);
    }

    public static ShortBuffer newDirectShortBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 2).asShortBuffer();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n, int n2) {
        return (ShortBuffer)Buffers.newDirectShortBuffer(n2).put(sArray, n, n2).rewind();
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray, int n) {
        return Buffers.newDirectShortBuffer(sArray, n, sArray.length - n);
    }

    public static ShortBuffer newDirectShortBuffer(short[] sArray) {
        return Buffers.newDirectShortBuffer(sArray, 0);
    }

    public static CharBuffer newDirectCharBuffer(int n) {
        return Buffers.newDirectByteBuffer(n * 2).asCharBuffer();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n, int n2) {
        return (CharBuffer)Buffers.newDirectCharBuffer(n2).put(cArray, n, n2).rewind();
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray, int n) {
        return Buffers.newDirectCharBuffer(cArray, n, cArray.length - n);
    }

    public static CharBuffer newDirectCharBuffer(char[] cArray) {
        return Buffers.newDirectCharBuffer(cArray, 0);
    }

    public static <B extends Buffer> B slice(B b) {
        if (b instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)b;
            return (B)byteBuffer.slice().order(byteBuffer.order());
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).slice();
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).slice();
        }
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).slice();
        }
        if (b instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).slice();
        }
        if (b instanceof LongBuffer) {
            return (B)((LongBuffer)b).slice();
        }
        if (b instanceof CharBuffer) {
            return (B)((CharBuffer)b).slice();
        }
        throw new IllegalArgumentException("unexpected buffer type: " + b.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <B extends Buffer> B slice(B b, int n, int n2) {
        int n3 = b.position();
        int n4 = b.limit();
        B b2 = null;
        try {
            b.position(n).limit(n + n2);
            b2 = Buffers.slice(b);
        }
        finally {
            b.position(n3).limit(n4);
        }
        return b2;
    }

    public static ByteBuffer nativeOrder(ByteBuffer byteBuffer) {
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    public static int sizeOfBufferElem(Buffer buffer) {
        if (buffer == null) {
            return 0;
        }
        if (buffer instanceof ByteBuffer) {
            return 1;
        }
        if (buffer instanceof IntBuffer) {
            return 4;
        }
        if (buffer instanceof ShortBuffer) {
            return 2;
        }
        if (buffer instanceof FloatBuffer) {
            return 4;
        }
        if (buffer instanceof DoubleBuffer) {
            return 8;
        }
        if (buffer instanceof LongBuffer) {
            return 8;
        }
        if (buffer instanceof CharBuffer) {
            return 2;
        }
        throw new RuntimeException("Unexpected buffer type " + buffer.getClass().getName());
    }

    public static boolean isDirect(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).isDirect();
        }
        if (object instanceof PointerBuffer) {
            return ((PointerBuffer)object).isDirect();
        }
        throw new IllegalArgumentException("Unexpected buffer type " + object.getClass().getName());
    }

    public static int getDirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return n;
            }
            if (object instanceof FloatBuffer) {
                return n * 4;
            }
            if (object instanceof IntBuffer) {
                return n * 4;
            }
            if (object instanceof ShortBuffer) {
                return n * 2;
            }
            if (object instanceof DoubleBuffer) {
                return n * 8;
            }
            if (object instanceof LongBuffer) {
                return n * 8;
            }
            if (object instanceof CharBuffer) {
                return n * 2;
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.position() * nativeBuffer.elementSize();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static Object getArray(Object object) throws UnsupportedOperationException, IllegalArgumentException {
        if (object == null) {
            return null;
        }
        if (object instanceof Buffer) {
            return ((Buffer)object).array();
        }
        if (object instanceof NativeBuffer) {
            return ((NativeBuffer)object).array();
        }
        throw new IllegalArgumentException("Disallowed array backing store type in buffer " + object.getClass().getName());
    }

    public static int getIndirectBufferByteOffset(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Buffer) {
            int n = ((Buffer)object).position();
            if (object instanceof ByteBuffer) {
                return ((ByteBuffer)object).arrayOffset() + n;
            }
            if (object instanceof FloatBuffer) {
                return 4 * (((FloatBuffer)object).arrayOffset() + n);
            }
            if (object instanceof IntBuffer) {
                return 4 * (((IntBuffer)object).arrayOffset() + n);
            }
            if (object instanceof ShortBuffer) {
                return 2 * (((ShortBuffer)object).arrayOffset() + n);
            }
            if (object instanceof DoubleBuffer) {
                return 8 * (((DoubleBuffer)object).arrayOffset() + n);
            }
            if (object instanceof LongBuffer) {
                return 8 * (((LongBuffer)object).arrayOffset() + n);
            }
            if (object instanceof CharBuffer) {
                return 2 * (((CharBuffer)object).arrayOffset() + n);
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            return nativeBuffer.elementSize() * (nativeBuffer.arrayOffset() + nativeBuffer.position());
        }
        throw new IllegalArgumentException("Unknown buffer type " + object.getClass().getName());
    }

    public static ByteBuffer copyByteBuffer(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(byteBuffer.remaining());
        byteBuffer2.put(byteBuffer);
        byteBuffer2.rewind();
        return byteBuffer2;
    }

    public static FloatBuffer copyFloatBuffer(FloatBuffer floatBuffer) {
        return Buffers.copyFloatBufferAsByteBuffer(floatBuffer).asFloatBuffer();
    }

    public static IntBuffer copyIntBuffer(IntBuffer intBuffer) {
        return Buffers.copyIntBufferAsByteBuffer(intBuffer).asIntBuffer();
    }

    public static ShortBuffer copyShortBuffer(ShortBuffer shortBuffer) {
        return Buffers.copyShortBufferAsByteBuffer(shortBuffer).asShortBuffer();
    }

    public static ByteBuffer copyFloatBufferAsByteBuffer(FloatBuffer floatBuffer) {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(floatBuffer.remaining() * 4);
        byteBuffer.asFloatBuffer().put(floatBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyIntBufferAsByteBuffer(IntBuffer intBuffer) {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(intBuffer.remaining() * 4);
        byteBuffer.asIntBuffer().put(intBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static ByteBuffer copyShortBufferAsByteBuffer(ShortBuffer shortBuffer) {
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(shortBuffer.remaining() * 2);
        byteBuffer.asShortBuffer().put(shortBuffer);
        byteBuffer.rewind();
        return byteBuffer;
    }

    public static float[] getFloatArray(double[] dArray, int n, float[] fArray, int n2, int n3) {
        if (0 > n3) {
            n3 = dArray.length - n;
        }
        if (n3 > dArray.length - n) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining source bytes [len " + dArray.length + ", offset " + n + "]");
        }
        if (null == fArray) {
            fArray = new float[n3];
            n2 = 0;
        }
        if (n3 > fArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining dest bytes [len " + fArray.length + ", offset " + n2 + "]");
        }
        for (int i = 0; i < n3; ++i) {
            fArray[n2 + i] = (float)dArray[n + i];
        }
        return fArray;
    }

    public static FloatBuffer getFloatBuffer(DoubleBuffer doubleBuffer, FloatBuffer floatBuffer) {
        if (null == floatBuffer) {
            floatBuffer = Buffers.newDirectFloatBuffer(doubleBuffer.remaining());
        }
        if (floatBuffer.remaining() < doubleBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + doubleBuffer.remaining() + ") is greater than remaining dest bytes: " + floatBuffer.remaining());
        }
        while (doubleBuffer.hasRemaining()) {
            floatBuffer.put((float)doubleBuffer.get());
        }
        return floatBuffer;
    }

    public static double[] getDoubleArray(float[] fArray, int n, double[] dArray, int n2, int n3) {
        if (0 > n3) {
            n3 = fArray.length - n;
        }
        if (n3 > fArray.length - n) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining source bytes [len " + fArray.length + ", offset " + n + "]");
        }
        if (null == dArray) {
            dArray = new double[n3];
            n2 = 0;
        }
        if (n3 > dArray.length - n2) {
            throw new IllegalArgumentException("payload (" + n3 + ") greater than remaining dest bytes [len " + dArray.length + ", offset " + n2 + "]");
        }
        for (int i = 0; i < n3; ++i) {
            dArray[n2 + i] = fArray[n + i];
        }
        return dArray;
    }

    public static DoubleBuffer getDoubleBuffer(FloatBuffer floatBuffer, DoubleBuffer doubleBuffer) {
        if (null == doubleBuffer) {
            doubleBuffer = Buffers.newDirectDoubleBuffer(floatBuffer.remaining());
        }
        if (doubleBuffer.remaining() < floatBuffer.remaining()) {
            throw new IllegalArgumentException("payload (" + floatBuffer.remaining() + ") is greater than remaining dest bytes: " + doubleBuffer.remaining());
        }
        while (floatBuffer.hasRemaining()) {
            doubleBuffer.put(floatBuffer.get());
        }
        return doubleBuffer;
    }

    public static <B extends Buffer> B put(B b, Buffer buffer) {
        if (b instanceof ByteBuffer && buffer instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put((ByteBuffer)buffer);
        }
        if (b instanceof ShortBuffer && buffer instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put((ShortBuffer)buffer);
        }
        if (b instanceof IntBuffer && buffer instanceof IntBuffer) {
            return (B)((IntBuffer)b).put((IntBuffer)buffer);
        }
        if (b instanceof FloatBuffer && buffer instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((FloatBuffer)buffer);
        }
        if (b instanceof LongBuffer && buffer instanceof LongBuffer) {
            return (B)((LongBuffer)b).put((LongBuffer)buffer);
        }
        if (b instanceof DoubleBuffer && buffer instanceof DoubleBuffer) {
            return (B)((DoubleBuffer)b).put((DoubleBuffer)buffer);
        }
        if (b instanceof CharBuffer && buffer instanceof CharBuffer) {
            return (B)((CharBuffer)b).put((CharBuffer)buffer);
        }
        throw new IllegalArgumentException("Incompatible Buffer classes: dest = " + b.getClass().getName() + ", src = " + buffer.getClass().getName());
    }

    public static <B extends Buffer> B putb(B b, byte by) {
        if (b instanceof ByteBuffer) {
            return (B)((ByteBuffer)b).put(by);
        }
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(by);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(by);
        }
        throw new IllegalArgumentException("Byte doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B puts(B b, short s) {
        if (b instanceof ShortBuffer) {
            return (B)((ShortBuffer)b).put(s);
        }
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(s);
        }
        throw new IllegalArgumentException("Short doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B puti(B b, int n) {
        if (b instanceof IntBuffer) {
            return (B)((IntBuffer)b).put(n);
        }
        throw new IllegalArgumentException("Integer doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putf(B b, float f) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put(f);
        }
        throw new IllegalArgumentException("Float doesn't match Buffer Class: " + b);
    }

    public static <B extends Buffer> B putd(B b, double d) {
        if (b instanceof FloatBuffer) {
            return (B)((FloatBuffer)b).put((float)d);
        }
        throw new IllegalArgumentException("Double doesn't match Buffer Class: " + b);
    }

    public static void rangeCheck(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return;
        }
        if (byArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (byArray.length - n));
        }
    }

    public static void rangeCheck(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return;
        }
        if (cArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (cArray.length - n));
        }
    }

    public static void rangeCheck(short[] sArray, int n, int n2) {
        if (sArray == null) {
            return;
        }
        if (sArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (sArray.length - n));
        }
    }

    public static void rangeCheck(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return;
        }
        if (nArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (nArray.length - n));
        }
    }

    public static void rangeCheck(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return;
        }
        if (lArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (lArray.length - n));
        }
    }

    public static void rangeCheck(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return;
        }
        if (fArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (fArray.length - n));
        }
    }

    public static void rangeCheck(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return;
        }
        if (dArray.length < n + n2) {
            throw new ArrayIndexOutOfBoundsException("Required " + n2 + " elements in array, only had " + (dArray.length - n));
        }
    }

    public static void rangeCheck(Buffer buffer, int n) {
        if (buffer == null) {
            return;
        }
        if (buffer.remaining() < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining elements in buffer, only had " + buffer.remaining());
        }
    }

    public static void rangeCheckBytes(Object object, int n) {
        if (object == null) {
            return;
        }
        int n2 = 0;
        if (object instanceof Buffer) {
            int n3 = ((Buffer)object).remaining();
            if (object instanceof ByteBuffer) {
                n2 = n3;
            } else if (object instanceof FloatBuffer) {
                n2 = n3 * 4;
            } else if (object instanceof IntBuffer) {
                n2 = n3 * 4;
            } else if (object instanceof ShortBuffer) {
                n2 = n3 * 2;
            } else if (object instanceof DoubleBuffer) {
                n2 = n3 * 8;
            } else if (object instanceof LongBuffer) {
                n2 = n3 * 8;
            } else if (object instanceof CharBuffer) {
                n2 = n3 * 2;
            }
        } else if (object instanceof NativeBuffer) {
            NativeBuffer nativeBuffer = (NativeBuffer)object;
            n2 = nativeBuffer.remaining() * nativeBuffer.elementSize();
        }
        if (n2 < n) {
            throw new IndexOutOfBoundsException("Required " + n + " remaining bytes in buffer, only had " + n2);
        }
    }
}

