/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.jvm.JNILibLoaderBase;
import com.jogamp.common.os.DynamicLibraryBundleInfo;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.NativeLibrary;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class DynamicLibraryBundle
implements DynamicLookupHelper {
    protected static final boolean DEBUG = NativeLibrary.DEBUG;
    protected static final boolean DEBUG_LOOKUP = NativeLibrary.DEBUG_LOOKUP;
    private DynamicLibraryBundleInfo info;
    private List toolLibNames;
    private boolean[] toolLibLoaded;
    private int toolLibLoadedNumber;
    protected List nativeLibraries;
    private List glueLibNames;
    private boolean[] glueLibLoaded;
    private int glueLibLoadedNumber;
    private long toolGetProcAddressHandle;
    private HashSet toolGetProcAddressFuncNameSet;
    private List toolGetProcAddressFuncNameList;

    public DynamicLibraryBundle(DynamicLibraryBundleInfo dynamicLibraryBundleInfo) {
        if (null == dynamicLibraryBundleInfo) {
            throw new RuntimeException("Null DynamicLibraryBundleInfo");
        }
        this.info = dynamicLibraryBundleInfo;
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - DynamicLibraryBundle.init start with: " + dynamicLibraryBundleInfo.getClass().getName());
            Thread.dumpStack();
        }
        this.nativeLibraries = new ArrayList();
        this.toolLibNames = dynamicLibraryBundleInfo.getToolLibNames();
        this.glueLibNames = dynamicLibraryBundleInfo.getGlueLibNames();
        this.loadLibraries();
        this.toolGetProcAddressFuncNameList = dynamicLibraryBundleInfo.getToolGetProcAddressFuncNameList();
        if (null != this.toolGetProcAddressFuncNameList) {
            this.toolGetProcAddressFuncNameSet = new HashSet(this.toolGetProcAddressFuncNameList);
            this.toolGetProcAddressHandle = this.getToolGetProcAddressHandle();
        } else {
            this.toolGetProcAddressFuncNameSet = new HashSet();
            this.toolGetProcAddressHandle = 0L;
        }
        if (DEBUG) {
            System.err.println("DynamicLibraryBundle.init Summary: " + dynamicLibraryBundleInfo.getClass().getName());
            System.err.println("     toolGetProcAddressFuncNameList: " + this.toolGetProcAddressFuncNameList);
            System.err.println("     Tool Lib Names : " + this.toolLibNames);
            System.err.println("     Tool Lib Loaded: " + this.getToolLibLoadedNumber() + "/" + this.getToolLibNumber() + ", complete " + this.isToolLibComplete());
            System.err.println("     Glue Lib Names : " + this.glueLibNames);
            System.err.println("     Glue Lib Loaded: " + this.getGlueLibLoadedNumber() + "/" + this.getGlueLibNumber() + ", complete " + this.isGlueLibComplete());
            System.err.println("     All Complete: " + this.isLibComplete());
        }
    }

    public final boolean isLibComplete() {
        return this.isToolLibComplete() && this.isGlueLibComplete();
    }

    public final int getToolLibNumber() {
        return this.toolLibNames.size();
    }

    public final int getToolLibLoadedNumber() {
        return this.toolLibLoadedNumber;
    }

    public final boolean isToolLibComplete() {
        return this.getToolLibNumber() == this.getToolLibLoadedNumber();
    }

    public final boolean isToolLibLoaded() {
        return 0 < this.toolLibLoadedNumber;
    }

    public final boolean isToolLibLoaded(int n) {
        if (0 <= n && n < this.toolLibLoaded.length) {
            return this.toolLibLoaded[n];
        }
        return false;
    }

    public final int getGlueLibNumber() {
        return this.glueLibNames.size();
    }

    public final int getGlueLibLoadedNumber() {
        return this.glueLibLoadedNumber;
    }

    public final boolean isGlueLibComplete() {
        return this.getGlueLibNumber() == this.getGlueLibLoadedNumber();
    }

    public final boolean isGlueLibLoaded(int n) {
        if (0 <= n && n < this.glueLibLoaded.length) {
            return this.glueLibLoaded[n];
        }
        return false;
    }

    public final DynamicLibraryBundleInfo getBundleInfo() {
        return this.info;
    }

    protected long getToolGetProcAddressHandle() {
        if (!this.isToolLibLoaded()) {
            return 0L;
        }
        long l = 0L;
        Iterator iterator = this.toolGetProcAddressFuncNameList.iterator();
        while (0L == l && iterator.hasNext()) {
            String string = (String)iterator.next();
            l = this.dynamicLookupFunctionOnLibs(string);
            if (!DEBUG) continue;
            System.err.println("getToolGetProcAddressHandle: " + string + " -> 0x" + Long.toHexString(l));
        }
        return l;
    }

    protected NativeLibrary loadFirstAvailable(List list, ClassLoader classLoader, boolean bl) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NativeLibrary nativeLibrary = NativeLibrary.open((String)iterator.next(), classLoader, bl);
            if (nativeLibrary == null) continue;
            return nativeLibrary;
        }
        return null;
    }

    private void loadLibraries() {
        int n;
        if (null == this.toolLibNames || this.toolLibNames.size() == 0) {
            if (DEBUG) {
                System.err.println("No Tool native library names given");
            }
            return;
        }
        if (null == this.glueLibNames || this.glueLibNames.size() == 0) {
            if (DEBUG) {
                System.err.println("No Glue native library names given");
            }
            return;
        }
        this.toolLibLoadedNumber = 0;
        this.toolLibLoaded = new boolean[this.toolLibNames.size()];
        for (n = 0; n < this.toolLibNames.size(); ++n) {
            this.toolLibLoaded[n] = false;
        }
        this.glueLibLoaded = new boolean[this.glueLibNames.size()];
        for (n = 0; n < this.glueLibNames.size(); ++n) {
            this.glueLibLoaded[n] = false;
        }
        ClassLoader classLoader = this.getClass().getClassLoader();
        NativeLibrary nativeLibrary = null;
        n = 0;
        for (Object object : this.toolLibNames) {
            ArrayList<String> arrayList = null;
            if (object instanceof List) {
                arrayList = (ArrayList<String>)object;
            } else if (object instanceof String) {
                arrayList = new ArrayList<String>();
                arrayList.add((String)object);
            } else {
                throw new RuntimeException("List element " + n + " must be either a List or String: " + this.toolLibNames);
            }
            if (null != arrayList && arrayList.size() > 0) {
                nativeLibrary = this.loadFirstAvailable(arrayList, classLoader, this.info.shallLinkGlobal());
                if (null == nativeLibrary) {
                    if (DEBUG) {
                        System.err.println("Unable to load any Tool library of: " + arrayList);
                    }
                } else {
                    this.nativeLibraries.add(nativeLibrary);
                    this.toolLibLoaded[n] = true;
                    ++this.toolLibLoadedNumber;
                    if (DEBUG) {
                        System.err.println("Loaded Tool library: " + nativeLibrary);
                    }
                }
            }
            ++n;
        }
        if (!this.isToolLibLoaded()) {
            if (DEBUG) {
                System.err.println("No Tool libraries loaded");
            }
            return;
        }
        this.glueLibLoadedNumber = 0;
        n = 0;
        for (Object object : this.glueLibNames) {
            boolean bl;
            block23: {
                boolean bl2 = true;
                try {
                    bl = GlueJNILibLoaderBase.loadLibrary(object, bl2);
                    if (DEBUG && !bl) {
                        System.err.println("Info: Could not load JNI/Glue library: " + object);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    bl = false;
                    if (!DEBUG) break block23;
                    System.err.println("Unable to load JNI/Glue library: " + object);
                    unsatisfiedLinkError.printStackTrace();
                }
            }
            this.glueLibLoaded[n] = bl;
            if (bl) {
                ++this.glueLibLoadedNumber;
            }
            ++n;
        }
    }

    private long dynamicLookupFunctionOnLibs(String string) {
        if (!this.isToolLibLoaded() || null == string) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println("Lookup-Native: <" + string + "> ** FAILED ** Tool native library not loaded");
            }
            return 0L;
        }
        long l = 0L;
        NativeLibrary nativeLibrary = null;
        if (this.info.shallLookupGlobal()) {
            l = NativeLibrary.dynamicLookupFunctionGlobal(string);
        }
        Object object = this.nativeLibraries.iterator();
        while (0L == l && object.hasNext()) {
            nativeLibrary = (NativeLibrary)object.next();
            l = nativeLibrary.dynamicLookupFunction(string);
        }
        if (DEBUG_LOOKUP) {
            Object object2 = object = null == nativeLibrary ? "GLOBAL" : nativeLibrary.toString();
            if (0L != l) {
                System.err.println("Lookup-Native: <" + string + "> 0x" + Long.toHexString(l) + " in lib " + (String)object);
            } else {
                System.err.println("Lookup-Native: <" + string + "> ** FAILED ** in libs " + this.nativeLibraries);
            }
        }
        return l;
    }

    @Override
    public long dynamicLookupFunction(String string) {
        if (!this.isToolLibLoaded() || null == string) {
            if (DEBUG_LOOKUP && !this.isToolLibLoaded()) {
                System.err.println("Lookup: <" + string + "> ** FAILED ** Tool native library not loaded");
            }
            return 0L;
        }
        if (this.toolGetProcAddressFuncNameSet.contains(string)) {
            return this.toolGetProcAddressHandle;
        }
        long l = 0L;
        if (0L != this.toolGetProcAddressHandle) {
            l = this.info.toolDynamicLookupFunction(this.toolGetProcAddressHandle, string);
            if (DEBUG_LOOKUP && 0L != l) {
                System.err.println("Lookup-Tool: <" + string + "> 0x" + Long.toHexString(l));
            }
        }
        if (0L == l) {
            l = this.dynamicLookupFunctionOnLibs(string);
        }
        return l;
    }

    static class GlueJNILibLoaderBase
    extends JNILibLoaderBase {
        GlueJNILibLoaderBase() {
        }

        protected static synchronized boolean loadLibrary(String string, boolean bl) {
            return JNILibLoaderBase.loadLibrary(string, bl);
        }
    }
}

