/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.os.Platform;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;

public class IOUtil {
    private IOUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyURL2File(URL uRL, File file) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.connect();
        int n = 0;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            try {
                n = IOUtil.copyStream2Stream(bufferedInputStream, bufferedOutputStream, uRLConnection.getContentLength());
            }
            finally {
                ((OutputStream)bufferedOutputStream).close();
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        return n;
    }

    public static int copyStream2Stream(InputStream inputStream, OutputStream outputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[Platform.getPageSize()];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n2);
            n3 += n2;
        }
        return n3;
    }

    public static byte[] copyStream2ByteArray(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        do {
            if (n + n2 > byArray2.length) {
                byArray = new byte[n + n2];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if ((n3 = inputStream.read(byArray2, n, n2)) < 0) continue;
            n += n3;
        } while ((n2 = inputStream.available()) > 0 && n3 >= 0);
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    public static ByteBuffer copyStream2ByteBuffer(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        int n = 0;
        int n2 = inputStream.available();
        ByteBuffer byteBuffer = Buffers.newDirectByteBuffer(Platform.getPageAlignedSize(n2));
        byte[] byArray = new byte[Platform.getPageSize()];
        int n3 = Math.min(Platform.getPageSize(), n2);
        int n4 = 0;
        do {
            if (n2 > byteBuffer.remaining()) {
                ByteBuffer byteBuffer2 = Buffers.newDirectByteBuffer(Platform.getPageAlignedSize(byteBuffer.position() + n2));
                byteBuffer2.put(byteBuffer);
                byteBuffer = byteBuffer2;
            }
            if ((n4 = inputStream.read(byArray, 0, n3)) >= 0) {
                byteBuffer.put(byArray, 0, n4);
                n += n4;
            }
            n2 = inputStream.available();
            n3 = Math.min(Platform.getPageSize(), n2);
        } while (n2 > 0 && n4 >= 0);
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String getFileSuffix(File file) {
        return IOUtil.getFileSuffix(file.getName());
    }

    public static String getFileSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return IOUtil.toLowerCase(string.substring(n + 1));
    }

    private static String toLowerCase(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    public static URL getResource(Class clazz, String string) {
        String string2;
        int n;
        if (null == string) {
            return null;
        }
        ClassLoader classLoader = null != clazz ? clazz.getClassLoader() : null;
        URL uRL = IOUtil.getResource(string, classLoader);
        if (uRL == null && null != clazz && (n = (string2 = clazz.getName().replace('.', '/')).lastIndexOf(47)) >= 0) {
            String string3 = string2.substring(0, n + 1) + string;
            uRL = IOUtil.getResource(string3, classLoader);
        }
        return uRL;
    }

    public static URL getResource(String string, ClassLoader classLoader) {
        if (null == string) {
            return null;
        }
        URL uRL = null;
        if (classLoader != null && !IOUtil.urlExists(uRL = classLoader.getResource(string))) {
            uRL = null;
        }
        if (null == uRL && !IOUtil.urlExists(uRL = ClassLoader.getSystemResource(string))) {
            uRL = null;
        }
        if (null == uRL) {
            try {
                uRL = new URL(string);
                if (!IOUtil.urlExists(uRL)) {
                    uRL = null;
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (null == uRL) {
            try {
                File file = new File(string);
                if (file.exists()) {
                    uRL = file.toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static String getRelativeOf(File file, String string) {
        if (null == string) {
            return null;
        }
        while (file != null && string.startsWith("../")) {
            file = file.getParentFile();
            string = string.substring(3);
        }
        if (file != null) {
            File file2 = new File(file, string);
            return file2.getPath().replace('\\', '/');
        }
        return null;
    }

    public static String getRelativeOf(URL uRL, String string) {
        String string2 = uRL.getPath();
        if (uRL.toString().startsWith("jar")) {
            try {
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                string2 = jarURLConnection.getEntryName();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return IOUtil.getRelativeOf(new File(string2).getParentFile(), string);
    }

    public static boolean urlExists(URL uRL) {
        boolean bl = false;
        if (null != uRL) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }
}

