/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util;

import com.jogamp.common.os.Platform;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionUtil {
    public static final String SEPERATOR = "-----------------------------------------------------------------------------------------------------";

    public static StringBuilder getPlatformInfo(StringBuilder stringBuilder) {
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        stringBuilder.append(SEPERATOR).append(Platform.getNewline());
        stringBuilder.append("Platform: ").append(Platform.getOS()).append(' ').append(Platform.getOSVersion()).append(" (os), ");
        stringBuilder.append(Platform.getArch()).append(" (arch) ").append(Runtime.getRuntime().availableProcessors()).append(" cores");
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("Platform: littleEndian ").append(Platform.isLittleEndian()).append(", 32Bit ");
        stringBuilder.append(Platform.is32Bit()).append(", a-ptr bit-size ").append(Platform.getPointerSizeInBits());
        stringBuilder.append(Platform.getNewline());
        stringBuilder.append("Platform: Java ").append(Platform.getJavaVersion()).append(", ").append(System.getProperty("java.vm.name")).append(", ");
        stringBuilder.append(Platform.getJavaVendor()).append(", ").append(Platform.getJavaVendorURL()).append(", is JavaSE: ").append(Platform.isJavaSE());
        stringBuilder.append(Platform.getNewline()).append(SEPERATOR);
        return stringBuilder;
    }

    public static String getPlatformInfo() {
        return VersionUtil.getPlatformInfo(null).toString();
    }

    public static Manifest getManifest(ClassLoader classLoader, String string) {
        try {
            Enumeration<URL> enumeration = classLoader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                Manifest manifest = new Manifest(enumeration.nextElement().openStream());
                Attributes attributes = manifest.getMainAttributes();
                if (attributes == null || !string.equals(attributes.getValue(Attributes.Name.EXTENSION_NAME))) continue;
                return manifest;
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to read manifest.", iOException);
        }
        return null;
    }

    public static StringBuilder getFullManifestInfo(Manifest manifest, StringBuilder stringBuilder) {
        if (null == manifest) {
            return stringBuilder;
        }
        if (null == stringBuilder) {
            stringBuilder = new StringBuilder();
        }
        Attributes attributes = manifest.getMainAttributes();
        Set<Object> set = attributes.keySet();
        for (Attributes.Name name : set) {
            String string = attributes.getValue(name);
            stringBuilder.append(" ");
            stringBuilder.append(name);
            stringBuilder.append(" = ");
            stringBuilder.append(string);
            stringBuilder.append(Platform.getNewline());
        }
        return stringBuilder;
    }
}

