/*
 * Decompiled with CFR 0.152.
 */
package jogamp.common.util.locks;

import com.jogamp.common.util.locks.SingletonInstance;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class SingletonInstanceServerSocket
extends SingletonInstance {
    private final Server singletonServer;
    private final String fullName;

    public SingletonInstanceServerSocket(long l, int n) {
        super(l);
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(null);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getByName("localhost");
                if (null != inetAddress && !inetAddress.isLoopbackAddress()) {
                    inetAddress = null;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
                if (null != inetAddress && !inetAddress.isLoopbackAddress()) {
                    inetAddress = null;
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            try {
                inetAddress = InetAddress.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        if (null == inetAddress) {
            throw new RuntimeException("Could not determine local InetAddress");
        }
        this.fullName = inetAddress.toString() + ":" + n;
        this.singletonServer = new Server(inetAddress, n);
    }

    public final InetAddress getLocalInetAddress() {
        return this.singletonServer.getLocalInetAddress();
    }

    public final int getPortNumber() {
        return this.singletonServer.getPortNumber();
    }

    @Override
    public final String getName() {
        return this.fullName;
    }

    @Override
    protected boolean tryLockImpl() {
        if (this.singletonServer.isRunning()) {
            return false;
        }
        Socket socket = this.singletonServer.connect();
        if (null != socket) {
            try {
                socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
        return this.singletonServer.start();
    }

    @Override
    protected boolean unlockImpl() {
        return this.singletonServer.shutdown();
    }

    public class Server
    implements Runnable {
        private final InetAddress localInetAddress;
        private final int portNumber;
        private volatile boolean shallQuit = false;
        private volatile boolean alive = false;
        private Object syncOnStartStop = new Object();
        private ServerSocket serverSocket = null;

        public Server(InetAddress inetAddress, int n) {
            this.localInetAddress = inetAddress;
            this.portNumber = n;
        }

        public final InetAddress getLocalInetAddress() {
            return this.localInetAddress;
        }

        public final int getPortNumber() {
            return this.portNumber;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean start() {
            if (this.alive) {
                return true;
            }
            Thread thread = new Thread((Runnable)this, "SingletonInstanceServerSocket: " + SingletonInstanceServerSocket.this.getName());
            thread.setDaemon(true);
            Object object = this.syncOnStartStop;
            synchronized (object) {
                thread.start();
                try {
                    this.syncOnStartStop.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            boolean bl = this.isBound();
            if (!bl) {
                this.shutdown();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean shutdown() {
            if (!this.alive) {
                return true;
            }
            Object object = this.syncOnStartStop;
            synchronized (object) {
                this.shallQuit = true;
                this.connect();
                try {
                    this.syncOnStartStop.wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            if (this.alive) {
                System.err.println("SLOCK " + System.currentTimeMillis() + " EEE " + SingletonInstanceServerSocket.this.getName() + " - Unable to remove lock: ServerThread still alive ?");
            }
            return !this.alive;
        }

        public final boolean isRunning() {
            return this.alive;
        }

        public final boolean isBound() {
            return this.alive && null != this.serverSocket && this.serverSocket.isBound();
        }

        public final Socket connect() {
            try {
                return new Socket(this.localInetAddress, this.portNumber);
            }
            catch (Exception exception) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.alive = false;
            Object object = this.syncOnStartStop;
            synchronized (object) {
                try {
                    this.serverSocket = new ServerSocket(this.portNumber, 1, this.localInetAddress);
                    this.alive = true;
                }
                catch (IOException iOException) {
                    System.err.println("SLOCK " + System.currentTimeMillis() + " EEE " + SingletonInstanceServerSocket.this.getName() + " - Unable to install ServerSocket: " + iOException.getMessage());
                    this.shallQuit = true;
                }
                finally {
                    this.syncOnStartStop.notifyAll();
                }
            }
            while (!this.shallQuit) {
                try {
                    object = this.serverSocket.accept();
                    ((Socket)object).close();
                }
                catch (IOException iOException) {
                    System.err.println("SLOCK " + System.currentTimeMillis() + " EEE " + SingletonInstanceServerSocket.this.getName() + " - Exception during accept: " + iOException.getMessage());
                }
            }
            object = this.syncOnStartStop;
            synchronized (object) {
                try {
                    if (null != this.serverSocket) {
                        this.serverSocket.close();
                    }
                }
                catch (IOException iOException) {
                    System.err.println("SLOCK " + System.currentTimeMillis() + " EEE " + SingletonInstanceServerSocket.this.getName() + " - Exception during close: " + iOException.getMessage());
                }
                finally {
                    this.serverSocket = null;
                    this.alive = false;
                    this.shallQuit = false;
                    this.syncOnStartStop.notifyAll();
                }
            }
        }
    }
}

