package generate;
import main.Main;
import show2D.ObservedImageFrame;
import Jama.Matrix;


public class GenerateImage {
	
	private int x,y,z;		
	double maxOfX, maxOfY, maxOfZ, minOfX, minOfY, minOfZ, vx, vy, vz;
	public static int obsX, obsY, obsZ, obsXr, obsYr, obsZr, offsX, offsY, offsZ, maxOfXr, maxOfYr, maxOfZr, minOfXr, minOfYr, minOfZr;
	Matrix transfmMatrix;
	Matrix invTransfmMatrix;
	
	byte[] ObservedImageDataPuffer;

	public GenerateImage(int x, int y, int z, Matrix M){
		this.x = x;
		this.y = y;
		this.z = z;
		offsX = Main.SourceOffset[0];
		offsY = Main.SourceOffset[1];
		offsZ = Main.SourceOffset[2];
		
		vx =  Main.sVx;
		vy =  Main.sVy;
		vz =  Main.sVz;
		
		Main.oVx = new Float(vx);
		Main.oVy = new Float(vy);
		Main.oVz = new Float(vz);
				
		transfmMatrix = M.copy();
		invTransfmMatrix = transfmMatrix.inverse();

		Matrix T1 = Matrix.identity(4, 4);
		T1.set(0, 0, vx);
		T1.set(1, 1, vy);
		T1.set(2, 2, vz);
		
		Matrix T2 = Matrix.identity(4, 4);
		T2.set(0, 0, 1.0 / vx);
		T2.set(1, 1, 1.0 / vy);
		T2.set(2, 2, 1.0 / vz);
		
		Matrix T22 = Matrix.identity(4, 4);
		T22.set(0, 3, -offsX);
		T22.set(1, 3, -offsY);
		T22.set(2, 3, -offsZ);
		
		Matrix T11 = Matrix.identity(4, 4);
		T11.set(0, 3, offsX);
		T11.set(1, 3, offsY);
		T11.set(2, 3, offsZ);
		
		transfmMatrix = T2.times(transfmMatrix).times(T1).times(T11);	
		invTransfmMatrix = T22.times(T2).times(invTransfmMatrix).times(T1);
			
	}
	
	public void GenerateObservedImage(){
		
		Main.frame.SetMainTitile(" - Generating observed image...");
		long start = System.currentTimeMillis();
		
		getDimensionsOfGenImage();
		GenImage();
		Transform();
		Resize();
		long end = System.currentTimeMillis();

		Main.isGen = true;
		
		Main.frame.SetMainTitile(" - Generating observed image... finished! (" + ((end-start)/1000.0) + " sec)");
		Main.observedGenReadTime = (end-start)/1000.0f;
		Main.Observedframe = new ObservedImageFrame(obsXr, obsYr, obsZr, 8, obsXr * obsYr * obsZr);
		
	}
	
	private void getDimensionsOfGenImage(){
		
		maxOfX = maxOfY = maxOfZ = Double.MIN_VALUE;
		minOfX = minOfY = minOfZ = Double.MAX_VALUE;
		
		double[] point1 = {0.0, 	0.0, 	 0.0, 	  1.0};
		double[] point2 = {0.0, 	0.0, 	 z - 1.0, 1.0};
		double[] point3 = {x - 1.0, 0.0, 	 z - 1.0, 1.0};
		double[] point4 = {x - 1.0,	0.0, 	 0.0, 	  1.0};
		double[] point5 = {0.0, 	y - 1.0, 0.0, 	  1.0};
		double[] point6 = {0.0, 	y - 1.0, z - 1.0, 1.0};
		double[] point7 = {x - 1.0, y - 1.0, z - 1.0, 1.0};
		double[] point8 = {x - 1.0, y - 1.0, 0.0, 	  1.0};
		
		Matrix[] points = new Matrix[8];
		
		points[0] = new Matrix(point1, 4);
		points[1] = new Matrix(point2, 4);
		points[2] = new Matrix(point3, 4);
		points[3] = new Matrix(point4, 4);
		points[4] = new Matrix(point5, 4);
		points[5] = new Matrix(point6, 4);
		points[6] = new Matrix(point7, 4);
		points[7] = new Matrix(point8, 4);
		
		points[0] = transfmMatrix.times(points[0]);
		points[1] = transfmMatrix.times(points[1]);
		points[2] = transfmMatrix.times(points[2]);
		points[3] = transfmMatrix.times(points[3]);
		points[4] = transfmMatrix.times(points[4]);
		points[5] = transfmMatrix.times(points[5]);
		points[6] = transfmMatrix.times(points[6]);
		points[7] = transfmMatrix.times(points[7]);

		for (int i = 0; i < 8; i++) {
			
			if (points[i].get(0, 0) > maxOfX){
				maxOfX = points[i].get(0, 0);
			}
			
			if (points[i].get(1, 0) > maxOfY){
				maxOfY = points[i].get(1, 0);
			}
			
			if (points[i].get(2, 0) > maxOfZ){
				maxOfZ = points[i].get(2, 0);
			}
			
			if (points[i].get(0, 0) < minOfX){
				minOfX = points[i].get(0, 0);
			}
			
			if (points[i].get(1, 0) < minOfY){
				minOfY = points[i].get(1, 0);
			}
			
			if (points[i].get(2, 0) < minOfZ){
				minOfZ = points[i].get(2, 0);
			}
		}
	}
	
	public void GenImage(){
		
		obsX = (int)Math.abs(maxOfX - minOfX) + 1;
		obsY = (int)Math.abs(maxOfY - minOfY) + 1;
		obsZ = (int)Math.abs(maxOfZ - minOfZ) + 1;
						
		ObservedImageDataPuffer = new byte[obsX * obsY * obsZ];

		minOfX = Math.round(minOfX);
		minOfY = Math.round(minOfY);
		minOfZ = Math.round(minOfZ);
	}
	
	public void Transform(){
				
		double[][] invMatrix = invTransfmMatrix.getArray();
		int srcX, srcY, srcZ, SourceSliceArea = x * y;
		
		double t11x, t21x, t31x;
		double t12y, t22y, t32y;
		double t13z, t23z, t33z;
		
		double initT12y = minOfY * invMatrix[0][1];
		double initT22y = minOfY * invMatrix[1][1];
		double initT32y = minOfY * invMatrix[2][1];
		double initT11x = minOfX * invMatrix[0][0];
		double initT21x = minOfX * invMatrix[1][0];
		double initT31x = minOfX * invMatrix[2][0];
		
		t13z = invMatrix[0][3] + minOfZ * invMatrix[0][2];
		t23z = invMatrix[1][3] + minOfZ * invMatrix[1][2];
		t33z = invMatrix[2][3] + minOfZ * invMatrix[2][2];
		
		maxOfXr = maxOfYr = maxOfZr = Integer.MIN_VALUE;
		minOfXr = minOfYr = minOfZr = Integer.MAX_VALUE;
		byte value;
		
		int index = 0;
		
		for (int k = 0; k < obsZ; k++) {
			
			t12y = initT12y; t22y = initT22y; t32y = initT32y;
			
			for (int j = 0; j < obsY; j++) {
				
				t11x = initT11x; t21x = initT21x; t31x = initT31x;
				
				for (int i = 0; i < obsX; i++){
					
					srcX = (int)Math.round(t11x + t12y + t13z);
					srcY = (int)Math.round(t21x + t22y + t23z);
					srcZ = (int)Math.round(t31x + t32y + t33z);
					
					t11x += invMatrix[0][0]; t21x += invMatrix[1][0]; t31x += invMatrix[2][0];
					
					if (srcZ >= z || srcY >= y || srcX >= x || srcZ < 0.0 || srcY < 0.0 || srcX < 0.0){
						index++;
						continue;
					}
					
					value = Main.imageData[srcZ * SourceSliceArea + srcY * x + srcX];

					ObservedImageDataPuffer[index] = value;
					
					if (value != 0){
					
						if (i > maxOfXr){
							maxOfXr = i;
						}
						
						if (j > maxOfYr){
							maxOfYr = j;
						}
						
						if (k > maxOfZr){
							maxOfZr = k;
						}
						
						if (i < minOfXr){
							minOfXr = i;
						}
						
						if (j < minOfYr){
							minOfYr = j;
						}
						
						if (k < minOfZr){
							minOfZr = k;
						}
					}
					
					index++;
			
				}
				
				t12y += invMatrix[0][1]; t22y += invMatrix[1][1]; t32y += invMatrix[2][1];
			}
			t13z += invMatrix[0][2]; t23z += invMatrix[1][2]; t33z += invMatrix[2][2];
		}
		
		obsXr = maxOfXr - minOfXr + 1;
		obsYr = maxOfYr - minOfYr + 1;
		obsZr = maxOfZr - minOfZr + 1;
			
	}
	
	public void Resize(){
		
		Main.ObservedImageData = new byte[obsXr * obsYr * obsZr];
		
		int observedSliceArea = obsX * obsY, slice2, row2;
		
		int index = 0;
		
		for (int k = 0; k < obsZr; k++) {
			slice2 = (k+minOfZr)*observedSliceArea;
			for (int j = 0; j < obsYr; j++) {
				row2 = (j+minOfYr)*obsX;
				for (int i = 0; i < obsXr; i++) {
					
					try{
						Main.ObservedImageData[index] = ObservedImageDataPuffer[slice2 + row2 + i + minOfXr];
						index++;
					}catch (Exception e) {
						index++;
						continue;
					}
					
				}
			}
		}
		
		Main.generatedObservedX = obsXr;
		Main.generatedObservedY = obsYr;
		Main.generatedObservedZ = obsZr;

		Main.ObservedOffset[0] = (int)Math.round(minOfX + minOfXr);
		Main.ObservedOffset[1] = (int)Math.round(minOfY + minOfYr);
		Main.ObservedOffset[2] = (int)Math.round(minOfZ + minOfZr);
		
	}
	
}
