package generate;

import main.Main;
import show2D.ResultImageFrame;
import Jama.Matrix;

public class GenerateResultImage {
	private int x,y,z;
	Matrix transfmMatrix;
	Matrix invTransfmMatrix;
		
	double maxOfX, maxOfY, maxOfZ, minOfX, minOfY, minOfZ, oVx, oVy, oVz, sVy, sVz, sVx;
	int maxOfXr, maxOfYr, maxOfZr, minOfXr, minOfYr, minOfZr;
	int maxOfXrr, maxOfYrr, maxOfZrr, minOfXrr, minOfYrr, minOfZrr;
	int min1 = 0, min2 = 0, min3 = 0, max1 = 0, max2 = 0, max3 = 0;
	int offsX, offsY, offsZ;
	public static int obsX, obsY, obsZ;
	public int obsXr, obsYr, obsZr;
	public int offResX, offResY, offResZ;
	
	public static int whiteVoxel, badVoxel, sorceWhiteVoxel, xorWhiteVoxel;
	
	byte[][][] XorImagePuffer;
	

	public GenerateResultImage(int x, int y, int z, Matrix M){
		this.x = x;
		this.y = y;
		this.z = z;
		offsX = Main.ObservedOffset[0];
		offsY = Main.ObservedOffset[1];
		offsZ = Main.ObservedOffset[2];
		
		oVx =  Main.oVx;
		oVy =  Main.oVy;
		oVz =  Main.oVz;
		
		sVx =  Main.sVx;
		sVy =  Main.sVy;
		sVz =  Main.sVz;
		
		invTransfmMatrix = M.copy();
		transfmMatrix = invTransfmMatrix.inverse();	
		
		Matrix T1 = Matrix.identity(4, 4);
		T1.set(0, 0, oVx);
		T1.set(1, 1, oVy);
		T1.set(2, 2, oVz);
		
		Matrix T3 = Matrix.identity(4, 4);
		T3.set(0, 0, sVx);
		T3.set(1, 1, sVy);
		T3.set(2, 2, sVz);
		
		Matrix T2 = Matrix.identity(4, 4);
		T2.set(0, 0, 1.0 / sVx);
		T2.set(1, 1, 1.0 / sVy);
		T2.set(2, 2, 1.0 / sVz);
		
		Matrix T4 = Matrix.identity(4, 4);
		T4.set(0, 0, 1.0 / oVx);
		T4.set(1, 1, 1.0 / oVy);
		T4.set(2, 2, 1.0 / oVz);
		
		Matrix T22 = Matrix.identity(4, 4);
		T22.set(0, 3, -offsX);
		T22.set(1, 3, -offsY);
		T22.set(2, 3, -offsZ);
		
		Matrix T11 = Matrix.identity(4, 4);
		T11.set(0, 3, offsX);
		T11.set(1, 3, offsY);
		T11.set(2, 3, offsZ);
		
		transfmMatrix = T2.times(transfmMatrix).times(T1).times(T11);	
		invTransfmMatrix = T22.times(T4).times(invTransfmMatrix).times(T3);

	}
	
	public void GenerateImage(){
		
		Main.frame.SetMainTitile(" - Generating Result image...");		
		long start = System.currentTimeMillis();
		
		getDimensionsOfGenImage();
		GenImage();
		Transform();
		Resize();
		long end = System.currentTimeMillis();

		Main.frame.SetMainTitile(" - Generating Result image... finished! (" + ((end-start)/1000.0) + " sec)");
		Main.resultGenTime = (end-start)/1000.0f;
		Main.lblGeometricError.setText("Delta error: " + (double)Math.round(((double)badVoxel/((double)xorWhiteVoxel + (double)sorceWhiteVoxel))*100000000.0)/1000000.0 + "%  (" + badVoxel +" voxel difference)");
		Main.XorFrame = new ResultImageFrame(obsXr, obsYr, obsZr);

		
	}
	
	private void getDimensionsOfGenImage(){
		
		maxOfX = maxOfY = maxOfZ = Double.MIN_VALUE;
		minOfX = minOfY = minOfZ = Double.MAX_VALUE;
		
		double[] point1 = {0.0, 	0.0, 	 0.0, 	  1.0};
		double[] point2 = {0.0, 	0.0, 	 z - 1.0, 1.0};
		double[] point3 = {x - 1.0, 0.0, 	 z - 1.0, 1.0};
		double[] point4 = {x - 1.0,	0.0, 	 0.0, 	  1.0};
		double[] point5 = {0.0, 	y - 1.0, 0.0, 	  1.0};
		double[] point6 = {0.0, 	y - 1.0, z - 1.0, 1.0};
		double[] point7 = {x - 1.0, y - 1.0, z - 1.0, 1.0};
		double[] point8 = {x - 1.0, y - 1.0, 0.0, 	  1.0};
		
		Matrix[] points = new Matrix[8];
		
		points[0] = new Matrix(point1, 4);
		points[1] = new Matrix(point2, 4);
		points[2] = new Matrix(point3, 4);
		points[3] = new Matrix(point4, 4);
		points[4] = new Matrix(point5, 4);
		points[5] = new Matrix(point6, 4);
		points[6] = new Matrix(point7, 4);
		points[7] = new Matrix(point8, 4);
		
		points[0] = transfmMatrix.times(points[0]);
		points[1] = transfmMatrix.times(points[1]);
		points[2] = transfmMatrix.times(points[2]);
		points[3] = transfmMatrix.times(points[3]);
		points[4] = transfmMatrix.times(points[4]);
		points[5] = transfmMatrix.times(points[5]);
		points[6] = transfmMatrix.times(points[6]);
		points[7] = transfmMatrix.times(points[7]);
		
		for (int i = 0; i < 8; i++) {
			
			if (points[i].get(0, 0) > maxOfX){
				maxOfX = points[i].get(0, 0);
			}
			
			if (points[i].get(1, 0) > maxOfY){
				maxOfY = points[i].get(1, 0);
			}
			
			if (points[i].get(2, 0) > maxOfZ){
				maxOfZ = points[i].get(2, 0);
			}
			
			if (points[i].get(0, 0) < minOfX){
				minOfX = points[i].get(0, 0);
			}
			
			if (points[i].get(1, 0) < minOfY){
				minOfY = points[i].get(1, 0);
			}
			
			if (points[i].get(2, 0) < minOfZ){
				minOfZ = points[i].get(2, 0);
			}
		}
	}

	
	public void GenImage(){
		
		obsX = (int)Math.abs(maxOfX - minOfX) + 1;
		obsY = (int)Math.abs(maxOfY - minOfY) + 1;
		obsZ = (int)Math.abs(maxOfZ - minOfZ) + 1;
		
		XorImagePuffer = new byte[obsX][obsY ][obsZ];
		
		minOfX = Math.round(minOfX);
		minOfY = Math.round(minOfY);
		minOfZ = Math.round(minOfZ);
	}
	
	public void Transform(){
				
		double[][] invMatrix = invTransfmMatrix.getArray();
		int srcX, srcY, srcZ, SourceSliceArea = x * y;
		
		double t11x, t21x, t31x;
		double t12y, t22y, t32y;
		double t13z, t23z, t33z;
		
		double initT12y = minOfY * invMatrix[0][1];
		double initT22y = minOfY * invMatrix[1][1];
		double initT32y = minOfY * invMatrix[2][1];
		double initT11x = minOfX * invMatrix[0][0];
		double initT21x = minOfX * invMatrix[1][0];
		double initT31x = minOfX * invMatrix[2][0];
		
		t13z = invMatrix[0][3] + minOfZ * invMatrix[0][2];
		t23z = invMatrix[1][3] + minOfZ * invMatrix[1][2];
		t33z = invMatrix[2][3] + minOfZ * invMatrix[2][2];
		
		maxOfXr = maxOfYr = maxOfZr = Integer.MIN_VALUE;
		minOfXr = minOfYr = minOfZr = Integer.MAX_VALUE;
		byte value;		
		
		for (int k = 0; k < obsZ; k++) {
			
			t12y = initT12y; t22y = initT22y; t32y = initT32y;
			
			for (int j = 0; j < obsY; j++) {
				
				t11x = initT11x; t21x = initT21x; t31x = initT31x;
				
				for (int i = 0; i < obsX; i++){
					
					srcX = (int)Math.round(t11x + t12y + t13z);
					srcY = (int)Math.round(t21x + t22y + t23z);
					srcZ = (int)Math.round(t31x + t32y + t33z);
					
					t11x += invMatrix[0][0]; t21x += invMatrix[1][0]; t31x += invMatrix[2][0];
					
					if (srcZ >= z || srcY >= y || srcX >= x || srcZ < 0.0 || srcY < 0.0 || srcX < 0.0){
						continue;
					}
					
					value = Main.ObservedImageData[srcZ * SourceSliceArea + srcY * x + srcX];

					XorImagePuffer[i][j][k] = value;
					
					if (value != 0){
					
						if (i > maxOfXr){
							maxOfXr = i;
						}
						
						if (j > maxOfYr){
							maxOfYr = j;
						}
						
						if (k > maxOfZr){
							maxOfZr = k;
						}
						
						if (i < minOfXr){
							minOfXr = i;
						}
						
						if (j < minOfYr){
							minOfYr = j;
						}
						
						if (k < minOfZr){
							minOfZr = k;
						}
					}
			
				}
				
				t12y += invMatrix[0][1]; t22y += invMatrix[1][1]; t32y += invMatrix[2][1];
			}
			t13z += invMatrix[0][2]; t23z += invMatrix[1][2]; t33z += invMatrix[2][2];
		}
		
		maxOfXrr = maxOfYrr = maxOfZrr = Integer.MIN_VALUE;
		minOfXrr = minOfYrr = minOfZrr = Integer.MAX_VALUE;
		int index = 0;
		for (int k = 0; k < Main.sourceImage.dimZ; k++) {
			for (int j = 0; j < Main.sourceImage.dimY; j++) {
				for (int i = 0; i < Main.sourceImage.dimX; i++){
					
					if (Main.imageData[index] != 0){
						
						if (i > maxOfXrr){
							maxOfXrr = i;
						}
						
						if (j > maxOfYrr){
							maxOfYrr = j;
						}
						
						if (k > maxOfZrr){
							maxOfZrr = k;
						}
						
						if (i < minOfXrr){
							minOfXrr = i;
						}
						
						if (j < minOfYrr){
							minOfYrr = j;
						}
						
						if (k < minOfZrr){
							minOfZrr = k;
						}
					}
					
					index++;
				}
			}
		}
		
		int minXreg = minOfXr + (int)Math.round(minOfX);
		int minYreg = minOfYr + (int)Math.round(minOfY);
		int minZreg = minOfZr + (int)Math.round(minOfZ);
		
		int maxXreg = maxOfXr + (int)Math.round(minOfX);
		int maxYreg = maxOfYr + (int)Math.round(minOfY);
		int maxZreg = maxOfZr + (int)Math.round(minOfZ);
		
		int minXo = minOfXrr + Main.SourceOffset[0];
		int minYo = minOfYrr + Main.SourceOffset[1];
		int minZo = minOfZrr + Main.SourceOffset[2];
		
		int maxXo = maxOfXrr + Main.SourceOffset[0];
		int maxYo = maxOfYrr + Main.SourceOffset[1];
		int maxZo = maxOfZrr + Main.SourceOffset[2];
		
		if (minXreg > minXo){
			min1 = minXo;
		} else {
			min1 = minXreg;
		}
		
		if (minYreg > minYo){
			min2 = minYo;
		} else {
			min2 = minYreg;
		}
		
		if (minZreg > minZo){
			min3 = minZo;
		} else {
			min3 = minZreg;
		}
		
		if (maxXreg < maxXo){
			max1 = maxXo;
		} else {
			max1 = maxXreg;
		}

		if (maxYreg < maxYo){
			max2 = maxYo;
		} else {
			max2 = maxYreg;
		}
		
		if (maxZreg < maxZo){
			max3 = maxZo;
		} else {
			max3 = maxZreg;
		}

	}
	
	public void Resize(){
	
		
		obsXr = max1 - min1 + 1;
		obsYr = max2 - min2 + 1;
		obsZr = max3 - min3 + 1;
		
		Main.XorImage = new byte[obsXr * obsYr * obsZr];

		Main.RegSize[0] = obsXr;
		Main.RegSize[1] = obsYr;
		Main.RegSize[2] = obsZr;
		
		Main.RegOffset[0] = min1;
		Main.RegOffset[1] = min2;
		Main.RegOffset[2] = min3;
						
		int srcX = Main.sourceImage.dimX, srcY = Main.sourceImage.dimY, srcZ =Main.sourceImage.dimZ;
		int slice, row, plainArea = srcX * srcY, sourceValue , registeredValue;
		
		xorWhiteVoxel = 0; sorceWhiteVoxel = 0; badVoxel = 0;
		
		int index = 0;
			
		int resizeOffX = min1 - 1, resizeOffY = min2 - 1, resizeOffZ = min3 - 1;
		int regOffX = (int)Math.round(minOfX), regOffY = (int)Math.round(minOfY), regOffZ = (int)Math.round(minOfZ);
		int sourceOffX = Main.SourceOffset[0],sourceOffY = Main.SourceOffset[1],sourceOffZ = Main.SourceOffset[2];
		int cx, cy, cz;

		
		for (int k = 0; k < obsZr; k++) {
			
			cz = k + resizeOffZ;
			slice = (cz - sourceOffZ) * plainArea;
			
			for (int j = 0; j < obsYr; j++) {
				
				cy = j + resizeOffY;
				row = (cy - sourceOffY) * srcX;
				
				for (int i = 0; i < obsXr; i++) {
					
					cx = i + resizeOffX;

					try{
						Main.XorImage[index] = XorImagePuffer[cx - regOffX][cy - regOffY][cz - regOffZ];
						registeredValue = Main.XorImage[index];
					}catch (Exception e) {
						registeredValue = 0;
					}			
					
					if (cx - sourceOffX < 0 || cx - sourceOffX >= srcX || cy - sourceOffY < 0 || cy - sourceOffY >= srcY || cz - sourceOffZ < 0 || cz - sourceOffZ >= srcZ){
						sourceValue = 0;
					} else {
						try{
						sourceValue = Main.imageData[slice + row + cx - sourceOffX];
						}catch (Exception e) {
							sourceValue = 0;
						}
					}
					
					
					if (registeredValue != 0){
						xorWhiteVoxel++;
					} 
					
					if (sourceValue != 0){
						sorceWhiteVoxel++;
					} 
					
					if (sourceValue != registeredValue){
						badVoxel++;
					}
					
					if (registeredValue != 0 &&  sourceValue == 0){
						Main.XorImage[index] = 5;
					} else if(registeredValue == 0 &&  sourceValue != 0){
						Main.XorImage[index] = 10;
					} else if(registeredValue != 0 &&  sourceValue != 0){
						Main.XorImage[index] = 15;
					}
					
					index++;
					
				}
			}
		}		
	}
			
}
