package io;
import java.awt.Component;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import main.Main;
import show2D.ObservedImageFrame;
import show2D.SourceImageFrame;



public class ReadImage {
		
	public int minV, maxV, dimX, dimY, dimZ, bitpix, mode, size;
	public float voxelWidth, voxelHeight, voxelThickness;
	public boolean littleEndian;
	public String descrip;
	public byte[] header;
	
	public SourceImageFrame frame1;
	public ObservedImageFrame frame2;
	
	
	public ReadImage(int mode){
		this.mode = mode;
		if (mode == 1){
			Main.txtFile = "";
		}
		Read();
	}
	
	
	public void readHeader( String hdrfile ) throws IOException 
    {
	
		String[] puffer = hdrfile.split("\\.");
		
		String absolutePathHDRExtension = "";
		String absolutePathIMGExtension = "";
		
		for (int i = 0; i < puffer.length - 1; i++) {
			absolutePathHDRExtension += puffer[i];
			absolutePathIMGExtension += puffer[i];
			Main.txtFile += puffer[i];
		}
		absolutePathHDRExtension += ".hdr";
		absolutePathIMGExtension += ".img";
		Main.txtFile += ".txt";
		
		File f = new File(absolutePathIMGExtension);
		
    FileInputStream filein = new FileInputStream (absolutePathHDRExtension);
    DataInputStream input = new DataInputStream (filein);
    byte[] units = new byte[4]; 

    this.littleEndian = false;     

    int i;

    input.readInt (); 				// sizeof_hdr
    for (i=0; i<10; i++) input.read();		// data_type
    for (i=0; i<18; i++) input.read(); 		// db_name 
    input.readInt (); 				// extents 
    input.readShort (); 			// session_error
    input.readByte ();				// regular 
    input.readByte (); 				// hkey_un0 


    short endian = readShort (input);		// dim[0] 
    if ((endian < 0) || (endian > 15)) {
    	littleEndian = true;
    }  
    dimX = (int)readShort (input);		// dim[1] 
    dimY = (int)readShort (input);		// dim[2] 
    dimZ = (int)readShort (input);		// dim[3] 
    input.readShort ();				// dim[4] 
    for (i=0; i<3; i++) input.readShort();	// dim[5-7] 
    input.read (units, 0, 4); 			// vox_units 
    //String unit = new String (units, 0, 4); 
    for (i=0; i<8; i++) input.read();		// cal_units[8] 
    input.readShort();				// unused1
    readShort( input );		// datatype 
    bitpix = (int)readShort( input );		// bitpix
    input.readShort ();				// dim_un0
    input.readFloat ();				// pixdim[0] 
    voxelWidth = readFloat(input);	// pixdim[1] 
    voxelHeight = readFloat(input); // pixdim[2] 
    voxelThickness = readFloat(input); 	// pixdim[3] 
    for (i=0; i<4; i++) input.readFloat();	// pixdim[4-7]  
    readFloat(input);			// vox_offset
    input.readFloat ();				// roi_scale 
    input.readFloat ();				// funused1 
    input.readFloat ();				// funused2 
    input.readFloat ();				// cal_max 
    input.readFloat ();				// cal_min 
    input.readInt ();				// compressed
    input.readInt ();				// verified  
    //   ImageStatistics s = imp.getStatistics();
    maxV = readInt (input);	//(int) s.max		// glmax 
    minV = readInt (input);	//(int) s.min		// glmin 

    
    byte[] b = new byte[80];

    for (i=0; i<80; i++) b[i] = input.readByte();		// descrip  

    descrip = new String(b);
 
    String puff[] = descrip.split(Character.toString((char)0));
	
	try{
		descrip = puff[0];
	} catch (Exception e) {
		descrip = "No_description";
	}
    
    
    if (mode == 0){
		try {
			
			String[] puff2 = puff[0].split(" ");
			
			Main.SourceOffset[0] = Integer.parseInt(puff2[0]);
			Main.SourceOffset[1] = Integer.parseInt(puff2[1]);
			Main.SourceOffset[2] = Integer.parseInt(puff2[2]);
		} catch (Exception e) {
			Main.SourceOffset[0] = 0;
			Main.SourceOffset[1] = 0;
			Main.SourceOffset[2] = 0;
		}
	}else{
		try {
			
			String[] puff2 = puff[0].split(" ");
			
			Main.ObservedOffset[0] = Integer.parseInt(puff2[0]);
			Main.ObservedOffset[1] = Integer.parseInt(puff2[1]);
			Main.ObservedOffset[2] = Integer.parseInt(puff2[2]);
		} catch (Exception e) {
			Main.ObservedOffset[0] = 0;
			Main.ObservedOffset[1] = 0;
			Main.ObservedOffset[2] = 0;
		}
	}
    
    for (i=0; i<24; i++) input.read();		// aux_file 
    input.read();				// orient 
    for (i=0; i<10; i++) input.read();		// originator 
    for (i=0; i<10; i++) input.read();		// generated 
    for (i=0; i<10; i++) input.read();		// scannum 
    for (i=0; i<10; i++) input.read();		// patient_id  
    for (i=0; i<10; i++) input.read();		// exp_date 
    for (i=0; i<10; i++) input.read();		// exp_time  
    for (i=0; i<3; i++) input.read();		// hist_un0
    input.readInt ();				// views 
    input.readInt ();				// vols_added 
    input.readInt ();				// start_field  
    input.readInt ();				// field_skip
    input.readInt ();				// omax  
    input.readInt ();				// omin 
    input.readInt ();				// smax  
    input.readInt ();				// smin 

    input.close();
    filein.close();
    
    ReadImageData(f);
	
	if (mode != 0){
		Main.generatedObservedX = dimX;
		Main.generatedObservedY = dimY;
		Main.generatedObservedZ = dimZ;
	}
    
    if (mode == 0){
		try{
			Main.sVx = voxelWidth;
			Main.sVy = voxelHeight;
			Main.sVz = voxelThickness;
		}catch (Exception e) {
			Main.sVx = 1.0f;
			Main.sVy = 1.0f;
			Main.sVz = 1.0f;
		}
	}else{
		try{
			Main.oVx = voxelWidth;
			Main.oVy = voxelHeight;
			Main.oVz = voxelThickness;
		}catch (Exception e) {
			Main.oVx = 1.0f;
			Main.oVy = 1.0f;
			Main.oVz = 1.0f;
		}
	}
    
    if (mode == 0){
    	frame1 = new SourceImageFrame(dimX, dimY, dimZ, bitpix, dimX*dimY*dimZ);
    } else {
    	frame2 = new ObservedImageFrame(dimX, dimY, dimZ, bitpix, dimX*dimY*dimZ);
    	Main.isGen = false;
    }
        
    }
  
  public int readInt(DataInputStream input) throws IOException 
    {
      if (!littleEndian) return input.readInt(); 
      byte b1 = input.readByte();
      byte b2 = input.readByte();
      byte b3 = input.readByte();
      byte b4 = input.readByte();
      return ( (((b4 & 0xff) << 24) | ((b3 & 0xff) << 16) | ((b2 & 0xff) << 8) | (b1 & 0xff)) );
    }
  
  public short readShort(DataInputStream input) throws IOException
    {
      if (!littleEndian) return input.readShort(); 
      byte b1 = input.readByte();
      byte b2 = input.readByte();
      return ( (short) (((b2 & 0xff) << 8) | (b1 & 0xff)) );
    }
  
  public float readFloat(DataInputStream input) throws IOException 
    {
      if (!littleEndian) return input.readFloat();  
      int orig = readInt(input);
      return (Float.intBitsToFloat(orig));
    }
	

	public void ReadImageData(File file) throws IOException{
		
		if (bitpix == 8){
			
			FileInputStream fis = new FileInputStream(file.getAbsolutePath());
			
			if (mode == 0){
				Main.imageData = new byte[(int)file.length()];
				while (fis.read(Main.imageData) != -1) { }
			}else{
				Main.ObservedImageData = new byte[(int)file.length()];
				while (fis.read(Main.ObservedImageData) != -1) { }
			}
	      
	        fis.close();
	        
		} else if (bitpix == 16 && littleEndian){
			
			if (mode == 0)
				Main.imageData = new byte[(int)file.length()/2];
			else
				Main.ObservedImageData = new byte[(int)file.length()/2];
			
			FileInputStream fis = new FileInputStream(file.getAbsolutePath());
			byte buf[] = new byte[1024*1024];
			int sum = 0;
			int retVal = 0;
			int k;		

			k = 0;
			while ((retVal = fis.read(buf)) != -1) {
	        	
	        	sum += retVal;
	        	
	        	for (int i = 0; i < retVal; i+=2) {
		        	
		        	if (mode ==0){
			        	if ((buf[i] << 8 | buf[i + 1]) != 0)
			        		Main.imageData[k] = -1;
			        	else
			        		Main.imageData[k] = 0;
		        	} else{
		        		if ((buf[i] << 8 | buf[i + 1]) != 0)
			        		Main.ObservedImageData[k] = -1;
			        	else
			        		Main.ObservedImageData[k] = 0;
		        	}
		        	k++;
				}
	        }
			
			if (sum != file.length()){
				System.out.println("Read error!!!");
			}
	    
	        fis.close();
	        
		} else if (bitpix == 16 && !littleEndian){
			
			if (mode == 0)
				Main.imageData = new byte[(int)file.length()/2];
			else
				Main.ObservedImageData = new byte[(int)file.length()/2];
			
			FileInputStream fis = new FileInputStream(file.getAbsolutePath());
			byte buf[] = new byte[1024*1024];
			int sum = 0;
			int retVal = 0;
			int k;			

			k = 0;
	        while ((retVal = fis.read(buf)) != -1) {
	        	
	        	sum += retVal;
	        	
	        	for (int i = 0; i < retVal; i+=2) {
		        	
		        	if (mode ==0){
			        	if ((buf[i + 1] << 8 | buf[i]) != 0){
			        		Main.imageData[k] = -1;
			        	}else
			        		Main.imageData[k] = 0;
		        	} else{
		        		if ((buf[i + 1] << 8 | buf[i]) != 0)
			        		Main.ObservedImageData[k] = -1;
			        	else
			        		Main.ObservedImageData[k] = 0;
		        	}
		        	k++;
				}
	        }
	        if (sum != file.length()){
				System.out.println("Read error!!!");
			} 
	        fis.close();
		}
	}	

	public void Read(){
		
		final JFileChooser fc = new JFileChooser(".//");
		int returnVal = fc.showOpenDialog((Component)null);

	        if (returnVal == JFileChooser.APPROVE_OPTION) {
	        	File SourceFile = fc.getSelectedFile();
	        	
	        	String[] p = SourceFile.getAbsolutePath().split("\\.");
	        	
	        	if (p[p.length - 1].compareTo("img") != 0 && p[p.length - 1].compareTo("hdr") != 0){
	        		JOptionPane.showMessageDialog((Component)null,
						    "Please select a hdr or img file!",
						    "Error!",
						    JOptionPane.ERROR_MESSAGE);
					
					return;
	        	}
	           
	        	try {
	        		if (mode == 0){
	        			Main.frame.SetMainTitile(" - Reading source image...");
	        		} else {
	        			Main.frame.SetMainTitile(" - Reading observed image...");
	        		}
	        		long start = System.currentTimeMillis();
	        		readHeader(SourceFile.getAbsolutePath());
	        		long end = System.currentTimeMillis();
	        		
	        		if (mode == 0){
	        			Main.frame.SetMainTitile(" - Reading source image... finished! (" + ((end-start)/1000.0) + " sec)");
	        			Main.sourceReadTime = (end-start)/1000.0f;
	        		} else {
	        			Main.frame.SetMainTitile(" - Reading observed image... finished! (" + ((end-start)/1000.0) + " sec)");
	        			Main.observedGenReadTime = (end-start)/1000.0f;
	        		}

					
				} catch (IOException e) {
					
					JOptionPane.showMessageDialog((Component)null,
						    "An IO exception occurred!",
						    "Error!",
						    JOptionPane.ERROR_MESSAGE);
					
					return;
				}
	        	
	        }
	}
}
