package io;

import java.awt.Component;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

import main.Main;

public class SaveOriginalImage {

	public SaveOriginalImage(){
				
	}
	
private void writeHeader( File hdrfile ) throws IOException {
		
		FileOutputStream fileout = new FileOutputStream(hdrfile.getAbsolutePath() + ".hdr");
		DataOutputStream output = new DataOutputStream(fileout);

		//     header_key  

		writeInt(output, 348); 				// sizeof_hdr
		int i;
		for (i = 0; i < 10; i++) output.write( 0 );	// data_type
		for (i = 0; i < 18; i++) output.write( 0 ); 	// db_name 
		writeInt(output, 16384); 				// extents 
		output.writeShort( 0); 								// session_error
		output.writeByte ( (int) 'r' );				// regular 
		output.writeByte ( 0 );				// hkey_un 

		// image_dimension

		writeShort(output, (short) 4 );				// dim[0] 
		writeShort(output, (short) Main.RegSize[0] );			// dim[1] 
		writeShort(output, (short) Main.RegSize[1] );			// dim[2] 
		writeShort(output, (short) Main.RegSize[2]);		// dim[3] 
		writeShort(output, (short) 1 );				// dim[4] 
		for (i = 0; i < 3; i++) output.writeShort( 0 );		// dim[5-7]
		
		output.writeBytes ( "mm\0\0" );			// vox_units
		for (i = 0; i < 8; i++) output.write( 0 );		// cal_units[8] 
		output.writeShort( 0 );				// unused1
		writeShort( output, (short) 2 );		// datatype 
		writeShort( output, (short) 8 );		// bitpix
		output.writeShort( 0 );					// dim_un0
		
		output.writeFloat( 0 );					// pixdim[0] 
		writeFloat(output, (float) Main.sVx );		// pixdim[1] 
		writeFloat(output, (float) Main.sVy );		// pixdim[2] 
		writeFloat(output, (float) Main.sVz ); 		// pixdim[3] 
		for (i = 0; i < 4; i++) output.writeFloat( 0 );	// pixdim[4-7]
		
		output.writeFloat( 0 );		// vox_offset 
		output.writeFloat( 1 );		// roi_scale 
		output.writeFloat( 0 );		// funused1 
		output.writeFloat( 0 );		// funused2 
		output.writeFloat( 0 );		// cal_max 
		output.writeFloat( 0 );		// cal_min 
		output.writeInt( 0 );			// compressed
		output.writeInt( 0 );			// verified  
		//ImageStatistics s = imp.getStatistics();
		writeInt(output, (int) 255 );		// glmax 
		writeInt(output, (int) 0 );		// glmin 

		// data_history 

		String desc = new String(Integer.toString(Main.RegOffset[0]) + " " + Integer.toString(Main.RegOffset[1]) + " " +Integer.toString(Main.RegOffset[2]));
		
		byte[] var = desc.getBytes();
		byte[] var2 = new byte[80];
		
		for (int j = 0; j < var.length; j++) {
			var2[j] = var[j];
		}
		
		output.write( var2 );		// descrip  
		for (i = 0; i < 24; i++) output.write( 0 );		// aux_file 
		output.write(0);											// orient 
		for (i = 0; i < 10; i++) output.write( 0 );		// originator 
		for (i = 0; i < 10; i++) output.write( 0 );		// generated 
		for (i = 0; i < 10; i++) output.write( 0 );		// scannum 
		for (i = 0; i < 10; i++) output.write( 0 );		// patient_id  
		for (i = 0; i < 10; i++) output.write( 0 );		// exp_date 
		for (i = 0; i < 10; i++) output.write( 0 );		// exp_time  
		for (i = 0; i < 3; i++)  output.write( 0 );		// hist_un0
		output.writeInt( 0 );		// views 
		output.writeInt( 0 );		// vols_added 
		output.writeInt( 0 );		// start_field  
		output.writeInt( 0 );		// field_skip
		output.writeInt( 0 );		// omax  
		output.writeInt( 0 );		// omin 
		output.writeInt( 0 );		// smax  
		output.writeInt( 0 );		// smin 

		output.close();
		fileout.close();
	}

	
	
	
	private void writeInt(DataOutputStream input, int value) throws IOException {
		input.writeInt( value );  
	}
	
	private void writeShort(DataOutputStream input, short value) throws IOException {
		input.writeShort( value ); 
	}
	
	private void writeFloat(DataOutputStream input, float value) throws IOException {
		writeInt(input, Float.floatToIntBits( value ) ); 
	}
	
	public void Write(){
		
		final JFileChooser fc = new JFileChooser(".//");
		int returnVal = fc.showSaveDialog((Component)null);
		
		if (returnVal == JFileChooser.APPROVE_OPTION) {
        	File file = fc.getSelectedFile();
        	File file2 = new File(file.getAbsolutePath() + ".img");

	        try {
	        	Main.frame.SetMainTitile(" - Saving image...");
	    		long start = System.currentTimeMillis();
	        	FileOutputStream fis = new FileOutputStream(file2.getAbsolutePath());
	        	
	        	int puffSize = 10000;
	        	
	        	byte[] puff = new byte[puffSize];
	        	int size = Main.XorImage.length;
	        	int piece = size / puffSize;
	        	int freg = size % puffSize;
	        	int index = 0;
	        	
	        	for (int i = 0; i < piece; i++) {
				
	        		for (int j = index,k = 0; j < index + puffSize; j++, k++) {
						if(Main.XorImage[j] == 10 || Main.XorImage[j] == 15){
							puff[k] = -1;
						} else {
							puff[k] = 0;
						}
					}
	        		fis.write(puff);
	        		
	        		index += puffSize;
				}
	        	
	        	puff = new byte[freg];
	        	
	        	for (int j = index,k = 0; j < index + freg; j++, k++) {
					if(Main.XorImage[j] == 5 || Main.XorImage[j] == 15){
						puff[k] = -1;
					} else {
						puff[k] = 0;
					}
				}
        		fis.write(puff);
	        	
				fis.close();
				
				writeHeader(file);
				
				long end = System.currentTimeMillis();
				
				Main.frame.SetMainTitile(" - Saving image... finished! (" + ((end-start)/1000.0) + " sec)");
				
				
			} catch (IOException e) {
				JOptionPane.showMessageDialog((Component)null,
					    "Error saving image!",							    
					    "Error!",
					    JOptionPane.ERROR_MESSAGE);
				
				return;
			}

		}
	}
}
