package main;
import generate.GenerateImage;
import io.ReadImage;
import io.SaveOriginalImage;
import io.SaveRegisteredImage;
import io.SaveResultMatrix;
import io.WriteImage;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import registration.Registration;
import show2D.ObservedImageFrame;
import show2D.ResultImageFrame;
import show3D.RenderObserved3D;
import show3D.RenderResult3Dcolored;
import show3D.RenderResult3Dregistered;
import show3D.RenderSource3D;
import show3D.RenderSourceAndObserved3D;
import Jama.Matrix;
import about.About;


public class Main extends JFrame implements ActionListener, ItemListener{

	private static final long serialVersionUID = 1L;
	private JTextField textField_Tx;
	private JTextField textField_Ty;
	private JTextField textField_Tz;
	private JTextField textField_Sx;
	private JTextField textField_Sy;
	private JTextField textField_Sz;
	private JTextField textField_Rx;
	private JTextField textField_Ry;
	private JTextField textField_Rz;
	private JTextField textField_SXy;
	private JTextField textField_SYx;
	private JTextField textField_SZx;
	private JTextField textField_SXz;
	private JTextField textField_SYz;
	private JTextField textField_SZy;
	private JTextField textField_A11;
	private JTextField textField_A12;
	private JTextField textField_A13;
	private JTextField textField_A14;
	private JTextField textField_A21;
	private JTextField textField_A22;
	private JTextField textField_A23;
	private JTextField textField_A24;
	private JTextField textField_A31;
	private JTextField textField_A32;
	private JTextField textField_A33;
	private JTextField textField_A34;
	private JTextField textField_A41;
	private JTextField textField_A42;
	private JTextField textField_A43;
	private JTextField textField_A44;
	public static JTextField textField_R11;
	public static JTextField textField_R12;
	public static JTextField textField_R13;
	public static JTextField textField_R14;
	public static JTextField textField_R24;
	public static JTextField textField_R23;
	public static JTextField textField_R22;
	public static JTextField textField_R21;
	public static JTextField textField_R31;
	private JTextField textField_37;
	private JTextField textField_38;
	public static JTextField textField_R32;
	public static JTextField textField_R33;
	private JTextField textField_41;
	private JTextField textField_42;
	public static JTextField textField_R34;
	public static JLabel lblConsumedCpuTime, lblNewLabel_3;
	
	private final ButtonGroup buttonGroup = new ButtonGroup();
	private final ButtonGroup buttonGroup2 = new ButtonGroup();
	private final ButtonGroup buttonGroup3 = new ButtonGroup();
	private final ButtonGroup buttonGroup4 = new ButtonGroup();
		 
	Matrix T = Matrix.identity(4, 4);
	Matrix R = Matrix.identity(4, 4);
	Matrix S = Matrix.identity(4, 4);
	Matrix Sh = Matrix.identity(4, 4);
	Matrix Rx = Matrix.identity(4, 4);
	Matrix Ry = Matrix.identity(4, 4);
	Matrix Rz = Matrix.identity(4, 4);
	Matrix TranslateCenterToOrigine = Matrix.identity(4, 4);
	Matrix TranslateCenterBack = Matrix.identity(4, 4);
	Matrix TransformationMatrixForm = Matrix.identity(4, 4);
	public static Matrix TransformationFromProperties = Matrix.identity(4, 4);
	
	public static JRadioButton  rdbtnGenerateObservationFrom_1, rdbtnOpenObservedd, rdbtnGenerateObservationFrom, rdbtnMm, rdbtnPixels,rdbtnJacobi,rdbtnCalculateJacobi, rdbtnColoured, rdbtnXorResult, rdbtnRegistrationResult;
	public static JButton btnSaveOriginalImage, btnSaveTransformationMatrix, btnStartRegistration,btnSaveRegisteredImage, btnNewButton,btnCreateObservation, btnOpen, btnSaveObservation, btnLoadFromTxt;
	public static JCheckBox chckbxShowResultImage,chckbxShowBothIn,chckbxNewCheckBox,chckbxRigid, chckbxNewCheckBox_1, chckbxShowSourceAnd, chckbxRotateImageCenter_1;
	public static JLabel lblNumberOfScanned,lblNewLabel_2,lblUnits,lblJacobian, lblGeometricError, lblEpsilonError, lblStatictics, lblSourceImageRead, lblNewLabel_5, lblResultImageGeneration, lblLmaOptimzerTime, lblTotalRegistrationTime, lblConstructionTimeOf, lblEpsilonErrorCalculation;
	private JSeparator separator_4;
	
	public static boolean rotaion = false, Xor = false, registered = false, coloured = true, isTransformationKnown = false, mm = true, isGen = false, isJacobian = true, isRigid = false;

	public static ReadImage observedImage;
	public static ReadImage sourceImage;
	public static WriteImage writeImage;
	public static Registration reg;
	public static byte[] SourceHeader;
	public static byte[] XorImage;
	public static byte[][][] XorImagePuffer;
	public static byte[] imageData;
	public static byte[] ObservedImageData;
	public static byte[] ObservedImageDataPuffer;
	public static int[] ObservedOffset = new int[3];
	public static int[] ObservedSize = new int[3];
	public static int[] RegSize = new int[3];
	public static int[] RegOffset = new int[3];
	public static int[] SourceOffset = new int[3];
	public static int radioButtonID = 0;
	public static Main frame;
	public static ObservedImageFrame Observedframe;
	public static ResultImageFrame XorFrame;
	public GenerateImage gen;
	
	public static double[][] resultMatrix = new double[4][4];
	
	
	public static int generatedObservedX, generatedObservedY, generatedObservedZ;
	
	public static String txtFile = "";
	public static JLabel lblNewLabel_4;
	private Choice choice;
	
	public static int choiceIndex = 2;
	public static int IterationLimit = 30;
	public static double fvalLimit = 70.0;
	private JTextField textField;
	
	public static int allReady = 0, BothReady = 0, allReady3D = 0;
	public static float sVx = 1.0f, sVy = 1.0f, sVz = 1.0f;
	public static float oVx = 1.0f, oVy = 1.0f, oVz = 1.0f;
	
	public static float sourceReadTime, observedGenReadTime, resultGenTime, optimizerTime, equtationsTime, epsilonErrorTime;
	
	RenderSource3D renderSource;
	RenderObserved3D renderObserved;
	RenderResult3Dcolored renderResult;
	RenderSourceAndObserved3D renderSAndO;
	RenderResult3Dregistered renderReg;
	private JTextField textField_1;
	private JSeparator separator_6;
	private JSeparator separator_7;
	private JSeparator separator_8;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					frame = new Main();
					frame.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}
	
	public void SetMainTitile(String s){
		setTitle("3D binary registration " + s);
	}
	
	public static void ad(double[] x){
		
		for (int i = 0; i < x.length; i++) {
			x[i] += 1;
		}
	}

		
	/**
	 * Create the frame.
	 * @throws UnsupportedLookAndFeelException 
	 * @throws IllegalAccessException 
	 * @throws InstantiationException 
	 * @throws ClassNotFoundException 
	 */
	public Main() throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
		
		setResizable(false);
		setTitle("3D Binary Registration");
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(600, 50, 780, 800);
		
		UIManager.setLookAndFeel(
	            UIManager.getSystemLookAndFeelClassName());
		
		JSplitPane splitPane = new JSplitPane();
		splitPane.setResizeWeight(0.5);
		getContentPane().add(splitPane, BorderLayout.CENTER);
		
		JPanel panel = new JPanel();
		splitPane.setLeftComponent(panel);
		panel.setLayout(null);
		
		btnOpen = new JButton("Open source img");
		btnOpen.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				SourceHeader = new byte[348];
				sourceImage = new ReadImage(0);
			}
		});
		btnOpen.setBounds(235, 5, 128, 32);
		panel.add(btnOpen);
		
		rdbtnOpenObservedd = new JRadioButton("Open observed 3D image:");
		buttonGroup.add(rdbtnOpenObservedd);
		rdbtnOpenObservedd.setSelected(true);
		rdbtnOpenObservedd.setBounds(10, 65, 219, 23);
		panel.add(rdbtnOpenObservedd);
		
		btnNewButton = new JButton("Open observed img");
		btnNewButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				observedImage = new ReadImage(1);
				
				try {
	        		
					File file = new File(txtFile);
					
	        		BufferedReader reader = new BufferedReader(new FileReader(file));
	        		String[] puffer;
	        		String line;
	        		
	        		line = reader.readLine();
	        		
	        		puffer = line.split(" ");
	        		
	        		if (puffer.length < 3){
	        			
	        			line = reader.readLine();
	        			line = reader.readLine();
	        			line = reader.readLine();
	        			
	        			line = line.replaceAll(" \t", " ");	
	        			puffer = line.split(" ");
	        			
	        			for (int i = 0; i < puffer.length; i++) {
	        				puffer[i] = puffer[i].trim();
						}
	        			
	        			textField_A11.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
	        			textField_A12.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
	        			textField_A13.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
	        			textField_A14.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
	        			
	        			line = reader.readLine();
	        						        						        			
	        			line = line.replaceAll(" \t", " ");
	        			puffer = line.split(" ");
	        			
	        			for (int i = 0; i < puffer.length; i++) {
	        				puffer[i] = puffer[i].trim();
						}
	        			
	        			textField_A21.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
	        			textField_A22.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
	        			textField_A23.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
	        			textField_A24.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
	        			
	        			line = reader.readLine();
	        			
	        			line = line.replaceAll(" \t", " ");	
	        			puffer = line.split(" ");
	        			
	        			for (int i = 0; i < puffer.length; i++) {
	        				puffer[i] = puffer[i].trim();
						}

	        			textField_A31.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
	        			textField_A32.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
	        			textField_A33.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
	        			textField_A34.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
	        			
	        			isTransformationKnown = true;
	        		} else {
	        			
	        			puffer = line.split(" ");
	        			textField_A11.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
	        			textField_A12.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
	        			textField_A13.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
	        			textField_A14.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));;
	        			
	        			line = reader.readLine();
	        			puffer = line.split(" ");
	        			textField_A21.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
	        			textField_A22.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
	        			textField_A23.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
	        			textField_A24.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
	        			
	        			line = reader.readLine();
	        			puffer = line.split(" ");
	        			textField_A31.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
	        			textField_A32.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
	        			textField_A33.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
	        			textField_A34.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
	        			isTransformationKnown = true;
	        		}
	        		
	        		
	        		TransformationFromProperties.set(0, 0, Double.parseDouble(textField_A11.getText()));
	        		TransformationFromProperties.set(0, 1, Double.parseDouble(textField_A12.getText()));
	        		TransformationFromProperties.set(0, 2, Double.parseDouble(textField_A13.getText()));
	        		TransformationFromProperties.set(0, 3, Double.parseDouble(textField_A14.getText()));
	        		TransformationFromProperties.set(1, 0, Double.parseDouble(textField_A21.getText()));
	        		TransformationFromProperties.set(1, 1, Double.parseDouble(textField_A22.getText()));
	        		TransformationFromProperties.set(1, 2, Double.parseDouble(textField_A23.getText()));
	        		TransformationFromProperties.set(1, 3, Double.parseDouble(textField_A24.getText()));
	        		TransformationFromProperties.set(2, 0, Double.parseDouble(textField_A31.getText()));
	        		TransformationFromProperties.set(2, 1, Double.parseDouble(textField_A32.getText()));
	        		TransformationFromProperties.set(2, 2, Double.parseDouble(textField_A33.getText()));
	        		TransformationFromProperties.set(2, 3, Double.parseDouble(textField_A34.getText()));
	        		TransformationFromProperties.set(3, 0, Double.parseDouble(textField_A41.getText()));
	        		TransformationFromProperties.set(3, 1, Double.parseDouble(textField_A42.getText()));
	        		TransformationFromProperties.set(3, 2, Double.parseDouble(textField_A43.getText()));
	        		TransformationFromProperties.set(3, 3, Double.parseDouble(textField_A44.getText()));
	        		
	        		lblNewLabel_2.setText(file.getName());

					
				} catch (Exception e) {	
					
					textField_A31.setText("?");
					textField_A32.setText("?");
					textField_A33.setText("?");
					textField_A34.setText("?");
					
					textField_A21.setText("?");
					textField_A22.setText("?");
					textField_A23.setText("?");
					textField_A24.setText("?");
					
					textField_A11.setText("?");
					textField_A12.setText("?");
					textField_A13.setText("?");
					textField_A14.setText("?");
					
					lblNewLabel_2.setText("");
        			
					isTransformationKnown = false;
				} 
			}
		});
		btnNewButton.setBounds(235, 60, 128, 32);
		panel.add(btnNewButton);
		
		rdbtnGenerateObservationFrom = new JRadioButton("Generate observation from transformation parameters:");
		buttonGroup.add(rdbtnGenerateObservationFrom);
		rdbtnGenerateObservationFrom.setBounds(10, 110, 329, 23);
		panel.add(rdbtnGenerateObservationFrom);
		
		JLabel lblOpendImage = new JLabel("Open 3D source image:");
		lblOpendImage.setBounds(20, 10, 205, 23);
		panel.add(lblOpendImage);
		
		JLabel lblNewLabel = new JLabel("Translation");
		lblNewLabel.setBounds(44, 140, 66, 14);
		panel.add(lblNewLabel);
		
		JLabel lblRotation = new JLabel("Rotation");
		lblRotation.setBounds(106, 140, 46, 14);
		panel.add(lblRotation);
		
		JLabel lblShearing = new JLabel("Shearing");
		lblShearing.setBounds(266, 140, 58, 14);
		panel.add(lblShearing);
		
		JLabel lblX = new JLabel("X:");
		lblX.setBounds(20, 160, 22, 14);
		panel.add(lblX);
		
		JLabel lblY = new JLabel("Y:");
		lblY.setBounds(20, 182, 22, 14);
		panel.add(lblY);
		
		JLabel lblZ = new JLabel("Z:");
		lblZ.setBounds(20, 203, 22, 14);
		panel.add(lblZ);
		
		textField_Tx = new JTextField();
		textField_Tx.setEnabled(false);
		textField_Tx.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Tx.setText("0.0");
		textField_Tx.setBounds(44, 158, 53, 20);
		panel.add(textField_Tx);
		textField_Tx.setColumns(10);
		
		textField_Ty = new JTextField();
		textField_Ty.setEnabled(false);
		textField_Ty.setText("0.0");
		textField_Ty.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Ty.setColumns(10);
		textField_Ty.setBounds(44, 180, 53, 20);
		panel.add(textField_Ty);
		
		textField_Tz = new JTextField();
		textField_Tz.setEnabled(false);
		textField_Tz.setText("0.0");
		textField_Tz.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Tz.setColumns(10);
		textField_Tz.setBounds(44, 202, 53, 20);
		panel.add(textField_Tz);
		
		textField_Rx = new JTextField();
		textField_Rx.setEnabled(false);
		textField_Rx.setText("0.0");
		textField_Rx.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Rx.setColumns(10);
		textField_Rx.setBounds(99, 158, 53, 20);
		panel.add(textField_Rx);
		
		textField_Ry = new JTextField();
		textField_Ry.setEnabled(false);
		textField_Ry.setText("0.0");
		textField_Ry.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Ry.setColumns(10);
		textField_Ry.setBounds(99, 180, 53, 20);
		panel.add(textField_Ry);
		
		textField_Rz = new JTextField();
		textField_Rz.setEnabled(false);
		textField_Rz.setText("0.0");
		textField_Rz.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Rz.setColumns(10);
		textField_Rz.setBounds(99, 202, 53, 20);
		panel.add(textField_Rz);
		
		textField_SXy = new JTextField();
		textField_SXy.setEnabled(false);
		textField_SXy.setText("0.0");
		textField_SXy.setHorizontalAlignment(SwingConstants.CENTER);
		textField_SXy.setColumns(10);
		textField_SXy.setBounds(245, 158, 35, 20);
		panel.add(textField_SXy);
		
		textField_SYx = new JTextField();
		textField_SYx.setEnabled(false);
		textField_SYx.setText("0.0");
		textField_SYx.setHorizontalAlignment(SwingConstants.CENTER);
		textField_SYx.setColumns(10);
		textField_SYx.setBounds(245, 180, 35, 20);
		panel.add(textField_SYx);
		
		textField_SZx = new JTextField();
		textField_SZx.setEnabled(false);
		textField_SZx.setText("0.0");
		textField_SZx.setHorizontalAlignment(SwingConstants.CENTER);
		textField_SZx.setColumns(10);
		textField_SZx.setBounds(245, 202, 35, 20);
		panel.add(textField_SZx);
		
		rdbtnGenerateObservationFrom_1 = new JRadioButton("Generate observation from transformation matrix:");
		buttonGroup.add(rdbtnGenerateObservationFrom_1);
		rdbtnGenerateObservationFrom_1.setBounds(10, 275, 314, 23);
		panel.add(rdbtnGenerateObservationFrom_1);
		
		/*aaaaaaa*/
		rdbtnOpenObservedd.addActionListener(this);
		rdbtnGenerateObservationFrom.addActionListener(this);
		rdbtnGenerateObservationFrom_1.addActionListener(this);
		/*aaaaaaa*/
		
		textField_A11 = new JTextField();
		textField_A11.setEnabled(false);
		textField_A11.setText("1.0");
		textField_A11.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A11.setColumns(10);
		textField_A11.setBounds(53, 348, 70, 20);
		panel.add(textField_A11);
		
		textField_A12 = new JTextField();
		textField_A12.setEnabled(false);
		textField_A12.setText("0.0");
		textField_A12.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A12.setColumns(10);
		textField_A12.setBounds(125, 348, 70, 20);
		panel.add(textField_A12);
		
		textField_A13 = new JTextField();
		textField_A13.setEnabled(false);
		textField_A13.setText("0.0");
		textField_A13.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A13.setColumns(10);
		textField_A13.setBounds(197, 348, 70, 20);
		panel.add(textField_A13);
		
		textField_A14 = new JTextField();
		textField_A14.setEnabled(false);
		textField_A14.setText("0.0");
		textField_A14.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A14.setColumns(10);
		textField_A14.setBounds(269, 348, 70, 20);
		panel.add(textField_A14);
		
		textField_A21 = new JTextField();
		textField_A21.setEnabled(false);
		textField_A21.setText("0.0");
		textField_A21.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A21.setColumns(10);
		textField_A21.setBounds(53, 370, 70, 20);
		panel.add(textField_A21);
		
		textField_A22 = new JTextField();
		textField_A22.setEnabled(false);
		textField_A22.setText("1.0");
		textField_A22.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A22.setColumns(10);
		textField_A22.setBounds(125, 370, 70, 20);
		panel.add(textField_A22);
		
		textField_A23 = new JTextField();
		textField_A23.setEnabled(false);
		textField_A23.setText("0.0");
		textField_A23.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A23.setColumns(10);
		textField_A23.setBounds(197, 370, 70, 20);
		panel.add(textField_A23);
		
		textField_A24 = new JTextField();
		textField_A24.setEnabled(false);
		textField_A24.setText("0.0");
		textField_A24.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A24.setColumns(10);
		textField_A24.setBounds(269, 370, 70, 20);
		panel.add(textField_A24);
		
		textField_A31 = new JTextField();
		textField_A31.setEnabled(false);
		textField_A31.setText("0.0");
		textField_A31.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A31.setColumns(10);
		textField_A31.setBounds(53, 392, 70, 20);
		panel.add(textField_A31);
		
		textField_A32 = new JTextField();
		textField_A32.setEnabled(false);
		textField_A32.setText("0.0");
		textField_A32.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A32.setColumns(10);
		textField_A32.setBounds(125, 392, 70, 20);
		panel.add(textField_A32);
		
		textField_A33 = new JTextField();
		textField_A33.setEnabled(false);
		textField_A33.setText("1.0");
		textField_A33.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A33.setColumns(10);
		textField_A33.setBounds(197, 392, 70, 20);
		panel.add(textField_A33);
		
		textField_A34 = new JTextField();
		textField_A34.setEnabled(false);
		textField_A34.setText("0.0");
		textField_A34.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A34.setColumns(10);
		textField_A34.setBounds(269, 392, 70, 20);
		panel.add(textField_A34);
		
		textField_A41 = new JTextField();
		textField_A41.setEnabled(false);
		textField_A41.setText("0.0");
		textField_A41.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A41.setColumns(10);
		textField_A41.setBounds(53, 414, 70, 20);
		panel.add(textField_A41);
		
		textField_A42 = new JTextField();
		textField_A42.setEnabled(false);
		textField_A42.setText("0.0");
		textField_A42.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A42.setColumns(10);
		textField_A42.setBounds(125, 414, 70, 20);
		panel.add(textField_A42);
		
		textField_A43 = new JTextField();
		textField_A43.setEnabled(false);
		textField_A43.setText("0.0");
		textField_A43.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A43.setColumns(10);
		textField_A43.setBounds(197, 414, 70, 20);
		panel.add(textField_A43);
		
		textField_A44 = new JTextField();
		textField_A44.setEnabled(false);
		textField_A44.setText("1.0");
		textField_A44.setHorizontalAlignment(SwingConstants.CENTER);
		textField_A44.setColumns(10);
		textField_A44.setBounds(269, 414, 70, 20);
		panel.add(textField_A44);
		
		btnCreateObservation = new JButton("Create observation");
		btnCreateObservation.setEnabled(false);
		btnCreateObservation.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				lblNewLabel_2.setText("");
				
				T = Matrix.identity(4, 4);
				R = Matrix.identity(4, 4);
				S = Matrix.identity(4, 4);
				Sh = Matrix.identity(4, 4);
				Rx = Matrix.identity(4, 4);
				Ry = Matrix.identity(4, 4);
				Rz = Matrix.identity(4, 4);
				TranslateCenterToOrigine = Matrix.identity(4, 4);
				TranslateCenterBack = Matrix.identity(4, 4);
				TransformationMatrixForm = Matrix.identity(4, 4);
				TransformationFromProperties = Matrix.identity(4, 4);
				
				btnCreateObservation.setEnabled(false);
				
				if (imageData == null){
					JOptionPane.showMessageDialog((Component)null,
						    "Error generating observed image: " +
						    "No source file loaded!",
						    "Error!",
						    JOptionPane.ERROR_MESSAGE);
					
					btnCreateObservation.setEnabled(true);
					
					return;
				}
				
				if (rdbtnGenerateObservationFrom.isSelected()){
					
					try{
						
						double fi = Math.toRadians(Double.parseDouble(textField_Rx.getText()));
						double theta = Math.toRadians(Double.parseDouble(textField_Ry.getText()));
						double pszi = Math.toRadians(Double.parseDouble(textField_Rz.getText()));
						
						double cFi = Math.cos(fi);
						double sFi = Math.sin(fi);
						double cTheta = Math.cos(theta);
						double sTheta = Math.sin(theta);
						double cPszi = Math.cos(pszi);
						double sPszi = Math.sin(pszi);
									
						if (mm){
							T.set(0, 3, Double.parseDouble(textField_Tx.getText()));
							T.set(1, 3, Double.parseDouble(textField_Ty.getText()));
							T.set(2, 3, Double.parseDouble(textField_Tz.getText()));
						} else {
							T.set(0, 3, Double.parseDouble(textField_Tx.getText()) * sVx);
							T.set(1, 3, Double.parseDouble(textField_Ty.getText()) * sVy);
							T.set(2, 3, Double.parseDouble(textField_Tz.getText()) * sVz);
						}
						
						Rz.set(0, 0, cPszi);
						Rz.set(1, 1, cPszi);
						Rz.set(0, 1, -sPszi);
						Rz.set(1, 0, sPszi);
						
						Ry.set(0, 0, cTheta);
						Ry.set(2, 2, cTheta);
						Ry.set(0, 2, sTheta);
						Ry.set(2, 0, -sTheta);
						
						Rx.set(1, 1, cFi);
						Rx.set(2, 2, cFi);
						Rx.set(1, 2, -sFi);
						Rx.set(2, 1, sFi);
												
						R = Rz.times(Ry).times(Rx);
							
						S.set(0, 0, Double.parseDouble(textField_Sx.getText()));
						S.set(1, 1, Double.parseDouble(textField_Sy.getText()));
						S.set(2, 2, Double.parseDouble(textField_Sz.getText()));
						
						Sh.set(0, 1, Double.parseDouble(textField_SXy.getText()));
						Sh.set(0, 2, Double.parseDouble(textField_SXz.getText()));
						Sh.set(1, 0, Double.parseDouble(textField_SYx.getText()));
						Sh.set(1, 2, Double.parseDouble(textField_SYz.getText()));
						Sh.set(2, 0, Double.parseDouble(textField_SZx.getText()));
						Sh.set(2, 1, Double.parseDouble(textField_SZy.getText()));

					} catch (NumberFormatException e) {
						JOptionPane.showMessageDialog((Component)null,
							    "Invalid number format!",							    
							    "Error!",
							    JOptionPane.ERROR_MESSAGE);
						
						btnCreateObservation.setEnabled(true);
						
						return;
					}

					if (chckbxRotateImageCenter_1.isSelected()){		
							
				
						TranslateCenterToOrigine.set(0, 3, -sourceImage.dimX * sVx / 2.0);
						TranslateCenterToOrigine.set(1, 3, -sourceImage.dimY * sVy / 2.0);
						TranslateCenterToOrigine.set(2, 3, -sourceImage.dimZ * sVz / 2.0);
							
						TranslateCenterBack.set(0, 3, sourceImage.dimX * sVx / 2.0);
						TranslateCenterBack.set(1, 3, sourceImage.dimY * sVy / 2.0);
						TranslateCenterBack.set(2, 3, sourceImage.dimZ * sVz / 2.0);
				
						
						TransformationFromProperties = T.times(TranslateCenterBack).times(R).times(TranslateCenterToOrigine).times(S).times(Sh);
						
					} else {
						
						TransformationFromProperties = T.times(R).times(S).times(Sh);
					}
					
					textField_A11.setText(Double.toString((double)Math.round(TransformationFromProperties.get(0, 0) * 100000.0)/100000.0));
					textField_A12.setText(Double.toString((double)Math.round(TransformationFromProperties.get(0, 1) * 100000.0)/100000.0));
					textField_A13.setText(Double.toString((double)Math.round(TransformationFromProperties.get(0, 2) * 100000.0)/100000.0));
					textField_A14.setText(Double.toString((double)Math.round(TransformationFromProperties.get(0, 3) * 100000.0)/100000.0));
					
					textField_A21.setText(Double.toString((double)Math.round(TransformationFromProperties.get(1, 0) * 100000.0)/100000.0));
					textField_A22.setText(Double.toString((double)Math.round(TransformationFromProperties.get(1, 1) * 100000.0)/100000.0));
					textField_A23.setText(Double.toString((double)Math.round(TransformationFromProperties.get(1, 2) * 100000.0)/100000.0));
					textField_A24.setText(Double.toString((double)Math.round(TransformationFromProperties.get(1, 3) * 100000.0)/100000.0));
					
					textField_A31.setText(Double.toString((double)Math.round(TransformationFromProperties.get(2, 0) * 100000.0)/100000.0));
					textField_A32.setText(Double.toString((double)Math.round(TransformationFromProperties.get(2, 1) * 100000.0)/100000.0));
					textField_A33.setText(Double.toString((double)Math.round(TransformationFromProperties.get(2, 2) * 100000.0)/100000.0));
					textField_A34.setText(Double.toString((double)Math.round(TransformationFromProperties.get(2, 3) * 100000.0)/100000.0));
										
					try{						
						gen = new GenerateImage(sourceImage.dimX, sourceImage.dimY, sourceImage.dimZ, TransformationFromProperties);
						gen.GenerateObservedImage();	
						
					}catch (Exception e) {
						JOptionPane.showMessageDialog((Component)null,
							    "Error!",							    
							    "Error!",
							    JOptionPane.ERROR_MESSAGE);
						
						btnCreateObservation.setEnabled(true);
						
						return;
					}
					
					
				} else{
					
					try{
						
						TransformationMatrixForm.set(0, 0, Double.parseDouble(textField_A11.getText()));
						TransformationMatrixForm.set(0, 1, Double.parseDouble(textField_A12.getText()));
						TransformationMatrixForm.set(0, 2, Double.parseDouble(textField_A13.getText()));
						TransformationMatrixForm.set(0, 3, Double.parseDouble(textField_A14.getText()));
						TransformationMatrixForm.set(1, 0, Double.parseDouble(textField_A21.getText()));
						TransformationMatrixForm.set(1, 1, Double.parseDouble(textField_A22.getText()));
						TransformationMatrixForm.set(1, 2, Double.parseDouble(textField_A23.getText()));
						TransformationMatrixForm.set(1, 3, Double.parseDouble(textField_A24.getText()));
						TransformationMatrixForm.set(2, 0, Double.parseDouble(textField_A31.getText()));
						TransformationMatrixForm.set(2, 1, Double.parseDouble(textField_A32.getText()));
						TransformationMatrixForm.set(2, 2, Double.parseDouble(textField_A33.getText()));
						TransformationMatrixForm.set(2, 3, Double.parseDouble(textField_A34.getText()));
						TransformationMatrixForm.set(3, 0, Double.parseDouble(textField_A41.getText()));
						TransformationMatrixForm.set(3, 1, Double.parseDouble(textField_A42.getText()));
						TransformationMatrixForm.set(3, 2, Double.parseDouble(textField_A43.getText()));
						TransformationMatrixForm.set(3, 3, Double.parseDouble(textField_A44.getText()));
					
					} catch (NumberFormatException e) {
						JOptionPane.showMessageDialog((Component)null,
							    "Invalid number format!",							    
							    "Error!",
							    JOptionPane.ERROR_MESSAGE);
						
						btnCreateObservation.setEnabled(true);
						
						return;
					}
					
					try{			
						TransformationFromProperties = TransformationMatrixForm;
						gen = new GenerateImage(sourceImage.dimX, sourceImage.dimY, sourceImage.dimZ, TransformationFromProperties);
						gen.GenerateObservedImage();
					}catch (Exception e) {
						JOptionPane.showMessageDialog((Component)null,
							    "Singular transformation matrix!",							    
							    "Error!",
							    JOptionPane.ERROR_MESSAGE);
						
						btnCreateObservation.setEnabled(true);
						return;
					}

				}
				
				isTransformationKnown = true;
				
				if (ObservedImageData != null)
					btnSaveObservation.setEnabled(true);

			}
		});
		btnCreateObservation.setBounds(125, 445, 142, 32);
		panel.add(btnCreateObservation);
		
		textField_SXz = new JTextField();
		textField_SXz.setEnabled(false);
		textField_SXz.setText("0.0");
		textField_SXz.setHorizontalAlignment(SwingConstants.CENTER);
		textField_SXz.setColumns(10);
		textField_SXz.setBounds(320, 158, 35, 20);
		panel.add(textField_SXz);
		
		textField_SYz = new JTextField();
		textField_SYz.setEnabled(false);
		textField_SYz.setText("0.0");
		textField_SYz.setHorizontalAlignment(SwingConstants.CENTER);
		textField_SYz.setColumns(10);
		textField_SYz.setBounds(320, 180, 35, 20);
		panel.add(textField_SYz);
		
		textField_SZy = new JTextField();
		textField_SZy.setEnabled(false);
		textField_SZy.setText("0.0");
		textField_SZy.setHorizontalAlignment(SwingConstants.CENTER);
		textField_SZy.setColumns(10);
		textField_SZy.setBounds(320, 202, 35, 20);
		panel.add(textField_SZy);
		
		JLabel lblSy = new JLabel("SHy:");
		lblSy.setBounds(211, 160, 35, 14);
		panel.add(lblSy);
		
		JLabel lblSz = new JLabel("SHz:");
		lblSz.setBounds(285, 160, 30, 14);
		panel.add(lblSz);
		
		JLabel lblSx = new JLabel("SHx:");
		lblSx.setBounds(211, 182, 33, 14);
		panel.add(lblSx);
		
		JLabel lblShz = new JLabel("SHz:");
		lblShz.setBounds(285, 182, 30, 14);
		panel.add(lblShz);
		
		JLabel lblSx_1 = new JLabel("SHx:");
		lblSx_1.setBounds(211, 203, 33, 14);
		panel.add(lblSx_1);
		
		JLabel lblSy_1 = new JLabel("SHy:");
		lblSy_1.setBounds(285, 203, 30, 14);
		panel.add(lblSy_1);
		
		JLabel lblNewLabel_1 = new JLabel("Scaling");
		lblNewLabel_1.setBounds(162, 140, 45, 14);
		panel.add(lblNewLabel_1);
		
		textField_Sx = new JTextField();
		textField_Sx.setBounds(154, 158, 53, 20);
		panel.add(textField_Sx);
		textField_Sx.setEnabled(false);
		textField_Sx.setText("1.0");
		textField_Sx.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Sx.setColumns(10);
		
		textField_Sy = new JTextField();
		textField_Sy.setBounds(154, 180, 53, 20);
		panel.add(textField_Sy);
		textField_Sy.setEnabled(false);
		textField_Sy.setText("1.0");
		textField_Sy.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Sy.setColumns(10);
		
		textField_Sz = new JTextField();
		textField_Sz.setBounds(154, 202, 53, 20);
		panel.add(textField_Sz);
		textField_Sz.setEnabled(false);
		textField_Sz.setText("1.0");
		textField_Sz.setHorizontalAlignment(SwingConstants.CENTER);
		textField_Sz.setColumns(10);
		
		chckbxRotateImageCenter_1 = new JCheckBox("Rotate as if the origin were in the image center");
		chckbxRotateImageCenter_1.setSelected(true);
		chckbxRotateImageCenter_1.setEnabled(false);
		chckbxRotateImageCenter_1.setBounds(53, 229, 286, 23);
		panel.add(chckbxRotateImageCenter_1);
		
		btnLoadFromTxt = new JButton("Load matrix from txt");
		btnLoadFromTxt.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
								
				final JFileChooser fc = new JFileChooser(".//");
				int returnVal = fc.showOpenDialog(Main.this);

			        if (returnVal == JFileChooser.APPROVE_OPTION) {
			        	File file = fc.getSelectedFile();
			        	
			        	String[] p = file.getAbsolutePath().split("\\.");

			        	if (p[p.length - 1].compareTo("txt") != 0){
			        		JOptionPane.showMessageDialog((Component)null,
								    "Please select a txt file!",
								    "Error!",
								    JOptionPane.ERROR_MESSAGE);
							
							return;
			        	}
			            
			        	try {
			        		
			        		BufferedReader reader = new BufferedReader(new FileReader(file));
			        		String[] puffer;
			        		String line;
			        		
			        		line = reader.readLine();
			        		
			        		puffer = line.split(" ");
			        		
			        		if (puffer.length < 3){
			        			
			        			line = reader.readLine();
			        			line = reader.readLine();
			        			line = reader.readLine();
			        			
			        			line = line.replaceAll(" \t", " ");	
			        			puffer = line.split(" ");
			        			
			        			for (int i = 0; i < puffer.length; i++) {
			        				puffer[i] = puffer[i].trim();
								}
			        			
			        			textField_A11.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
			        			textField_A12.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
			        			textField_A13.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
			        			textField_A14.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
			        			
			        			line = reader.readLine();
			        						        						        			
			        			line = line.replaceAll(" \t", " ");
			        			puffer = line.split(" ");
			        			
			        			for (int i = 0; i < puffer.length; i++) {
			        				puffer[i] = puffer[i].trim();
								}
			        			
			        			textField_A21.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
			        			textField_A22.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
			        			textField_A23.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
			        			textField_A24.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
			        			
			        			line = reader.readLine();
			        			
			        			line = line.replaceAll(" \t", " ");	
			        			puffer = line.split(" ");
			        			
			        			for (int i = 0; i < puffer.length; i++) {
			        				puffer[i] = puffer[i].trim();
								}

			        			textField_A31.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
			        			textField_A32.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
			        			textField_A33.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
			        			textField_A34.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
			        		} else {
			        			
			        			puffer = line.split(" ");
			        			textField_A11.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
			        			textField_A12.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
			        			textField_A13.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
			        			textField_A14.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));;
			        			
			        			line = reader.readLine();
			        			puffer = line.split(" ");
			        			textField_A21.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
			        			textField_A22.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
			        			textField_A23.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
			        			textField_A24.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
			        			
			        			line = reader.readLine();
			        			puffer = line.split(" ");
			        			textField_A31.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[0]) * 10000.0)/10000.0));
			        			textField_A32.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[1]) * 10000.0)/10000.0));
			        			textField_A33.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[2]) * 10000.0)/10000.0));
			        			textField_A34.setText(Double.toString((double)Math.round(Double.parseDouble(puffer[3]) * 10000.0)/10000.0));
			        			
			        		}
			        		
			        		lblNewLabel_2.setText(file.getName());

							
						} catch (NullPointerException e) {
						
							JOptionPane.showMessageDialog((Component)null,
								    "Invalid txt format!",
								    "Error!",
								    JOptionPane.ERROR_MESSAGE);
							
							return;
						} catch (ArrayIndexOutOfBoundsException e) {
						
							JOptionPane.showMessageDialog((Component)null,
								    "Invalid txt format!",
								    "Error!",
								    JOptionPane.ERROR_MESSAGE);
							
							return;
						} catch (IOException e) {
							JOptionPane.showMessageDialog((Component)null,
								    "Error reading file!",
								    "Error!",
								    JOptionPane.ERROR_MESSAGE);
						}
			        }
			}
		});
		btnLoadFromTxt.setEnabled(false);
		btnLoadFromTxt.setBounds(54, 305, 141, 32);
		panel.add(btnLoadFromTxt);
		
		JLabel lbldOptions = new JLabel("3D options:");
		lbldOptions.setBounds(20, 500, 96, 14);
		panel.add(lbldOptions);
		
		chckbxNewCheckBox = new JCheckBox("Show source image in 3D");
		chckbxNewCheckBox.setBounds(43, 523, 271, 23);
		chckbxNewCheckBox.addItemListener(this);
		chckbxNewCheckBox.setEnabled(false);
		panel.add(chckbxNewCheckBox);
		
		chckbxNewCheckBox_1 = new JCheckBox("Show observed image in 3D");
		chckbxNewCheckBox_1.setBounds(43, 548, 283, 23);
		chckbxNewCheckBox_1.addItemListener(this);
		chckbxNewCheckBox_1.setEnabled(false);
		panel.add(chckbxNewCheckBox_1);
		
		chckbxShowBothIn = new JCheckBox("Show result image in 3D (colored)");
		chckbxShowBothIn.setBounds(43, 598, 283, 23);
		chckbxShowBothIn.addItemListener(this);
		chckbxShowBothIn.setEnabled(false);
		panel.add(chckbxShowBothIn);
		
		JSeparator separator = new JSeparator();
		separator.setBounds(0, 48, 383, 1);
		panel.add(separator);
		
		JSeparator separator_1 = new JSeparator();
		separator_1.setBounds(0, 491, 383, 1);
		panel.add(separator_1);
		
		btnSaveObservation = new JButton("Save observation");
		btnSaveObservation.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
	
				writeImage = new WriteImage();
			}
		});
		btnSaveObservation.setEnabled(false);
		btnSaveObservation.setBounds(110, 670, 157, 32);
		panel.add(btnSaveObservation);
		
		lblNewLabel_2 = new JLabel("");
		lblNewLabel_2.setBounds(206, 315, 157, 14);
		panel.add(lblNewLabel_2);
		
		separator_4 = new JSeparator();
		separator_4.setOrientation(SwingConstants.VERTICAL);
		separator_4.setBounds(357, 580, 1, -114);
		panel.add(separator_4);
		
		chckbxShowSourceAnd = new JCheckBox("Show source and observed in 3D");
		chckbxShowSourceAnd.setEnabled(false);
		chckbxShowSourceAnd.setBounds(43, 573, 260, 23);
		chckbxShowSourceAnd.addItemListener(this);
		panel.add(chckbxShowSourceAnd);
		
		lblUnits = new JLabel("Units:");
		lblUnits.setEnabled(false);
		lblUnits.setBounds(55, 255, 44, 14);
		panel.add(lblUnits);
		
		rdbtnMm = new JRadioButton("mm");
		rdbtnMm.setSelected(true);
		buttonGroup2.add(rdbtnMm);
		rdbtnMm.setEnabled(false);
		rdbtnMm.setBounds(100, 250, 54, 23);
		rdbtnMm.addItemListener(this);
		panel.add(rdbtnMm);
		
		rdbtnPixels = new JRadioButton("pixels");
		rdbtnPixels.setEnabled(false);
		buttonGroup2.add(rdbtnPixels);
		rdbtnPixels.setBounds(155, 250, 109, 23);
		rdbtnPixels.addItemListener(this);
		panel.add(rdbtnPixels);
		
		JButton btnReset = new JButton("Reset GUI");
		btnReset.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				
				setTitle("3D Binary Registration");
				
				btnOpen.setEnabled(true);
				btnNewButton.setEnabled(true);
				btnCreateObservation.setEnabled(false);
				btnLoadFromTxt.setEnabled(false);
				btnSaveObservation.setEnabled(false);
				btnStartRegistration.setEnabled(false);
				btnSaveRegisteredImage.setEnabled(false);				
				rdbtnOpenObservedd.setSelected(true);
				
				textField_A31.setText("0.0");
				textField_A32.setText("0.0");
				textField_A33.setText("1.0");
				textField_A34.setText("0.0");
				textField_A21.setText("0.0");
				textField_A22.setText("1.0");
				textField_A23.setText("0.0");
				textField_A24.setText("0.0");
				textField_A11.setText("1.0");
				textField_A12.setText("0.0");
				textField_A13.setText("0.0");
				textField_A14.setText("0.0");
				
				textField_A31.setEnabled(false);
				textField_A32.setEnabled(false);
				textField_A33.setEnabled(false);
				textField_A34.setEnabled(false);
				textField_A21.setEnabled(false);
				textField_A22.setEnabled(false);
				textField_A23.setEnabled(false);
				textField_A24.setEnabled(false);
				textField_A11.setEnabled(false);
				textField_A12.setEnabled(false);
				textField_A13.setEnabled(false);
				textField_A14.setEnabled(false);
				
				textField_Tx.setText("0.0");
				textField_Ty.setText("0.0");
				textField_Tz.setText("0.0");
				textField_Rx.setText("0.0");
				textField_Ry.setText("0.0");
				textField_Rz.setText("0.0");
				textField_Sx.setText("1.0");
				textField_Sy.setText("1.0");
				textField_Sz.setText("1.0");
				textField_SXy.setText("0.0");
				textField_SXz.setText("0.0");
				textField_SYx.setText("0.0");
				textField_SYz.setText("0.0");
				textField_SZy.setText("0.0");
				textField_SZx.setText("0.0");
				
				textField_Tx.setEnabled(false);
				textField_Ty.setEnabled(false);
				textField_Tz.setEnabled(false);
				textField_Rx.setEnabled(false);
				textField_Ry.setEnabled(false);
				textField_Rz.setEnabled(false);
				textField_Sx.setEnabled(false);
				textField_Sy.setEnabled(false);
				textField_Sz.setEnabled(false);
				textField_SXy.setEnabled(false);
				textField_SXz.setEnabled(false);
				textField_SYx.setEnabled(false);
				textField_SYz.setEnabled(false);
				textField_SZy.setEnabled(false);
				textField_SZx.setEnabled(false);		
			
				chckbxNewCheckBox.setSelected(false);
				chckbxNewCheckBox.setEnabled(false);
			
				chckbxNewCheckBox_1.setSelected(false);
				chckbxNewCheckBox_1.setEnabled(false);	

				chckbxShowBothIn.setSelected(false);
				chckbxShowBothIn.setEnabled(false);
			
				chckbxShowSourceAnd.setSelected(false);
				chckbxShowSourceAnd.setEnabled(false);
				
				chckbxShowResultImage.setSelected(false);
				chckbxShowResultImage.setEnabled(false);
					

					choice.select(2);
					
					textField.setText("70.0");
					textField_1.setText("30");
					
					chckbxRigid.setSelected(false);
					rdbtnCalculateJacobi.setSelected(true);
					rdbtnCalculateJacobi.setEnabled(false);
					rdbtnJacobi.setEnabled(false);
					
					textField_R11.setText("?");
					textField_R21.setText("?");
					textField_R31.setText("?");
					
					textField_R12.setText("?");
					textField_R22.setText("?");
					textField_R32.setText("?");
					
					textField_R13.setText("?");
					textField_R23.setText("?");
					textField_R33.setText("?");
					
					textField_R14.setText("?");
					textField_R24.setText("?");
					textField_R34.setText("?");

					
					lblConsumedCpuTime.setText("Consumed CPU time:");
					lblNewLabel_3.setText("Number of iterations:");
					lblNewLabel_4.setText("Algebraic error:");
					lblGeometricError.setText("Delta error:");
					lblSourceImageRead.setText("Source image read time:");
					lblNewLabel_5.setText("Observed image read/generation time:");
					lblResultImageGeneration.setText("Result image generation time:");
					lblLmaOptimzerTime.setText("Levenberg \u2013 Marquardt optimzer time:");
					lblEpsilonErrorCalculation.setText("Epsilon error calculation time:");
					lblConstructionTimeOf.setText("Construction time of the equations:");
					lblTotalRegistrationTime.setText("Total registration time:");					
					lblJacobian.setText("Jacobian:");
					lblEpsilonError.setText("Epsilon error:");
					lblNumberOfScanned.setText("Number of scanned orientations:");
					
					rdbtnColoured.setEnabled(false);
					rdbtnColoured.setSelected(true);
					rdbtnRegistrationResult.setEnabled(false);
					rdbtnXorResult.setEnabled(false);
					btnSaveOriginalImage.setEnabled(false);
					
					coloured = true;
					registered = false;
					Xor = false;
					
			
					SourceHeader = null;
					XorImage  = null;
					XorImagePuffer  = null;
					imageData  = null;
					ObservedImageData  = null;
					ObservedImageDataPuffer  = null;
									
					renderSource = null;
					renderObserved = null;
					renderResult = null;
					renderSAndO = null;
					renderReg = null;
					
			
	
					
					try{
						Observedframe.setVisible(false);
						//Observedframe.dispose();
					}catch (Exception e) {
						
					}
					
					try{
						XorFrame.setVisible(false);
						//XorFrame.dispose();
					}catch (Exception e) {
						
					}
					
					try{
						observedImage.frame2.setVisible(false);
						//observedImage.frame2.dispose();
					}catch (Exception e) {
						
					}
					
					try{
						sourceImage.frame1.setVisible(false);
						//sourceImage.frame1.dispose();
					}catch (Exception e) {
					
					}
					
					Observedframe = null;
					XorFrame = null;
					gen = null;
					
					observedImage = null;
					sourceImage = null;
					writeImage = null;
					reg = null;
					
					System.gc();
					
					
					T = Matrix.identity(4, 4);
					R = Matrix.identity(4, 4);
					S = Matrix.identity(4, 4);
					Sh = Matrix.identity(4, 4);
					Rx = Matrix.identity(4, 4);
					Ry = Matrix.identity(4, 4);
					Rz = Matrix.identity(4, 4);
					TranslateCenterToOrigine = Matrix.identity(4, 4);
					TranslateCenterBack = Matrix.identity(4, 4);
					TransformationMatrixForm = Matrix.identity(4, 4);
					TransformationFromProperties = Matrix.identity(4, 4);
				
					rotaion = false; Xor = false; isTransformationKnown = false; mm = true; isGen = false; isJacobian = true; isRigid = false;
					radioButtonID = 0;
					txtFile = "";
			
					
					choiceIndex = 2;
					IterationLimit = 20;
					fvalLimit = 100.0;
					
					allReady = 0; BothReady = 0; allReady3D = 0;
					sVx = 1.0f; sVy = 1.0f; sVz = 1.0f;
					oVx = 1.0f; oVy = 1.0f; oVz = 1.0f;
					
					lblUnits.setEnabled(false);
					rdbtnMm.setSelected(true);
					rdbtnMm.setEnabled(false);
					rdbtnPixels.setEnabled(false);
					
					lblNewLabel_2.setText("");
					
					rdbtnOpenObservedd.setEnabled(true);
					rdbtnGenerateObservationFrom.setEnabled(true);
					rdbtnGenerateObservationFrom_1.setEnabled(true);
					
			}
		});
		btnReset.setBounds(110, 710, 157, 32);
		panel.add(btnReset);
		
		separator_8 = new JSeparator();
		separator_8.setBounds(0, 655, 383, 2);
		panel.add(separator_8);
		
		chckbxShowResultImage = new JCheckBox("Show result image in 3D (registered)");
		chckbxShowResultImage.setEnabled(false);
		chckbxShowResultImage.addItemListener(this);
		chckbxShowResultImage.setBounds(43, 623, 305, 23);
		panel.add(chckbxShowResultImage);
		
		JPanel panel_1 = new JPanel();
		splitPane.setRightComponent(panel_1);
		panel_1.setLayout(null);
		
		btnStartRegistration = new JButton("Start registration");
		btnStartRegistration.setEnabled(false);
		btnStartRegistration.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
								
				try{
					fvalLimit = Double.parseDouble(textField.getText());
					IterationLimit = Integer.parseInt(textField_1.getText());
					reg = new Registration();
				}catch (OutOfMemoryError e) {
					JOptionPane.showMessageDialog((Component)null,
						    "There is not enough memory to generate the Result image!\n" +
						    "Please try to allocate more heap space.",
						    "Error!",
						    JOptionPane.ERROR_MESSAGE);
				} catch (NumberFormatException e) {
					JOptionPane.showMessageDialog((Component)null,
						    "Please give a valid algebraic error limit or iteration limit",
						    "Error!",
						    JOptionPane.ERROR_MESSAGE);
				} catch (NegativeArraySizeException e) {

					JOptionPane.showMessageDialog((Component)null,
						    "Integer overflow while generating the Result image (Negative array size)!\n",
						    "Error!",
						    JOptionPane.ERROR_MESSAGE);
				} catch (ArrayIndexOutOfBoundsException e) {
					e.printStackTrace();
					JOptionPane.showMessageDialog((Component)null,
						    "Registration error!",
						    "Error!",
						    JOptionPane.ERROR_MESSAGE);
				}
			}
		});
		btnStartRegistration.setBounds(123, 141, 136, 46);
		panel_1.add(btnStartRegistration);
		
		JLabel lblThe = new JLabel("Found transformation matrix:");
		lblThe.setBounds(20, 198, 162, 14);
		panel_1.add(lblThe);
		
		textField_R11 = new JTextField();
		textField_R11.setEditable(false);
		textField_R11.setText("?");
		textField_R11.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R11.setColumns(10);
		textField_R11.setBounds(30, 223, 80, 20);
		panel_1.add(textField_R11);
		
		textField_R12 = new JTextField();
		textField_R12.setEditable(false);
		textField_R12.setText("?");
		textField_R12.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R12.setColumns(10);
		textField_R12.setBounds(112, 223, 80, 20);
		panel_1.add(textField_R12);
		
		textField_R13 = new JTextField();
		textField_R13.setEditable(false);
		textField_R13.setText("?");
		textField_R13.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R13.setColumns(10);
		textField_R13.setBounds(194, 223, 80, 20);
		panel_1.add(textField_R13);
		
		textField_R14 = new JTextField();
		textField_R14.setEditable(false);
		textField_R14.setText("?");
		textField_R14.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R14.setColumns(10);
		textField_R14.setBounds(276, 223, 80, 20);
		panel_1.add(textField_R14);
		
		textField_R24 = new JTextField();
		textField_R24.setEditable(false);
		textField_R24.setText("?");
		textField_R24.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R24.setColumns(10);
		textField_R24.setBounds(276, 245, 80, 20);
		panel_1.add(textField_R24);
		
		textField_R23 = new JTextField();
		textField_R23.setEditable(false);
		textField_R23.setText("?");
		textField_R23.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R23.setColumns(10);
		textField_R23.setBounds(194, 245, 80, 20);
		panel_1.add(textField_R23);
		
		textField_R22 = new JTextField();
		textField_R22.setEditable(false);
		textField_R22.setText("?");
		textField_R22.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R22.setColumns(10);
		textField_R22.setBounds(112, 245, 80, 20);
		panel_1.add(textField_R22);
		
		textField_R21 = new JTextField();
		textField_R21.setEditable(false);
		textField_R21.setText("?");
		textField_R21.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R21.setColumns(10);
		textField_R21.setBounds(30, 245, 80, 20);
		panel_1.add(textField_R21);
		
		textField_R31 = new JTextField();
		textField_R31.setEditable(false);
		textField_R31.setText("?");
		textField_R31.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R31.setColumns(10);
		textField_R31.setBounds(30, 267, 80, 20);
		panel_1.add(textField_R31);
		
		textField_37 = new JTextField();
		textField_37.setEditable(false);
		textField_37.setText("0.0");
		textField_37.setHorizontalAlignment(SwingConstants.CENTER);
		textField_37.setColumns(10);
		textField_37.setBounds(30, 289, 80, 20);
		panel_1.add(textField_37);
		
		textField_38 = new JTextField();
		textField_38.setEditable(false);
		textField_38.setText("0.0");
		textField_38.setHorizontalAlignment(SwingConstants.CENTER);
		textField_38.setColumns(10);
		textField_38.setBounds(112, 289, 80, 20);
		panel_1.add(textField_38);
		
		textField_R32 = new JTextField();
		textField_R32.setEditable(false);
		textField_R32.setText("?");
		textField_R32.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R32.setColumns(10);
		textField_R32.setBounds(112, 267, 80, 20);
		panel_1.add(textField_R32);
		
		textField_R33 = new JTextField();
		textField_R33.setEditable(false);
		textField_R33.setText("?");
		textField_R33.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R33.setColumns(10);
		textField_R33.setBounds(194, 267, 80, 20);
		panel_1.add(textField_R33);
		
		textField_41 = new JTextField();
		textField_41.setEditable(false);
		textField_41.setText("0.0");
		textField_41.setHorizontalAlignment(SwingConstants.CENTER);
		textField_41.setColumns(10);
		textField_41.setBounds(194, 289, 80, 20);
		panel_1.add(textField_41);
		
		textField_42 = new JTextField();
		textField_42.setEditable(false);
		textField_42.setText("1.0");
		textField_42.setHorizontalAlignment(SwingConstants.CENTER);
		textField_42.setColumns(10);
		textField_42.setBounds(276, 289, 80, 20);
		panel_1.add(textField_42);
		
		textField_R34 = new JTextField();
		textField_R34.setEditable(false);
		textField_R34.setText("?");
		textField_R34.setHorizontalAlignment(SwingConstants.CENTER);
		textField_R34.setColumns(10);
		textField_R34.setBounds(276, 267, 80, 20);
		panel_1.add(textField_R34);
		
		lblConsumedCpuTime = new JLabel("Consumed CPU time:");
		lblConsumedCpuTime.setBounds(20, 329, 349, 14);
		panel_1.add(lblConsumedCpuTime);
		
		JSeparator separator_2 = new JSeparator();
		separator_2.setBounds(0, 320, 384, 2);
		panel_1.add(separator_2);
		
		lblNewLabel_3 = new JLabel("Number of iterations:");
		lblNewLabel_3.setBounds(20, 369, 349, 14);
		panel_1.add(lblNewLabel_3);
		
		lblNewLabel_4 = new JLabel("Algebraic error:");
		lblNewLabel_4.setBounds(20, 389, 349, 14);
		panel_1.add(lblNewLabel_4);
		
		lblGeometricError = new JLabel("Delta error:");
		lblGeometricError.setBounds(20, 409, 349, 14);
		panel_1.add(lblGeometricError);
		
		choice = new Choice();
		choice.setBounds(290, 10, 70, 20);
		choice.add("identical");
		choice.add("2x2x2");
		choice.add("3x3x3");
		choice.add("4x4x4");
		choice.add("5x5x5");
		choice.select(2);
		choice.addItemListener(this);
		panel_1.add(choice);
		
		JLabel lblStartVectorOrientations = new JLabel("Number of orientations for the pre-optimizer:");
		lblStartVectorOrientations.setBounds(20, 11, 264, 14);
		panel_1.add(lblStartVectorOrientations);
		
		JLabel lblAlgebraicErrorLimit = new JLabel("Algebraic error limit for the pre-optimizer:");
		lblAlgebraicErrorLimit.setBounds(20, 40, 264, 14);
		panel_1.add(lblAlgebraicErrorLimit);
		
		textField = new JTextField();
		textField.setHorizontalAlignment(SwingConstants.CENTER);
		textField.setText("70.0");
		textField.setBounds(290, 40, 70, 20);
		panel_1.add(textField);
		textField.setColumns(10);
		
		lblEpsilonError = new JLabel("Epsilon error:");
		lblEpsilonError.setBounds(20, 429, 349, 14);
		panel_1.add(lblEpsilonError);
		
		JSeparator separator_3 = new JSeparator();
		separator_3.setBounds(0, 500, 384, 2);
		panel_1.add(separator_3);
		
		lblStatictics = new JLabel("Consumed time details:");
		lblStatictics.setBounds(20, 512, 277, 14);
		panel_1.add(lblStatictics);
		
		lblSourceImageRead = new JLabel("Source image read time:");
		lblSourceImageRead.setBounds(43, 537, 316, 14);
		panel_1.add(lblSourceImageRead);
		
		lblNewLabel_5 = new JLabel("Observed image read/generation time:");
		lblNewLabel_5.setBounds(43, 557, 326, 14);
		panel_1.add(lblNewLabel_5);
		
		lblResultImageGeneration = new JLabel("Result image generation time:");
		lblResultImageGeneration.setBounds(43, 647, 316, 14);
		panel_1.add(lblResultImageGeneration);
		
		lblLmaOptimzerTime = new JLabel("Levenberg \u2013 Marquardt optimzer time:");
		lblLmaOptimzerTime.setBounds(43, 602, 305, 14);
		panel_1.add(lblLmaOptimzerTime);
		
		lblEpsilonErrorCalculation = new JLabel("Epsilon error calculation time:");
		lblEpsilonErrorCalculation.setBounds(43, 667, 316, 14);
		panel_1.add(lblEpsilonErrorCalculation);
		
		lblConstructionTimeOf = new JLabel("Construction time of the equations:");
		lblConstructionTimeOf.setBounds(43, 582, 316, 14);
		panel_1.add(lblConstructionTimeOf);
		
		lblTotalRegistrationTime = new JLabel("Total registration time:");
		lblTotalRegistrationTime.setBounds(43, 622, 316, 14);
		panel_1.add(lblTotalRegistrationTime);
		
		lblJacobian = new JLabel("Jacobian:");
		lblJacobian.setBounds(20, 449, 266, 14);
		panel_1.add(lblJacobian);
		
		JSeparator separator_5 = new JSeparator();
		separator_5.setBounds(20, 577, 326, 2);
		panel_1.add(separator_5);
		
		JLabel lblIterationNumberLimit = new JLabel("Iteration number limit for the pre-optimizer:");
		lblIterationNumberLimit.setBounds(20, 70, 264, 14);
		panel_1.add(lblIterationNumberLimit);
		
		textField_1 = new JTextField();
		textField_1.setText("30");
		textField_1.setHorizontalAlignment(SwingConstants.CENTER);
		textField_1.setColumns(10);
		textField_1.setBounds(290, 70, 70, 20);
		panel_1.add(textField_1);
		
		chckbxRigid = new JCheckBox("Rigid transformation only");
		chckbxRigid.setBounds(20, 91, 168, 23);
		chckbxRigid.addItemListener(this);
		panel_1.add(chckbxRigid);
		
		separator_6 = new JSeparator();
		separator_6.setBounds(20, 642, 326, 2);
		panel_1.add(separator_6);
		

		rdbtnJacobi = new JRadioButton("Jacobian = 1");
		rdbtnJacobi.setEnabled(false);
		buttonGroup3.add(rdbtnJacobi);
		rdbtnJacobi.addItemListener(this);
		rdbtnJacobi.setBounds(73, 111, 96, 23);
		panel_1.add(rdbtnJacobi);
		
		rdbtnCalculateJacobi = new JRadioButton("Calculate Jacobian");
		rdbtnCalculateJacobi.setSelected(true);
		rdbtnCalculateJacobi.setEnabled(false);
		buttonGroup3.add(rdbtnCalculateJacobi);
		rdbtnCalculateJacobi.addItemListener(this);
		rdbtnCalculateJacobi.setBounds(177, 111, 169, 23);
		panel_1.add(rdbtnCalculateJacobi);
		
		btnSaveTransformationMatrix = new JButton("Save matrix");
		btnSaveTransformationMatrix.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
					
				SaveResultMatrix srm = new SaveResultMatrix();
				srm.Write();
			}
		});
		btnSaveTransformationMatrix.setBounds(194, 194, 162, 23);
		panel_1.add(btnSaveTransformationMatrix);
		
		btnSaveRegisteredImage = new JButton("Save registered");
		btnSaveRegisteredImage.setEnabled(false);
		btnSaveRegisteredImage.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				SaveRegisteredImage sri = new SaveRegisteredImage();
				sri.Write();
			}
		});
		btnSaveRegisteredImage.setBounds(39, 727, 130, 32);
		panel_1.add(btnSaveRegisteredImage);
		
		separator_7 = new JSeparator();
		separator_7.setBounds(0, 692, 384, 2);
		panel_1.add(separator_7);
		
		rdbtnColoured = new JRadioButton("Colored image");
		rdbtnColoured.setEnabled(false);
		rdbtnColoured.setSelected(true);
		rdbtnColoured.setBounds(17, 470, 101, 23);
		buttonGroup4.add(rdbtnColoured);
		rdbtnColoured.addItemListener(this);
		panel_1.add(rdbtnColoured);
		
		rdbtnXorResult = new JRadioButton("Xor image");
		rdbtnXorResult.setEnabled(false);
		rdbtnXorResult.setBounds(127, 470, 86, 23);
		buttonGroup4.add(rdbtnXorResult);
		rdbtnXorResult.addItemListener(this);
		panel_1.add(rdbtnXorResult);
		
		rdbtnRegistrationResult = new JRadioButton("Registered image");
		rdbtnRegistrationResult.setEnabled(false);
		rdbtnRegistrationResult.setBounds(222, 470, 134, 23);
		buttonGroup4.add(rdbtnRegistrationResult);
		rdbtnRegistrationResult.addItemListener(this);
		panel_1.add(rdbtnRegistrationResult);
		
		JButton button = new JButton("?");
		button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				About ab = new About();
				ab.Show();
			}
		});
		button.setBounds(347, 747, 37, 23);
		panel_1.add(button);
		
		lblNumberOfScanned = new JLabel("Number of scanned orientations:");
		lblNumberOfScanned.setBounds(20, 349, 316, 14);
		panel_1.add(lblNumberOfScanned);
		
		btnSaveOriginalImage = new JButton("Save original");
		btnSaveOriginalImage.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				SaveOriginalImage soi = new SaveOriginalImage();
				soi.Write();
			}
		});
		btnSaveOriginalImage.setEnabled(false);
		btnSaveOriginalImage.setBounds(185, 727, 130, 32);
		panel_1.add(btnSaveOriginalImage);
		
		JLabel lblSaveTheOriginal = new JLabel("Save the original and observed images (same dimensions):");
		lblSaveTheOriginal.setBounds(20, 702, 349, 14);
		panel_1.add(lblSaveTheOriginal);
		
	}


	@Override
	public void actionPerformed(ActionEvent e) {

		if (e.getSource() == rdbtnOpenObservedd){
			
			radioButtonID = 0;
			
			btnNewButton.setEnabled(true);
			btnCreateObservation.setEnabled(false);
			
			textField_A11.setEnabled(false);
			textField_A12.setEnabled(false);
			textField_A13.setEnabled(false);
			textField_A14.setEnabled(false);
			textField_A21.setEnabled(false);
			textField_A22.setEnabled(false);
			textField_A23.setEnabled(false);
			textField_A24.setEnabled(false);
			textField_A31.setEnabled(false);
			textField_A32.setEnabled(false);
			textField_A33.setEnabled(false);
			textField_A34.setEnabled(false);
			textField_A41.setEnabled(false);
			textField_A42.setEnabled(false);
			textField_A43.setEnabled(false);
			textField_A44.setEnabled(false);
			
			textField_Tx.setEnabled(false);
			textField_Ty.setEnabled(false);
			textField_Tz.setEnabled(false);
			textField_Sx.setEnabled(false);
			textField_Sy.setEnabled(false);
			textField_Sz.setEnabled(false);
			textField_Rx.setEnabled(false);
			textField_Ry.setEnabled(false);
			textField_Rz.setEnabled(false);
			textField_SYz.setEnabled(false);
			textField_SXy.setEnabled(false);
			textField_SXz.setEnabled(false);
			textField_SYx.setEnabled(false);
			textField_SYz.setEnabled(false);
			textField_SZx.setEnabled(false);
			textField_SZy.setEnabled(false);
			
			chckbxRotateImageCenter_1.setEnabled(false);
			btnLoadFromTxt.setEnabled(false);
			
			rdbtnMm.setEnabled(false);
			rdbtnPixels.setEnabled(false);
			lblUnits.setEnabled(false);
				
			
		} else if (e.getSource() == rdbtnGenerateObservationFrom){
			
			radioButtonID = 1;
			
			textField_A11.setEnabled(false);
			textField_A12.setEnabled(false);
			textField_A13.setEnabled(false);
			textField_A14.setEnabled(false);
			textField_A21.setEnabled(false);
			textField_A22.setEnabled(false);
			textField_A23.setEnabled(false);
			textField_A24.setEnabled(false);
			textField_A31.setEnabled(false);
			textField_A32.setEnabled(false);
			textField_A33.setEnabled(false);
			textField_A34.setEnabled(false);
			textField_A41.setEnabled(false);
			textField_A42.setEnabled(false);
			textField_A43.setEnabled(false);
			textField_A44.setEnabled(false);
			
			textField_Tx.setEnabled(true);
			textField_Ty.setEnabled(true);
			textField_Tz.setEnabled(true);
			textField_Sx.setEnabled(true);
			textField_Sy.setEnabled(true);
			textField_Sz.setEnabled(true);
			textField_Rx.setEnabled(true);
			textField_Ry.setEnabled(true);
			textField_Rz.setEnabled(true);
			textField_SYz.setEnabled(true);
			textField_SXy.setEnabled(true);
			textField_SXz.setEnabled(true);
			textField_SYx.setEnabled(true);
			textField_SYz.setEnabled(true);
			textField_SZx.setEnabled(true);
			textField_SZy.setEnabled(true);
			
			btnNewButton.setEnabled(false);
			btnCreateObservation.setEnabled(true);
			
			chckbxRotateImageCenter_1.setEnabled(true);
			btnLoadFromTxt.setEnabled(false);
			
			rdbtnMm.setEnabled(true);
			rdbtnPixels.setEnabled(true);
			lblUnits.setEnabled(true);
			
		} else if (e.getSource() == rdbtnGenerateObservationFrom_1){
			
			radioButtonID = 2;
			
			textField_A11.setEnabled(true);
			textField_A12.setEnabled(true);
			textField_A13.setEnabled(true);
			textField_A14.setEnabled(true);
			textField_A21.setEnabled(true);
			textField_A22.setEnabled(true);
			textField_A23.setEnabled(true);
			textField_A24.setEnabled(true);
			textField_A31.setEnabled(true);
			textField_A32.setEnabled(true);
			textField_A33.setEnabled(true);
			textField_A34.setEnabled(true);
			textField_A41.setEnabled(false);
			textField_A42.setEnabled(false);
			textField_A43.setEnabled(false);
			textField_A44.setEnabled(false);
			
			textField_Tx.setEnabled(false);
			textField_Ty.setEnabled(false);
			textField_Tz.setEnabled(false);
			textField_Sx.setEnabled(false);
			textField_Sy.setEnabled(false);
			textField_Sz.setEnabled(false);
			textField_Rx.setEnabled(false);
			textField_Ry.setEnabled(false);
			textField_Rz.setEnabled(false);
			textField_SYz.setEnabled(false);
			textField_SXy.setEnabled(false);
			textField_SXz.setEnabled(false);
			textField_SYx.setEnabled(false);
			textField_SYz.setEnabled(false);
			textField_SZx.setEnabled(false);
			textField_SZy.setEnabled(false);
			
			btnNewButton.setEnabled(false);
			btnCreateObservation.setEnabled(true);
			
			chckbxRotateImageCenter_1.setEnabled(false);
			btnLoadFromTxt.setEnabled(true);	
			
			rdbtnMm.setEnabled(false);
			rdbtnPixels.setEnabled(false);
			lblUnits.setEnabled(false);
			
		}
	}

	@Override
	public void itemStateChanged(ItemEvent e) {
		
		Object source = e.getItemSelectable();
		
		if (source == chckbxNewCheckBox){
			
			if (!chckbxNewCheckBox.isSelected()){
				
				renderSource.kill();
				renderSource = null;
				return;
			}
			
			renderSource = new RenderSource3D();
			renderSource.start();
			
		} else if(source == chckbxNewCheckBox_1){

			if (!chckbxNewCheckBox_1.isSelected()){
			
				renderObserved.kill();
				renderObserved = null;
				return;
			}
			
			renderObserved = new RenderObserved3D();
			renderObserved.start();
			
		} else if(source == chckbxShowBothIn){

			if (!chckbxShowBothIn.isSelected()){
				renderResult.kill();
				renderResult = null;
				return;
			}
			
			renderResult = new RenderResult3Dcolored();
			renderResult.start();
			
		} else if(source == chckbxShowSourceAnd){

			if (!chckbxShowSourceAnd.isSelected()){
			
				renderSAndO.kill();
				renderSAndO = null;
				return;
			}
			renderSAndO = new RenderSourceAndObserved3D();
			renderSAndO.start();
			
		} else if(source == chckbxShowResultImage){

			if (!chckbxShowResultImage.isSelected()){
			
				renderReg.kill();
				renderReg = null;
				return;
			}
			renderReg = new RenderResult3Dregistered();
			renderReg.start();
			
		}else if(source == rdbtnColoured || source == rdbtnRegistrationResult ||source == rdbtnXorResult){
			
			try{
				if (rdbtnColoured.isSelected()){
					coloured = true;
					registered = false;
					Xor = false;
				}
				
				if (rdbtnRegistrationResult.isSelected()){
					coloured = false;
					registered = true;
					Xor = false;
				}
				
				if (rdbtnXorResult.isSelected()){
					coloured = false;
					registered = false;
					Xor = true;
				}
	
				XorFrame.DisplayObservedImage();
			}catch (Exception ex) {
				
			}
			
			
		} else if (source == choice){
			choiceIndex = choice.getSelectedIndex();
		} else if (source == rdbtnMm){
			
			if (rdbtnMm.isSelected()){
				mm = true;
			} else {
				mm = false;
			}
		} else if (source == chckbxRigid){
			
			if (chckbxRigid.isSelected()){
				isRigid = true;
				rdbtnCalculateJacobi.setEnabled(true);
				rdbtnJacobi.setEnabled(true);
				
				if (rdbtnJacobi.isSelected()){
					isJacobian = false;
				} else {
					isJacobian = true;
				}
				
			} else {
				isRigid = false;
				rdbtnCalculateJacobi.setEnabled(false);
				rdbtnJacobi.setEnabled(false);
				
				isJacobian = true;
			}
			
			
			
		}  else if (source == rdbtnJacobi){
			
			if (rdbtnJacobi.isSelected()){
				isJacobian = false;
			} else {
				isJacobian = true;
			}
		}
		
	}
}
