package registration;
import generate.GenerateResultImage;
import levenbergMarquard.LM;
import levenbergMarquard.LMfunc;
import levenbergMarquard.MyFunction;
import main.Main;
import Jama.Matrix;

public class Registration {
	
	public double sourceObjectPnumber;
	public double observedObjectPnumber;
	
	public double minSourceX, minSourceY, minSourceZ;
	public double maxSourceX, maxSourceY, maxSourceZ;
	
	public double minObservedX, minObservedY, minObservedZ;
	public double maxObservedX, maxObservedY, maxObservedZ;
	
	public double midSX, midSY, midSZ;
	public double midOX, midOY, midOZ;
	
	public double scale, sx, sy, sz, Jacobi, iJacobi;
	
	public static double px, py, pz;
	public static double px2, pxpy, pxpz, py2, pypz, pz2;
	public static double pxpz2, pypz2, px2py, py2pz, px2pz, pxpy2, pxpypz, py3, px3, pz3;
	
	public static double ipx, ipy, ipz;
	public static double ipx2, ipxpy, ipxpz, ipy2, ipypz, ipz2;
	public static double ipxpz2, ipypz2, ipx2py, ipy2pz, ipx2pz, ipxpy2, ipxpypz, ipy3, ipx3, ipz3;
	
	public static double qx, qy, qz, mu;
	public static double qx2, qxqy, qxqz, qy2, qyqz, qz2;
	public static double qxqz2, qyqz2, qx2qy, qy2qz, qx2qz, qxqy2, qxqyqz, qy3, qx3, qz3;

	public static double iqx, iqy, iqz, imu;
	public static double iqx2, iqxqy, iqxqz, iqy2, iqyqz, iqz2;
	public static double iqxqz2, iqyqz2, iqx2qy, iqy2qz, iqx2qz, iqxqy2, iqxqyqz, iqy3, iqx3, iqz3;

	public static double eq1_x_r, eq2_x_r, eq3_x_r;
	public static double eq1_y_r, eq2_y_r, eq3_y_r;
	public static double eq1_z_r, eq2_z_r, eq3_z_r;
	
	public static double ieq1_x_r, ieq2_x_r, ieq3_x_r;
	public static double ieq1_y_r, ieq2_y_r, ieq3_y_r;
	public static double ieq1_z_r, ieq2_z_r, ieq3_z_r;
	
	static int x1, y1, z1, offsX, offsY, offsZ;
	static int x2, y2, z2, offoX, offoY, offoZ;
	static double vsX, vsY, vsZ;
	static double voX, voY, voZ;
	
	int mainIterCount, totalIter;
	
	double cx1, cx2, cx3, sx1, sx2, sx3;
	
	double epsilon;
	
	Matrix finRes;
	
	double fvalmin = Double.MAX_VALUE;
	
	double[][] res = new double[4][4];
	
	public class SourceEq implements Runnable{

		int mode;

		public SourceEq(int mode){
			this.mode = mode;
		}
		
		
		@Override
		public void run() {
			
			if (mode == 0){	
				
				double puffi, puffj, puffk;
				int index = 0;
				
				for (int k = 0; k < z1; k++) {
					for (int j = 0; j < y1; j++) {
						for (int i = 0; i < x1; i++) {
							
							if (Main.imageData[index] != 0){
	
								sourceObjectPnumber++;
								puffi = (i + offsX) * vsX;
								puffj = (j + offsY) * vsY;
								puffk = (k + offsZ) * vsZ;
								
								if (puffi  < minSourceX)
									minSourceX = puffi;
														
								if (puffj < minSourceY)
									minSourceY = puffj;
								
								if (puffk < minSourceZ)
									minSourceZ = puffk;
								
								
								if (puffi > maxSourceX)
									maxSourceX = puffi;
																				
								if (puffj > maxSourceY)
									maxSourceY = puffj;
								
								if (puffk > maxSourceZ)
									maxSourceZ = puffk;
	
							}
							
							index++;
							
						}
					}
				}
				
				midSX = (maxSourceX + minSourceX) / 2.0;
				midSY = (maxSourceY + minSourceY) / 2.0;
				midSZ = (maxSourceZ + minSourceZ) / 2.0;
			
			} else {
				
				double pufferX, pufferY, pufferZ;
				double pufferX2, pufferY2, pufferZ2;
				
				int index = 0;
				
				for (int k = 0; k < z1; k++) {
					for (int j = 0; j < y1; j++) {
						for (int i = 0; i < x1; i++) {
							
							if (Main.imageData[index] != 0){
								
								pufferX = ((i + offsX) * vsX - midSX) / scale;
								pufferY = ((j + offsY) * vsY - midSY) / scale;
								pufferZ = ((k + offsZ) * vsZ - midSZ) / scale;
								
								pufferX2 = pufferX * pufferX;
								pufferY2 = pufferY * pufferY;
								pufferZ2 = pufferZ * pufferZ;
								
								px += pufferX;
								px2 += pufferX2;
								px3 += pufferX2 * pufferX;
								px2py += pufferX2 * pufferY;
								px2pz += pufferX2 * pufferZ;
								
								py += pufferY;
								py2 += pufferY2;
								py3 += pufferY2 * pufferY;
								pxpy2 += pufferX * pufferY2;
								py2pz += pufferY2 * pufferZ;
								
								pxpy += pufferX * pufferY;
								
								pz += pufferZ;
								pz2 += pufferZ2;
								pz3 += pufferZ2 * pufferZ;
								pxpz += pufferX * pufferZ;
								pypz += pufferY * pufferZ;
								pxpz2 += pufferX * pufferZ2;
								pypz2 += pufferY * pufferZ2;
								
								pxpypz += pufferX * pufferY * pufferZ;

							}
							
							index++;
						}
					}
				}
				
				iqx = px;
				iqx2 = px2;
				iqx3 = px3;
				iqx2qy = px2py;
				iqx2qz = px2pz;
				iqy = py;
				iqy2 = py2;
				iqy3 = py3;
				iqxqy2 = pxpy2;
				iqy2qz = py2pz;
				iqxqy = pxpy;
				iqz = pz;
				iqz2 = pz2;
				iqz3 = pz3;
				iqxqz = pxpz;
				iqyqz = pypz;
				iqxqz2 = pxpz2;
				iqyqz2 = pypz2;
				iqxqyqz = pxpypz;
				
				px *= Jacobi;
				px2 *= Jacobi;
				px3 *= Jacobi;
				px2py *= Jacobi;
				px2pz *= Jacobi;
				py *= Jacobi;
				py2 *= Jacobi;
				py3 *= Jacobi;
				pxpy2 *= Jacobi;
				py2pz *= Jacobi;
				pxpy *= Jacobi;
				pz *= Jacobi;
				pz2 *= Jacobi;
				pz3 *= Jacobi;
				pxpz *= Jacobi;
				pypz *= Jacobi;
				pxpz2 *= Jacobi;
				pypz2 *= Jacobi;
				pxpypz *= Jacobi;
			}
			
		}
		
	}
	
	public class ObservedEq implements Runnable{
		
		int mode;

		public ObservedEq(int mode){
			this.mode = mode;
		}
		
		@Override
		public void run() {
			
			if (mode == 0){		
				double puffi, puffj, puffk;
				int index = 0;
	
				for (int k = 0; k < z2; k++) {
					for (int j = 0; j < y2; j++) {
						for (int i = 0; i < x2; i++) {
							
							if (Main.ObservedImageData[index] != 0){
	
								observedObjectPnumber++;
								puffi = (i + offoX) * voX;
								puffj = (j + offoY) * voY;
								puffk = (k + offoZ) * voZ;
								
								if (puffi < minObservedX)
									minObservedX = puffi;
								
								if (puffj < minObservedY)
									minObservedY = puffj;
								
								if (puffk < minObservedZ)
									minObservedZ = puffk;
								
								
								if (puffi > maxObservedX)
									maxObservedX = puffi;
														
								if (puffj > maxObservedY)
									maxObservedY = puffj;
								
								if (puffk > maxObservedZ)
									maxObservedZ = puffk;
			
							}
							
							index++;
						}
					}
				}
				
				midOX = (maxObservedX + minObservedX) / 2.0;
				midOY = (maxObservedY + minObservedY) / 2.0;
				midOZ = (maxObservedZ + minObservedZ) / 2.0;
				
			} else {
				
				double pufferX, pufferY, pufferZ;
				double pufferX2, pufferY2, pufferZ2;
				
				int index = 0;
				
				for (int k = 0; k < z2; k++) {
					for (int j = 0; j < y2; j++) {
						for (int i = 0; i < x2; i++) {
							
							if (Main.ObservedImageData[index] != 0){
								
								pufferX = ((i + offoX) * voX - midOX) / scale;
								pufferY = ((j + offoY) * voY - midOY) / scale;
								pufferZ = ((k + offoZ) * voZ - midOZ) / scale;
								
								pufferX2 = pufferX * pufferX;
								pufferY2 = pufferY * pufferY;
								pufferZ2 = pufferZ * pufferZ;
								
								qx += pufferX;
								qx2 += pufferX2;
								qx3 += pufferX2 * pufferX;
								qx2qy += pufferX2 * pufferY;
								qx2qz += pufferX2 * pufferZ;
								
								qy += pufferY;
								qy2 += pufferY2;
								qy3 += pufferY2 * pufferY;
								qxqy2 += pufferX * pufferY2;
								qy2qz += pufferY2 * pufferZ;
								
								qxqy += pufferX * pufferY;
								
								qz += pufferZ;
								qz2 += pufferZ2;
								qz3 += pufferZ2 * pufferZ;
								qxqz += pufferX * pufferZ;
								qyqz += pufferY * pufferZ;
								qxqz2 += pufferX * pufferZ2;
								qyqz2 += pufferY * pufferZ2;
								
								qxqyqz += pufferX * pufferY * pufferZ;
											
							}
							
							index++;
						}
					}
				}
				
				ipx = iJacobi * qx;
				ipx2 = iJacobi * qx2;
				ipx3 = iJacobi * qx3;
				ipx2py = iJacobi * qx2qy;
				ipx2pz = iJacobi * qx2qz;
				ipy = iJacobi * qy;
				ipy2 = iJacobi * qy2;
				ipy3 = iJacobi * qy3;
				ipxpy2 = iJacobi * qxqy2;
				ipy2pz = iJacobi * qy2qz;
				ipxpy = iJacobi * qxqy;
				ipz = iJacobi * qz;
				ipz2 = iJacobi * qz2;
				ipz3 = iJacobi * qz3;
				ipxpz = iJacobi * qxqz;
				ipypz = iJacobi * qyqz;
				ipxpz2 = iJacobi * qxqz2;
				ipypz2 = iJacobi * qyqz2;
				ipxpypz = iJacobi * qxqyqz;
			}
			
		}
		
	}
	
	public Registration(){
		
		sourceObjectPnumber = 0;
		observedObjectPnumber = 0;	
		
		px = 0.0; py = 0.0; pz = 0.0;
		px2 = 0.0; pxpy = 0.0; pxpz = 0.0; py2 = 0.0; pypz = 0.0; pz2 = 0.0;
		pxpz2 = 0.0; pypz2 = 0.0; px2py = 0.0; py2pz = 0.0; px2pz = 0.0; pxpy2 = 0.0; pxpypz = 0.0; py3 = 0.0; px3 = 0.0; pz3 = 0.0;
		
		qx = 0.0; qy = 0.0; qz = 0.0; mu = 0.0;
		qx2 = 0.0; qxqy = 0.0; qxqz = 0.0; qy2 = 0.0; qyqz = 0.0; qz2 = 0.0;
		qxqz2 = 0.0; qyqz2 = 0.0; qx2qy = 0.0; qy2qz = 0.0; qx2qz = 0.0; qxqy2 = 0.0; qxqyqz = 0.0; qy3 = 0.0; qx3 = 0.0; qz3 = 0.0;
		
		minSourceX = minSourceY = minSourceZ = minObservedX = minObservedY = minObservedZ = Double.MAX_VALUE;
		maxSourceX = maxSourceY = maxSourceZ = maxObservedX = maxObservedY = maxObservedZ = Double.MIN_VALUE;
		
		x1 = Main.sourceImage.dimX;
		y1 = Main.sourceImage.dimY;
		z1 = Main.sourceImage.dimZ;
		vsX = Main.sVx;
		vsY = Main.sVy;
		vsZ = Main.sVz;
		offsX = Main.SourceOffset[0];
		offsY = Main.SourceOffset[1];
		offsZ = Main.SourceOffset[2];
		
		x2 = Main.generatedObservedX;
		y2 = Main.generatedObservedY;
		z2 = Main.generatedObservedZ;
		offoX = Main.ObservedOffset[0];
		offoY = Main.ObservedOffset[1];
		offoZ = Main.ObservedOffset[2];
		voX = Main.oVx;
		voY = Main.oVy;
		voZ = Main.oVz;
		
		Main.lblConsumedCpuTime.setText("Consumed CPU time:");
		Main.lblNewLabel_4.setText("Algebraic error:" );
		Main.lblGeometricError.setText("Delta error:");
		Main.lblNewLabel_3.setText("Number of iterations:");
		
		Main.textField_R11.setText("?");
		Main.textField_R12.setText("?");
		Main.textField_R13.setText("?");
		Main.textField_R14.setText("?");
		
		Main.textField_R21.setText("?");
		Main.textField_R22.setText("?");
		Main.textField_R23.setText("?");
		Main.textField_R24.setText("?");
		
		Main.textField_R31.setText("?");
		Main.textField_R32.setText("?");
		Main.textField_R33.setText("?");
		Main.textField_R34.setText("?");
		
		
		Main.frame.SetMainTitile(" - Performing registration...");
		
		long start = System.currentTimeMillis();
		Scale_CalculateMoments();		
		long end = System.currentTimeMillis();
		Main.frame.SetMainTitile(" - Performing registration... finished! (" + ((end-start)/1000.0) + " sec)");
		Main.lblConsumedCpuTime.setText("Consumed CPU time: " + (end-start)/1000.0 + " sec");
		
		if (Main.isTransformationKnown){
			long start2 = System.currentTimeMillis();
			EpsilonError();
			long end2 = System.currentTimeMillis();
			Main.epsilonErrorTime = (end2-start2)/1000.0f;
		}else
			Main.lblEpsilonError.setText("Epsilon error: The original transformation matrix is unknown" );
		
		GenerateResultImage g = new GenerateResultImage(Main.generatedObservedX, Main.generatedObservedY, Main.generatedObservedZ, finRes);
		g.GenerateImage();
		
		
		/*
		 * Stats
		 * */
		
		Main.lblSourceImageRead.setText("Source image read time: " + Main.sourceReadTime + " sec");
		Main.lblNewLabel_5.setText("Observed image read/generation time: " + Main.observedGenReadTime + " sec");
		Main.lblResultImageGeneration.setText("Result image generation time: " + Main.resultGenTime + " sec");
		Main.lblLmaOptimzerTime.setText("Levenberg \u2013 Marquardt optimzer time: " + Main.optimizerTime + " sec");
		Main.lblTotalRegistrationTime.setText("Total registration time: " + (end-start)/1000.0 + " sec");
		Main.lblConstructionTimeOf.setText("Construction time of the equations: " + Main.equtationsTime + " sec");
		Main.lblEpsilonErrorCalculation.setText("Epsilon error calculation time: " + Main.epsilonErrorTime + " sec");
		
	}
	
	public void EpsilonError(){

		double vx = Main.sVx;
		double vy = Main.sVy;
		double vz = Main.sVz;
		
		int x1 = Main.sourceImage.dimX;
		int y1 = Main.sourceImage.dimY;
		int z1 = Main.sourceImage.dimZ;
		int offsX = Main.SourceOffset[0];
		int offsY = Main.SourceOffset[1];
		int offsZ = Main.SourceOffset[2];
		
		Matrix T1 = Matrix.identity(4, 4);
		T1.set(0, 0, vx);
		T1.set(1, 1, vy);
		T1.set(2, 2, vz);
		
		Matrix diff = Main.TransformationFromProperties.minus(finRes);
		diff = diff.times(T1);
		double[][] Difference = diff.getArray();
	
		double t11x, t21x, t31x;
		double t12y, t22y, t32y;
		double t13z, t23z, t33z;
		double srcX, srcY, srcZ, puffer1, count = 0;

		double initT11x = offsX * Difference[0][0];
		double initT21x = offsX * Difference[1][0];
		double initT31x = offsX * Difference[2][0];
		
		double initT12y = offsY * Difference[0][1];
		double initT22y = offsY * Difference[1][1];
		double initT32y = offsY * Difference[2][1];
		
		// Millimter eltols vagy sem????????????????????????????????
		t13z = Difference[0][3] + offsZ * Difference[0][2];
		t23z = Difference[1][3] + offsZ * Difference[1][2];
		t33z = Difference[2][3] + offsZ * Difference[2][2];
		
		epsilon = 0;
		int index = 0;
		
		for (int k = 0; k < z1; k++) {
			t12y = initT12y; t22y = initT22y; t32y = initT32y;
			for (int j = 0; j < y1; j++) {
				t11x = initT11x; t21x = initT21x; t31x = initT31x;
				for (int i = 0; i < x1; i++) {
					
					if (Main.imageData[index] != 0){

						count++;
						
						srcX = t11x + t12y + t13z;
						srcY = t21x + t22y + t23z;
						srcZ = t31x + t32y + t33z;
						
						
						puffer1 = Math.sqrt(srcX*srcX + srcY*srcY + srcZ*srcZ);
						
						epsilon += puffer1;
												
						t11x += Difference[0][0]; t21x += Difference[1][0]; t31x += Difference[2][0];

					}
					
					index++;
					
				}
				t12y += Difference[0][1]; t22y += Difference[1][1]; t32y += Difference[2][1];
			}
			t13z += Difference[0][2]; t23z += Difference[1][2]; t33z += Difference[2][2];
		}
		
		epsilon = epsilon / count;
		
		Main.lblEpsilonError.setText("Epsilon error: " + (double)Math.round(epsilon*1000000.0)/1000000.0);
			
	}
	
	
	public void Scale_CalculateMoments(){
		
		long start3 = System.currentTimeMillis();
		
		SourceEq t1 = new SourceEq(0);
		Thread t11 = new Thread(t1);
		t11.start();
		
		ObservedEq t2 = new ObservedEq(0);
		Thread t22 = new Thread(t2);
		t22.start();
		
		try {
			t11.join();
			t22.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
				
		sx = Math.max((maxSourceX - minSourceX), ((maxObservedX - minObservedX)));
		sy = Math.max((maxSourceY - minSourceY), ((maxObservedY - minObservedY)));
		sz = Math.max((maxSourceZ - minSourceZ), ((maxObservedZ - minObservedZ)));
		
		scale = Math.max(Math.max(sx, sy), sz);
		
		if (Main.isJacobian == true){
			Jacobi = (observedObjectPnumber * voX * voY * voZ)/(sourceObjectPnumber * vsX * vsY * vsZ);
			iJacobi = 1.0 / Jacobi;
			Main.lblJacobian.setText("Jacobian: " + Math.round(Jacobi * 1000000.0)/1000000.0);
		} else {
			Jacobi = 1.0;
			iJacobi = 1.0;
			Main.lblJacobian.setText("Jacobian: " + Jacobi );
		}
				
		mu = observedObjectPnumber;
		imu = sourceObjectPnumber;
		
		SourceEq t3 = new SourceEq(1);
		Thread t33 = new Thread(t3);
		t33.start();
		
		ObservedEq t4 = new ObservedEq(1);
		Thread t44 = new Thread(t4);
		t44.start();
		
		try {
			t33.join();
			t44.join();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
				
		
		/*
		 * Forward equations
		 * */
		eq1_x_r = px;
		eq2_x_r = px2;
		eq3_x_r = px3;

		eq1_y_r = py;
		eq2_y_r = py2;
		eq3_y_r = py3;

		eq1_z_r = pz;
		eq2_z_r = pz2;
		eq3_z_r = pz3;		
		
		/*
		 * Inverz equations
		 * */
		ieq1_x_r = ipx;
		ieq2_x_r = ipx2;
		ieq3_x_r = ipx3;

		ieq1_y_r = ipy;
		ieq2_y_r = ipy2;
		ieq3_y_r = ipy3;

		ieq1_z_r = ipz;
		ieq2_z_r = ipz2;
		ieq3_z_r = ipz3;
		
		long end3 = System.currentTimeMillis();
		Main.equtationsTime = (end3-start3)/1000.0f;
		
		/*
		 * 27 orientations
		 * */
		
		long start4 = System.currentTimeMillis();
		
		Matrix rotX_mtx = Matrix.identity(4, 4);
		Matrix rotY_mtx = Matrix.identity(4, 4);
		Matrix rotZ_mtx = Matrix.identity(4, 4);
		Matrix rot_mtx = Matrix.identity(4, 4);
		
		LMfunc f = new MyFunction();
		
		double[] a = new double[12];
		double[] x = new double[12];

		double[] a2 = new double[6];
		double[] x2 = new double[6];
	
		double[] y = {eq1_x_r, eq2_x_r, eq3_x_r, eq1_y_r, eq2_y_r, eq3_y_r, eq1_z_r, eq2_z_r, eq3_z_r,
				  pxpy, pxpz, pypz, px2py, px2pz, py2pz, pxpy2, pxpz2, pypz2, pxpypz,
				  ieq1_x_r, ieq2_x_r, ieq3_x_r, ieq1_y_r, ieq2_y_r, ieq3_y_r, ieq1_z_r,
				  ieq2_z_r, ieq3_z_r, ipxpy, ipxpz, ipypz, ipx2py, ipx2pz, ipy2pz, ipxpy2,
				  ipxpz2, ipypz2, ipxpypz};
		
		
		double rotdiv = 3;
		
		if (Main.choiceIndex == 0){
			rotdiv = 1;
		} else if(Main.choiceIndex == 1){
			rotdiv = 2;
		} else if(Main.choiceIndex == 2){
			rotdiv = 3;
		} else if(Main.choiceIndex == 3){
			rotdiv = 4;
		} else if(Main.choiceIndex == 4){
			rotdiv = 5;
		}
		
		int iterCount = 0, ori = 0;
		double rotstep = 2.0 * Math.PI / rotdiv;
		double rotZ, rotY, rotX;
		double fvalcurrent = 0.0;
		double fvalcurrentlimit = Main.fvalLimit;
		int iterlimit = Main.IterationLimit;
		fvalmin = Double.MAX_VALUE;
		

		if (Main.isRigid == false){
			
			rotZ = 0.0;
			for (int k = 0; k < rotdiv; k++) {
				
				rotY = 0.0;
				rotZ_mtx = Matrix.identity(4, 4);
				rotZ_mtx.set(0, 0, Math.cos(rotZ));
				rotZ_mtx.set(0, 1, -Math.sin(rotZ));
				rotZ_mtx.set(1, 0, Math.sin(rotZ));
				rotZ_mtx.set(1, 1, Math.cos(rotZ));
	
				for (int j = 0; j < rotdiv; j++) {
					
					rotX = 0.0;
					rotY_mtx = Matrix.identity(4, 4);
					rotY_mtx.set(0, 0, Math.cos(rotY));
					rotY_mtx.set(0, 2, Math.sin(rotY));
					rotY_mtx.set(2, 0, -Math.sin(rotY));
					rotY_mtx.set(2, 2, Math.cos(rotY));
					
					for (int i = 0; i < rotdiv; i++) {
						
						ori++;
						
						rotX_mtx = Matrix.identity(4, 4);		
						rotX_mtx.set(1, 1, Math.cos(rotX));
						rotX_mtx.set(1, 2, -Math.sin(rotX));
						rotX_mtx.set(2, 1, Math.sin(rotX));
						rotX_mtx.set(2, 2, Math.cos(rotX));
						
						rot_mtx = rotZ_mtx.times(rotY_mtx).times(rotX_mtx);
						
						a[0] = rot_mtx.get(0, 0);
						a[1] = rot_mtx.get(0, 1);
						a[2] = rot_mtx.get(0, 2);
						a[3] = rot_mtx.get(0, 3);
						
						a[4] = rot_mtx.get(1, 0);
						a[5] = rot_mtx.get(1, 1);
						a[6] = rot_mtx.get(1, 2);
						a[7] = rot_mtx.get(1, 3);
						
						a[8] = rot_mtx.get(2, 0);
						a[9] = rot_mtx.get(2, 1);
						a[10] = rot_mtx.get(2, 2);
						a[11] = rot_mtx.get(2, 3);
	
						try {
							LM.solve( a, y, f, 0.01, 0.001, iterlimit);
						}
						catch(Exception ex) {
						    System.err.println("Exception caught:" + ex.getMessage());
						    System.exit(1); 
						}
						
						iterCount += LM.iter;
						
						fvalcurrent = LM.e0;
						
						if (fvalcurrent < fvalmin){
							fvalmin = fvalcurrent;
							System.arraycopy(a, 0, x, 0, 12);
						}
						
						if (fvalcurrent < fvalcurrentlimit){
							break;
						}
						rotX = rotX + rotstep;
					}
					if (fvalcurrent < fvalcurrentlimit){
						break;
					}
					rotY = rotY + rotstep;
				}
				if (fvalcurrent < fvalcurrentlimit){
					break;
				}
				rotZ = rotZ + rotstep;
			}
			
			Main.lblNumberOfScanned.setText("Number of scanned orientations: " + ori);
			mainIterCount = 0;
	
			try {
				LM.solve( x, y, f, 0.01, 0.0001, 300);
			}
			catch(Exception ex) {
			    System.err.println("Exception caught: " + ex.getMessage());
			    System.exit(1); 
			}
			
			long end4 = System.currentTimeMillis();
			Main.optimizerTime = (end4-start4)/1000.0f;
			
			mainIterCount = LM.iter;
			totalIter = mainIterCount + iterCount;
			

			Main.lblNewLabel_3.setText("Number of iterations: " + totalIter + "  (" + iterCount + " pre-optimizer + " + mainIterCount + " main optimizer)");
						
			res[0][0] = x[0];
			res[0][1] = x[1];
			res[0][2] = x[2];
			res[0][3] = x[3];
			
			res[1][0] = x[4];
			res[1][1] = x[5];
			res[1][2] = x[6];
			res[1][3] = x[7];
			
			res[2][0] = x[8];
			res[2][1] = x[9];
			res[2][2] = x[10];
			res[2][3] = x[11];
			
			res[3][0] = 0.0;
			res[3][1] = 0.0;
			res[3][2] = 0.0;
			res[3][3] = 1.0;
		
		} else {
			
			rotZ = 0.0;
			for (int k = 0; k < rotdiv; k++) {
				rotY = 0.0;
				for (int j = 0; j < rotdiv; j++) {
					rotX = 0.0;
					for (int i = 0; i < rotdiv; i++) {
										
						ori++;
						
						a2[0] = rotZ;
						a2[1] = rotY;
						a2[2] = rotX;
						a2[3] = 0.0;
						a2[4] = 0.0;
						a2[5] = 0.0;

						try {
							LM.solve( a2, y, f, 0.01, 0.001, iterlimit);
						}
						catch(Exception ex) {
						    System.err.println("Exception caught:" + ex.getMessage());
						    System.exit(1); 
						}
						
						iterCount += LM.iter;
						fvalcurrent = LM.e0;
						
						if (fvalcurrent < fvalmin){
							fvalmin = fvalcurrent;
							System.arraycopy(a2, 0, x2, 0, 6);
						}
						
						if (fvalcurrent < fvalcurrentlimit){
							break;
						}
						rotX = rotX + rotstep;
					}
					if (fvalcurrent < fvalcurrentlimit){
						break;
					}
					rotY = rotY + rotstep;
				}
				if (fvalcurrent < fvalcurrentlimit){
					break;
				}
				rotZ = rotZ + rotstep;
			}
			
			Main.lblNumberOfScanned.setText("Number of scanned orientations: " + ori);
			
			mainIterCount = 0;
	
			try {
				LM.solve( x2, y, f, 0.01, 0.0001, 300);
			}
			catch(Exception ex) {
			    System.err.println("Exception caught: " + ex.getMessage());
			    System.exit(1); 
			}
			
			long end4 = System.currentTimeMillis();
			Main.optimizerTime = (end4-start4)/1000.0f;
			
			mainIterCount = LM.iter;
			totalIter = mainIterCount + iterCount;
			

			Main.lblNewLabel_3.setText("Number of iterations:" + totalIter + "  (" + iterCount + " + " + mainIterCount + ")");
									
			cx1 = Math.cos(x2[0]);
			cx2 = Math.cos(x2[1]);
			cx3 = Math.cos(x2[2]);
			
			sx1 = Math.sin(x2[0]);
			sx2 = Math.sin(x2[1]);
			sx3 = Math.sin(x2[2]);
			
			res[0][0] = cx1 * cx2;
			res[0][1] = -sx1 * cx3 + cx1 * sx2 * sx3;
			res[0][2] = sx1 * sx3 + cx1 * sx2 * cx3;
			res[0][3] = x2[3];
			
			res[1][0] = sx1 * cx2;
			res[1][1] = cx1 * cx3 + sx1 * sx2 * sx3;
			res[1][2] = -cx1 * sx3 + sx1 * sx2 * cx3;
			res[1][3] = x2[4];
			
			res[2][0] = -sx2;
			res[2][1] = cx2 * sx3;
			res[2][2] = cx2 * cx3;
			res[2][3] = x2[5];
			
			res[3][0] = 0.0;
			res[3][1] = 0.0;
			res[3][2] = 0.0;
			res[3][3] = 1.0;
			
		}
		
		Matrix inversResult = new Matrix(res);
		
		Matrix T0 = Matrix.identity(4, 4);
		T0.set(0, 0, voX);
		T0.set(1, 1, voY);
		T0.set(2, 2, voZ);
		
		Matrix T1 = Matrix.identity(4, 4);
		T1.set(0, 0, 1.0 / scale);
		T1.set(1, 1, 1.0 / scale);
		T1.set(2, 2, 1.0 / scale);
		T1.set(0, 3, -( midOX / scale ));
		T1.set(1, 3, -( midOY / scale ));
		T1.set(2, 3, -( midOZ / scale ));
		
		Matrix T2 = Matrix.identity(4, 4);
		T2.set(0, 0, scale);
		T2.set(1, 1, scale);
		T2.set(2, 2, scale);
		T2.set(0, 3, midSX);
		T2.set(1, 3, midSY);
		T2.set(2, 3, midSZ);
		
		Matrix T3 = Matrix.identity(4, 4);
		T3.set(0, 0, 1.0 / vsX);
		T3.set(1, 1, 1.0 / vsY);
		T3.set(2, 2, 1.0 / vsZ);
		
		T1 = T1.times(T0);
		T2 = T3.times(T2);


		Matrix Result = T2.times(inversResult).times(T1);
		
		fvalmin = LM.e0;
		Main.lblNewLabel_4.setText("Algebraic error: " + (double)Math.round(fvalmin*1000000.0)/1000000.0);
		
		finRes = Result.inverse();

		finRes.set(0, 3, finRes.get(0, 3) * vsX);
		finRes.set(1, 3, finRes.get(1, 3) * vsY);
		finRes.set(2, 3, finRes.get(2, 3) * vsZ);
		
		finRes.set(0, 1, finRes.get(0, 1) * vsX / vsY);
		finRes.set(0, 2, finRes.get(0, 2) * vsX / vsZ);
		finRes.set(1, 0, finRes.get(1, 0) * vsY / vsX);
		finRes.set(1, 2, finRes.get(1, 2) * vsY / vsZ);
		finRes.set(2, 0, finRes.get(2, 0) * vsZ / vsX);
		finRes.set(2, 1, finRes.get(2, 1) * vsZ / vsY);
		
		//finRes = Main.TransformationFromProperties;
		
		Main.resultMatrix = finRes.getArrayCopy();
	
		Main.textField_R11.setText(Double.toString((double)Math.round(finRes.get(0, 0) * 10000.0)/10000.0));
		Main.textField_R12.setText(Double.toString((double)Math.round(finRes.get(0, 1) * 10000.0)/10000.0));
		Main.textField_R13.setText(Double.toString((double)Math.round(finRes.get(0, 2) * 10000.0)/10000.0));
		Main.textField_R14.setText(Double.toString((double)Math.round(finRes.get(0, 3) * 10000.0)/10000.0));
		
		Main.textField_R21.setText(Double.toString((double)Math.round(finRes.get(1, 0) * 10000.0)/10000.0));
		Main.textField_R22.setText(Double.toString((double)Math.round(finRes.get(1, 1) * 10000.0)/10000.0));
		Main.textField_R23.setText(Double.toString((double)Math.round(finRes.get(1, 2) * 10000.0)/10000.0));
		Main.textField_R24.setText(Double.toString((double)Math.round(finRes.get(1, 3) * 10000.0)/10000.0));
		
		Main.textField_R31.setText(Double.toString((double)Math.round(finRes.get(2, 0) * 10000.0)/10000.0));
		Main.textField_R32.setText(Double.toString((double)Math.round(finRes.get(2, 1) * 10000.0)/10000.0));
		Main.textField_R33.setText(Double.toString((double)Math.round(finRes.get(2, 2) * 10000.0)/10000.0));
		Main.textField_R34.setText(Double.toString((double)Math.round(finRes.get(2, 3) * 10000.0)/10000.0));
				
	}
}
