package show2D;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import main.Main;

public class ResultImageFrame extends JFrame implements ChangeListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	public static JPanel contentPane;
	public static int sliderValue = 0;
	public static ImageIcon icon;
	public static JScrollPane scrollPane;
	public static boolean first;
	public int x, y, z;
	
	private BufferedImage image;

		
	public void DisplayObservedImage(){
		
		int z = sliderValue - 1;
		int a = x*y;
		 
		if (Main.coloured){
			 for (int i = 0; i < x; i++) {
					for (int j = 0; j < y; j++) {
						if (Main.XorImage[z*a + (y - j - 1)*x + i] == 0)
							image.setRGB(i, j,  0xffffff);
						else if (Main.XorImage[z*a + (y - j - 1)*x + i] == 5)
							image.setRGB(i, j,  0xff0000);
						else if (Main.XorImage[z*a + (y - j - 1)*x + i] == 10)
							image.setRGB(i, j,  0x00ff00);
						else if (Main.XorImage[z*a + (y - j - 1)*x + i] == 15)
							image.setRGB(i, j,  0xffff00);
						
						
					}
				}
		} else if (Main.Xor){
			for (int i = 0; i < x; i++) {
				for (int j = 0; j < y; j++) {
					if (Main.XorImage[z*a + (y - j - 1)*x + i] == 0 || Main.XorImage[z*a + (y - j - 1)*x + i] == 15)
						image.setRGB(i, j,  0x000000);
					else
						image.setRGB(i, j,  0xffffff);
					
					
				}
			}			
		} else if (Main.registered){
				for (int i = 0; i < x; i++) {
					for (int j = 0; j < y; j++) {
						if (Main.XorImage[z*a + (y - j - 1)*x + i] == 0 || Main.XorImage[z*a + (y - j - 1)*x + i] == 10)
							image.setRGB(i, j,  0x000000);
						else
							image.setRGB(i, j,  0xffffff);
						
						
					}
				}			
			}
		icon = new ImageIcon(image);
		first = false;
		DrawComponents();
	}
	
	

	/**
	 * Create the frame.
	 */
	public ResultImageFrame(int x, int y, int z) {
		
		this.x = x;
		this.y = y;
		this.z = z;
		
		image = new BufferedImage(x, y, BufferedImage.TYPE_3BYTE_BGR);

		
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					DrawWindow();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		
	}
	
	public void DrawWindow(){
		
		setVisible(true);
		
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosed(WindowEvent arg0) {
				Main.rdbtnColoured.setEnabled(false);
				Main.rdbtnRegistrationResult.setEnabled(false);
				Main.rdbtnXorResult.setEnabled(false);
				Main.chckbxShowBothIn.setEnabled(false);
				Main.btnStartRegistration.setEnabled(true);
				Main.btnSaveRegisteredImage.setEnabled(false);
				Main.chckbxShowResultImage.setEnabled(false);
				Main.btnSaveOriginalImage.setEnabled(false);
			}
			@Override
			public void windowOpened(WindowEvent e) {
				Main.rdbtnColoured.setEnabled(true);
				Main.rdbtnRegistrationResult.setEnabled(true);
				Main.rdbtnXorResult.setEnabled(true);
				Main.btnStartRegistration.setEnabled(false);
				Main.chckbxShowBothIn.setEnabled(true);
				Main.btnSaveRegisteredImage.setEnabled(true);
				Main.chckbxShowResultImage.setEnabled(true);
				Main.btnSaveOriginalImage.setEnabled(true);
			}
		});
		sliderValue = Math.round(z/2);
		


		SetWindowTitle("Result - " + sliderValue + "/" + z + " slice" + " - " +  
				 x+ "x" + y + "x" + z + " - R:Registered, G:Source, Y:Overlapping");

		
		first = true;
		
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setBounds(140, 150, x + 50, y + 100);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		
		JSlider slider = new JSlider(JSlider.HORIZONTAL,1, z, sliderValue);
		slider.setSnapToTicks(true);
		
		if (z< 150){
			slider.setMajorTickSpacing(20);
			slider.setMinorTickSpacing(1);
		} else if(z < 300){
			slider.setMajorTickSpacing(40);
			slider.setMinorTickSpacing(1);
		} else {
			slider.setMajorTickSpacing(60);
			slider.setMinorTickSpacing(1);
		}
		slider.setPaintTicks(false);
		slider.setPaintLabels(true);
		
		slider.addChangeListener(this);

		contentPane.add(slider, BorderLayout.SOUTH);
		
		DrawComponents();
		contentPane.setEnabled(true);
	}
	
	public void DrawComponents(){
	
		if (first){
			scrollPane = new JScrollPane();
			contentPane.add(scrollPane, BorderLayout.CENTER);

			DisplayObservedImage();

		}
		contentPane.setVisible(false);
		contentPane.remove(scrollPane);
		JLabel label = new JLabel(icon);
		label.setBackground(Color.WHITE);
		scrollPane = new JScrollPane(label);
		contentPane.add(scrollPane, BorderLayout.CENTER);
		contentPane.setVisible(true);
		
	}
	
	public void SetWindowTitle(String s){
		
		setTitle(s);
	}

	@Override
	public void stateChanged(ChangeEvent arg0) {
		JSlider source = (JSlider)arg0.getSource();
		
		sliderValue = source.getValue();
		
		DisplayObservedImage();
		
		SetWindowTitle("Result - " + sliderValue + "/" + z + " slice" + " - " +  
				 x+ "x" + y + "x" + z + " - R:Registered, G:Source, Y:Overlapping");
	}
}
