package show2D;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import main.Main;


public class SourceImageFrame extends JFrame implements ChangeListener{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JPanel contentPane;
	private int sliderValue = 0;
	private BufferedImage image;
	private ImageIcon icon;
	private JScrollPane scrollPane;
	private boolean first;
	public int x, y, z, bitpix, size;

	
	public void DisplayImage(){
		
		int z = sliderValue - 1;
		int a = x*y;
		
		for (int i = 0; i < x; i++) {
			for (int j = 0; j < y; j++) {
				if (Main.imageData[z*a + (y - j - 1)*x + i] == 0)
					image.setRGB(i, j,  0x000000);
				else{
					image.setRGB(i, j,  0xffffff);
				}
				
			}
		}
		
		icon = new ImageIcon(image);
		first = false;
		DrawComponents();
	}
	
	
	/**
	 * Create the frame.
	 */
	public SourceImageFrame(int x, int y, int z, int bitpx, int size) {
		
		this.x = x;
		this.y = y;
		this.z = z;
		this.size = size;
		this.bitpix = bitpx;
		
		image = new BufferedImage(x, y, BufferedImage.TYPE_3BYTE_BGR);
		
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					DrawWindow();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
		
	}
	
	
	public void DrawWindow(){
		
		setVisible(true);

		
		addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosed(WindowEvent arg0) {
				Main.btnOpen.setEnabled(true);
				Main.allReady--;
				if (Main.allReady3D != 2){
					Main.btnStartRegistration.setEnabled(false);
				}
				Main.BothReady--;
				if (Main.BothReady != 2){
					Main.chckbxShowSourceAnd.setEnabled(false);
				}
				Main.chckbxNewCheckBox.setEnabled(false);
			}
			@Override
			public void windowOpened(WindowEvent e) {
				Main.chckbxNewCheckBox.setEnabled(true);
				Main.btnOpen.setEnabled(false);
				Main.allReady++;
				if (Main.allReady == 2){
					Main.btnStartRegistration.setEnabled(true);
				}
				Main.BothReady++;
				if (Main.BothReady == 2){
					Main.chckbxShowSourceAnd.setEnabled(true);
				}
			}
		});
		
		sliderValue = Math.round(z/2);
		
			SetWindowTitle("Source - " + sliderValue + "/" + z + " slice" + " - " +  
					 x+ "x" + y + "x" + z + " - " + bitpix + "bitpix - " + (double)Math.round((size/(1024.0*1024.0)) * 100.0)/100.0 + "MB - offset: (" + Main.SourceOffset[0] +  ","+Main.SourceOffset[1] +  ","+
					 Main.SourceOffset[2] +  ")");
	
		
		first = true;
		
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		setBounds(100, 50, x + 50, y + 100);
		contentPane = new JPanel();
		contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
		contentPane.setLayout(new BorderLayout(0, 0));
		setContentPane(contentPane);
		
		JSlider slider = new JSlider(JSlider.HORIZONTAL,1, z, sliderValue);
		slider.setSnapToTicks(true);
		
		if (z< 150){
			slider.setMajorTickSpacing(20);
			slider.setMinorTickSpacing(1);
		} else if(z < 300){
			slider.setMajorTickSpacing(40);
			slider.setMinorTickSpacing(1);
		} else {
			slider.setMajorTickSpacing(60);
			slider.setMinorTickSpacing(1);
		}
		slider.setPaintTicks(false);
		slider.setPaintLabels(true);
		
		slider.addChangeListener(this);

		contentPane.add(slider, BorderLayout.SOUTH);
		
		DrawComponents();
		contentPane.setEnabled(true);
	}
	
	public void SetWindowTitle(String s){
		
		setTitle(s);
	}
	
	public void DrawComponents(){
	
		if (first){
			scrollPane = new JScrollPane();
			contentPane.add(scrollPane, BorderLayout.CENTER);
			DisplayImage();
			return;
		}
		contentPane.setVisible(false);
		contentPane.remove(scrollPane);
		JLabel label = new JLabel(icon);
		label.setBackground(Color.WHITE);
		scrollPane = new JScrollPane(label);
		contentPane.add(scrollPane, BorderLayout.CENTER);
		contentPane.setVisible(true);
		
	}

	@Override
	public void stateChanged(ChangeEvent arg0) {
		JSlider source = (JSlider)arg0.getSource();
		
		sliderValue = source.getValue();
		DisplayImage();
		
		SetWindowTitle("Source - " + sliderValue + "/" + z + " slice" + " - " +  
				 x+ "x" + y + "x" + z + " - " + bitpix + "bitpix - " + (double)Math.round((size/(1024.0*1024.0)) * 100.0)/100.0 + "MB - offset: (" + Main.SourceOffset[0] +  ","+Main.SourceOffset[1] +  ","+
				 Main.SourceOffset[2] +  ")");
	}

}
