package show3D;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

import main.Main;

import com.jogamp.opengl.util.FPSAnimator;
import com.jogamp.opengl.util.gl2.GLUT;

public class RenderSourceAndObserved3D implements GLEventListener, MouseListener, MouseMotionListener, WindowListener, MouseWheelListener{

	private static JFrame frame;
    private static GLCanvas glCanvas;
    private static FPSAnimator animator;
    private GLUT glut = new GLUT();
    int dimX1 = Main.sourceImage.dimX;
	int dimY1 = Main.sourceImage.dimY;
	int dimZ1 = Main.sourceImage.dimZ;
	
	int dimX2 = Main.generatedObservedX;
	int dimY2 = Main.generatedObservedY;
	int dimZ2 = Main.generatedObservedZ;
	float vsX = Main.sVx;
	float vsY = Main.sVy;
	float vsZ = Main.sVz;
	float vsX2 = Main.oVx;
	float vsY2 = Main.oVy;
	float vsZ2 = Main.oVz;
	float distance = 1000.0f;
	private GLU glu = new GLU();
	private int Myobject;
	private int Myobject2;
	float angleX = 0.0f;
	float angleY = 0.0f;
	int xPrev = 1,yPrev = 1;
	int x = 1,y = 1;
	float sox, soy, soz;
	float oox, ooy, ooz;
	
	int index;
	
	public RenderSourceAndObserved3D(){

		GLProfile profile = GLProfile.get(GLProfile.GL2);
    	GLCapabilities capabilities = new GLCapabilities(profile);
		
		glCanvas = new GLCanvas(capabilities);
        glCanvas.setSize( 700, 500 );
        glCanvas.setIgnoreRepaint( true );
        glCanvas.addGLEventListener(this);
        glCanvas.addMouseListener(this);
        glCanvas.addMouseMotionListener(this);
        glCanvas.addMouseWheelListener(this);

        frame = new JFrame( "Source and Observed image 3D - white: observed, transparent red: source" );
        frame.addWindowListener(this);
        frame.getContentPane().setLayout( new BorderLayout() );
        frame.getContentPane().add( glCanvas, BorderLayout.CENTER );

        animator = new FPSAnimator( glCanvas, 60 );
  
        frame.setBounds(90, 300, 800, 600);
        frame.setVisible( true );
	}
	
	public void start(){
		
		sox = (float)Main.SourceOffset[0] * vsX;
		soy = (float)Main.SourceOffset[1] * vsY;
		soz = (float)Main.SourceOffset[2] * vsZ;
		
		oox = (float)Main.ObservedOffset[0] * vsX2;
		ooy = (float)Main.ObservedOffset[1] * vsY2;
		ooz = (float)Main.ObservedOffset[2] * vsZ2;
		
		animator.start();
	}
	 
    public void display(GLAutoDrawable gLDrawable) 
    {
    	final GL2 gl = gLDrawable.getGL().getGL2();
    	
        gl.glClear(GL2.GL_COLOR_BUFFER_BIT | GL2.GL_DEPTH_BUFFER_BIT);

        gl.glLoadIdentity();
  
        setCamera(gl, glu, distance);    
        gl.glRotatef(angleX, 1.0f, 0.0f, 0.0f);
        gl.glRotatef(angleY, 0.0f, 1.0f, 0.0f);
        
        DrawCooSystem(gl);
                
        gl.glCallList(Myobject2);
        gl.glCallList(Myobject);

        gl.glLoadIdentity();
        gl.glFlush();
       
    }
    
    private void setCamera(GL2 gl, GLU glu, float distance) {
        // Change to projection matrix.
        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glLoadIdentity();

        // Perspective.
        float widthHeightRatio = (float) glCanvas.getSize().width / (float) glCanvas.getSize().height;
        glu.gluPerspective(60, widthHeightRatio, 1, 10000);
        glu.gluLookAt(0, 0, distance, 0, 0, 0, 0, 1, 0);

        // Change back to model view matrix.
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glLoadIdentity();
    }
    
    public void DrawObject(GL2 gl){
    	
        int slice = dimY1* dimX1;
    	float x,y,z;
    	int count = 0;
    	float wC = 0;
    	
    	gl.glEnable(GL2.GL_BLEND);
        gl.glBlendFunc(GL2.GL_SRC_ALPHA, GL2.GL_ONE_MINUS_SRC_ALPHA); 
        gl.glDepthMask(false);
    	
    	float[] rgba = {1.0f, 0.0f, 0.0f, 0.05f};
        gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, rgba, 0);
        gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_SPECULAR, rgba, 0);
        gl.glMaterialf(GL2.GL_FRONT_AND_BACK, GL2.GL_SHININESS, 60f);
    	
    	z = soz;
    	for (int k = 0; k < dimZ1; k++) {
    		y = soy;
			for (int j = 0; j < dimY1; j++) {
				x = sox;
				for (int i = 0; i < dimX1; i++) {
					
					index = k * slice + j * dimX1 + i;
					
					if (Main.imageData[index] != 0){
														
						wC++;
						
						
							while (Main.imageData[index + (int)wC] != 0) {
								 wC++;	
								 
								 if (i + wC >= dimX1)
									 break;
							}
						
						
			
						float x1 = x + ((wC + 1) * vsX)/2.0f;
						
						DrawCube(gl, x1,y,z, wC * vsX);
						count++;
						i += wC;
			          
					}
					x += (wC + 1) * vsX;
					wC = 0.0f;
				}
				y += vsY;
			}
			z += vsZ;
		}
    	gl.glDepthMask(true);
        gl.glDisable(GL2.GL_BLEND);
    }
    
public void DrawObject2(GL2 gl){
    	
        int slice = dimY2* dimX2;
    	float x,y,z;
    	int count = 0;
    	float wC = 0;
    	
    	float[] rgba = {1.0f, 1.0f, 1.0f, 1.0f};
        gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_DIFFUSE, rgba, 0);
        gl.glMaterialfv(GL2.GL_FRONT_AND_BACK, GL2.GL_SPECULAR, rgba, 0);
        gl.glMaterialf(GL2.GL_FRONT_AND_BACK, GL2.GL_SHININESS, 60f);
    	
    	z = ooz;
    	for (int k = 0; k < dimZ2; k++) {
    		y = ooy;
			for (int j = 0; j < dimY2; j++) {
				x = oox;
				for (int i = 0; i < dimX2; i++) {
					
					index = k * slice + j * dimX2 + i;
					
					if (Main.ObservedImageData[index] != 0){
														
						wC++;
						
						
							while (Main.ObservedImageData[index + (int)wC] != 0) {
								 wC++;	
								 
								 if (i + wC >= dimX2)
									 break;
							}
						
						
			
						float x1 = x + ((wC + 1) * vsX2)/2.0f;
						
						DrawCube(gl, x1,y,z, wC * vsX2);
						count++;
						i += wC;
			          
					}
					x += (wC + 1) * vsX2;
					wC = 0.0f;
				}
				y += vsY2;
			}
			z += vsZ2;
		}
    }

public void DrawCooSystem(GL2 gl){
	
	gl.glDisable(GL2.GL_LIGHTING);
	
	gl.glColor3f(1.0f, 0.0f, 0.0f);
	gl.glRasterPos3f(500.0f, 0.0f, 0.0f);
	glut.glutBitmapString(GLUT.BITMAP_HELVETICA_18, "X");
	
	gl.glColor3f(0.0f, 1.0f, 0.0f);
	gl.glRasterPos3f(0.0f, 500.0f, 0.0f);
	glut.glutBitmapString(GLUT.BITMAP_HELVETICA_18, "Y");
	
	gl.glColor3f(0.0f, 0.0f, 1.0f);
	gl.glRasterPos3f(0.0f, 0.0f, 500.0f);
	glut.glutBitmapString(GLUT.BITMAP_HELVETICA_18, "Z");
	
	gl.glBegin(GL2.GL_LINES);
	
	gl.glColor3f(1.0f, 0.0f, 0.0f);
	gl.glVertex3f(-550.0f, 0.0f, 0.0f);
	gl.glVertex3f(550.0f, 0.0f, 0.0f);
	
	gl.glColor3f(0.0f, 1.0f, 0.0f);
	gl.glVertex3f(0.0f, -550.0f, 0.0f);
	gl.glVertex3f(0.0f, 550.0f, 0.0f);
	
	gl.glColor3f(0.0f, 0.0f, 1.0f);
	gl.glVertex3f(0.0f, 0.0f, -550.0f);
	gl.glVertex3f(0.0f, 0.0f, 550.0f);
	
	gl.glEnd(); 
	gl.glEnable(GL2.GL_LIGHTING);
	
}
    
    public void DrawCube(GL2 gl, float x, float y, float z, float dX){
    	
    	float dY = vsY / 2.0f;
    	float dZ = vsZ / 2.0f;
    	dX = dX / 2.0f;
    	
    	gl.glBegin(GL2.GL_QUADS);            // Draw A Quad
    	gl.glNormal3f(0.0f, 1.0f, 0.0f);
        gl.glVertex3f(x + dX, y + dY, z - dZ);   // Top Right Of The Quad (Top)
        gl.glVertex3f(x - dX, y + dY, z - dZ);  // Top Left Of The Quad (Top)
        gl.glVertex3f(x - dX, y + dY, z + dZ);   // Bottom Left Of The Quad (Top)
        gl.glVertex3f(x + dX, y + dY, z + dZ);    // Bottom Right Of The Quad (Top)

        gl.glNormal3f(0.0f, -1.0f, 0.0f);
        gl.glVertex3f(x + dX, y - dY, z + dZ);   // Top Right Of The Quad (Bottom)
        gl.glVertex3f(x - dX, y - dY, z + dZ);  // Top Left Of The Quad (Bottom)
        gl.glVertex3f(x - dX, y - dY, z - dZ); // Bottom Left Of The Quad (Bottom)
        gl.glVertex3f(x + dX, y - dY, z - dZ);  // Bottom Right Of The Quad (Bottom)

        gl.glNormal3f(0.0f, 0.0f, 1.0f);
        gl.glVertex3f(x + dX, y + dY, z + dZ);    // Top Right Of The Quad (Front)
        gl.glVertex3f(x - dX, y + dY, z + dZ);   // Top Left Of The Quad (Front)
        gl.glVertex3f(x - dX, y - dY, z + dZ);  // Bottom Left Of The Quad (Front)
        gl.glVertex3f(x + dX, y - dY, z + dZ);   // Bottom Right Of The Quad (Front)

        gl.glNormal3f(0.0f, 0.0f, -1.0f);
        gl.glVertex3f(x + dX, y - dY, z - dZ);  // Bottom Left Of The Quad (Back)
        gl.glVertex3f(x - dX, y - dY, z - dZ); // Bottom Right Of The Quad (Back)
        gl.glVertex3f(x - dX, y + dY, z - dZ);  // Top Right Of The Quad (Back)
        gl.glVertex3f(x + dX, y + dY, z - dZ);   // Top Left Of The Quad (Back)

        gl.glNormal3f(-1.0f, 0.0f, 0.0f);
        gl.glVertex3f(x - dX, y + dY, z + dZ);   // Top Right Of The Quad (Left)
        gl.glVertex3f(x - dX, y + dY, z - dZ);  // Top Left Of The Quad (Left)
        gl.glVertex3f(x - dX, y - dY, z - dZ); // Bottom Left Of The Quad (Left)
        gl.glVertex3f(x - dX, y - dY, z + dZ);  // Bottom Right Of The Quad (Left)

        gl.glNormal3f(1.0f, 0.0f, 0.0f);
        gl.glVertex3f(x + dX, y + dY, z - dZ);   // Top Right Of The Quad (Right)
        gl.glVertex3f(x + dX, y + dY, z + dZ);    // Top Left Of The Quad (Right)
        gl.glVertex3f(x + dX, y - dY, z + dZ);   // Bottom Left Of The Quad (Right)
        gl.glVertex3f(x + dX, y - dY, z - dZ);  // Bottom Right Of The Quad (Right)
        gl.glEnd();   
    }

 
    public void init(GLAutoDrawable gLDrawable) 
    {
    
        GL2 gl = gLDrawable.getGL().getGL2();
        
       
        Myobject = gl.glGenLists(1);
        gl.glNewList(Myobject, GL2.GL_COMPILE);
        DrawObject(gl);
        gl.glEndList();
        if (gl.glGetError() == 1285){
        	JOptionPane.showMessageDialog((Component)null,
				    "There is not enough memory to generate the 3D image!\n" +
				    "Please try to allocate more heap space." +
				    "The program will now exit!",
				    "Error!",
				    JOptionPane.ERROR_MESSAGE);

        
    		System.exit(0);
	
        }
        
        Myobject2 = gl.glGenLists(1);
        gl.glNewList(Myobject2, GL2.GL_COMPILE);
        DrawObject2(gl);
        gl.glEndList();
        if (gl.glGetError() == 1285){
        	JOptionPane.showMessageDialog((Component)null,
				    "There is not enough memory to generate the 3D image!\n" +
				    "Please try to allocate more heap space." +
				    "The program will now exit!",
				    "Error!",
				    JOptionPane.ERROR_MESSAGE);

        
    		System.exit(0);
	
        }

        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);      
        gl.glShadeModel(GL2.GL_SMOOTH);              // Enable Smooth Shading
        gl.glCullFace(GL2.GL_BACK);
        gl.glEnable(GL2.GL_CULL_FACE);
       
        float[] lightPos = {-300, 400, 250, 1.0f};
        float[] lightColorDiff = {0.9f, 0.8f, 0.7f, 1f};
        float[] lightColorSpecular = {0.9f, 0.9f, 0.9f, 1f};

        gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_POSITION, lightPos, 0);
        gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_DIFFUSE, lightColorDiff, 0);
        gl.glLightfv(GL2.GL_LIGHT1, GL2.GL_SPECULAR, lightColorSpecular, 0);

        // Enable lighting in GL.
        gl.glEnable(GL2.GL_LIGHT1);
        gl.glEnable(GL2.GL_LIGHTING);
        
        gl.glClearDepth(1.0f);                      // Depth Buffer Setup
        gl.glEnable(GL2.GL_DEPTH_TEST);              // Enables Depth Testing
        gl.glDepthFunc(GL2.GL_LEQUAL);               // The Type Of Depth Testing To Do
        // Really Nice Perspective Calculations
        gl.glHint(GL2.GL_PERSPECTIVE_CORRECTION_HINT, GL2.GL_NICEST);
       
    }
 
    public void reshape(GLAutoDrawable gLDrawable, int x, int y, int width, int height) 
    {
    
        final GL2 gl = gLDrawable.getGL().getGL2();
 
        if (height <= 0) // avoid a divide by zero error!
        {
            height = 1;
        }
 
        final float h = (float) width / (float) height;
 
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(GL2.GL_PROJECTION);
        gl.glLoadIdentity();
        glu.gluPerspective(60.0f, h, 1.0, 10000.0);
        glu.gluLookAt(0, 0, distance, 0, 0, 0, 0, 1, 0);
        gl.glMatrixMode(GL2.GL_MODELVIEW);
        gl.glLoadIdentity();
    }
    
    public void kill(){
    	frame.dispose();
    }

    @Override
	public void mouseDragged(MouseEvent e) {
		
		x = e.getX();
		y = e.getY();
		
		if (x - xPrev < 0){
			angleY -= 3.0;
		} else if (x - xPrev > 0){
			angleY += 3.0;
		}
		
		if (y - yPrev < 0){
			angleX -= 3.0;
		} else if (y - yPrev > 0){
			angleX += 3.0;
		}
		
		xPrev = x;
		yPrev = y;
	
	}
	
	@Override
	public void mousePressed(MouseEvent e) {
	
		xPrev = e.getX();
		yPrev = e.getY();
		
	}
	
	@Override
	public void windowClosed(WindowEvent e) {

	}

	@Override
	public void windowClosing(WindowEvent e) {
		Main.chckbxShowSourceAnd.setSelected(false);
		frame.dispose();
		
	}
	
	@Override
	public void windowOpened(WindowEvent e) {
		
	}

	@Override
	public void mouseWheelMoved(MouseWheelEvent e) {
		 
	       int notches = e.getWheelRotation();
	       if (notches < 0) {
	           distance += 6;
	       } else {
	    	   distance -= 6;
	       }	
	}
	
	public void displayChanged(GLAutoDrawable gLDrawable, boolean modeChanged, boolean deviceChanged){ }

	public void dispose(GLAutoDrawable arg0){ }

	@Override
	public void mouseMoved(MouseEvent e) { }


	@Override
	public void mouseClicked(MouseEvent e) { }


	@Override
	public void mouseEntered(MouseEvent e) { }


	@Override
	public void mouseExited(MouseEvent e) {	}

	@Override
	public void mouseReleased(MouseEvent e) { }

	@Override
	public void windowActivated(WindowEvent e) { }


	@Override
	public void windowDeactivated(WindowEvent e) { }

	@Override
	public void windowDeiconified(WindowEvent e) { }

	@Override
	public void windowIconified(WindowEvent e) { }
}
