#include <iostream>
using namespace std;

class Emlos {
protected:
    int eletkor;
    int tomeg;
public:
    Emlos(int eletkor = 0, int tomeg = 0) : eletkor(eletkor), tomeg(tomeg) {
    }

    int getEletkor() { return this->eletkor; }
    int getTomeg() { return this->tomeg; }

    void setEletkor(const int eletkor) { this->eletkor = eletkor; }
    void setTomeg(const int tomeg) { this->tomeg = tomeg; }

    void speak(){
        cout << "Emlos hang" << endl;
    }

    ~Emlos(){
        cout << "Eltunt egy emlos" << endl;
    }
};

class Macska : public Emlos {

private:
    int nyavogasSzamlalo;

public:

    Macska() : Emlos(0, 0), nyavogasSzamlalo(0) {
        cout << "Letrejott egy macska! Cime: " << this << endl;
    }

    Macska(const int eletkor, const int tomeg) : Emlos(eletkor, tomeg), nyavogasSzamlalo(0) {
        cout << "Letrejott egy macska! Cime: " << this << endl;
    }

    Macska(const Macska& macska){
        cout << "Lemasolunk egy macskát! Eredeti macska cime:" << &macska << ", masolat cime: " << this << endl;
        this->nyavogasSzamlalo = macska.nyavogasSzamlalo;
        this->eletkor = macska.eletkor;
        this->tomeg = macska.tomeg;
    }

    ~Macska() {
        cout << "kitorlunk egy macskat az univerzumbol! Cime: " << this << endl;
    }

    void speak(){
        cout << "Miau" << endl;
    }

    void nyavog();
    void mennyitNyavogott();

};

//A cica osztály nyavog() metódusának megvalósítása
void Macska::nyavog() {
    cout << "Miauuuu" << endl;
    this->nyavogasSzamlalo++;
}

void Macska::mennyitNyavogott(){
    cout << "A cica eddig " << nyavogasSzamlalo << " alkalommal nyavogott." << endl;
}



int main() {
/*    Macska nyafi(1, 10);

    nyafi.speak();
*/
    Emlos* kormi = new Macska(2, 5);

    kormi->speak();

    delete kormi;
    return 0;
}
