#include <iostream>
#include <fstream>
#include <string>

using namespace std;

class Nevjegy {
private:
    string vezeteknev;
    string keresztnev;
    string telefon;
    string web;

public:
    Nevjegy() :vezeteknev(""), keresztnev(""), telefon(""), web(""){}
    Nevjegy(const string& vnev, const string& knev, const string& telefon, const string& web) :
        vezeteknev(vnev), keresztnev(knev),
        telefon(telefon), web(web) {
        //cout << "Nevjegy letrehozva" << endl;
    }

    string egysoros(){
        return this->vezeteknev + " " + this->keresztnev + " " + this->telefon + " " + this->web;
    }

    friend ostream& operator<<(ostream&, const Nevjegy&);
};

ostream& operator<<(ostream& os, const Nevjegy& nevjegy) {
    os << "[Nev=" << nevjegy.vezeteknev << " " << nevjegy.keresztnev << ", "
        << "telefon=" << nevjegy.telefon << ", "
        << "web=" << nevjegy.web << "]" << endl;
    return os;
}

int main(){
    Nevjegy chuck("Chuck", "Norris", "06306969888", "http://chuck.norris");
    cout << chuck;

    /* 
     * Fajlbol olvasas valtozokba
     */
    ifstream in("C:\\input.txt");
    if (in.is_open()) {
        cout << "Input megnyitva, beolvasas kovetkezik!" << endl;

        string vnev, knev, tel, web;
        
        while (in >> vnev >> knev >> tel >> web) {
            Nevjegy valaki(vnev, knev, tel, web);
            cout << valaki;
        }
    } else {
        cerr << "Nem sikerult megnyitni a fajlt" << endl;
    }

    in.close(); // Megnyitott inputot be is kell zarni


    in.open("C:\\input.txt");
    if (in.is_open()) {
        std::string temp;
        int i = 0;
        while (getline(in, temp)) {
            cout << i++ << ". " << temp << "\t temp.size() " << temp.size() << endl;
        }
    }


    /*
     * Fajlba iras
     */
    ofstream fout("C:\\input.txt", ios::app);
    if (fout.is_open()) {
        cout << "Output megnyitva, kiiras kovetkezik!" << endl;
        fout << chuck.egysoros() << endl;
        cout << "Kiiras kesz" << endl;
    }

    fout.close();

    return 0;
}
