#ifndef Alakzat_h
#define Alakzat_h

#include<iostream>

 // Ez egy absztrakt osztály
class Alakzat {
public:
  /**
    Virtuális függvények.
    Ez arra való, hogy ha egy ősosztálybeli függvény elé rakjuk a virtual
    kulcsszót, az alosztályában létezik egy ugyanilyen nevű és argumentumú
    függvémy és ha egy ősosztálybeli pointerrel vagy referenciával mutatunk az alosztály
    példányára, akkor a függvény meghívásakor nem az ősosztályé, hanem az alosztály
    függvénye fog meghívódni.
  */
  virtual void print(){ std::cout << "Ez egy alakzat, "; }
  
   // Ezek úgynevezett pure virtual függvények
   // Jellemzőjük, hogy ha egy is van az osztályon belül
   // akkor az osztály csak absztakt lehet, nem lehet példányosítani
  virtual double getKerulet() = 0;
  virtual double getTerulet() = 0;
  
  /**
    Ha nem tesszük ki a virtual kulcsszót, és ugyanaz az eset áll fennt mint
    az előbb, akkor az ősosztály függvénye fog meghívódni,
    hiába is írtuk felül azt az alosztályban.
    Példa ezekre az AlakzatMain.cpp-ben
  */
  void azonosito(){ std::cout << "Eredeti azonosito: " << rand() << std::endl; }  
};

class Kor : public Alakzat {
private:
  double m_dsugar;
public:
  Kor( double r ): m_dsugar( r ){}
  ~Kor(){}
  void print();
  double getKerulet();
  double getTerulet();
  void azonosito(){ std::cout << "Felulirt azonosito: " << rand() << std::endl; }
};

class Negyzet : public Alakzat {
private:
  double m_da;
public:
  Negyzet( double a ): m_da( a ){}
  ~Negyzet(){}
  void print();
  double getKerulet();
  double getTerulet();
  void azonosito(){ std::cout << "Felulirt azonosito: " << rand() << std::endl; } 
};

/**
  Feladat:
    Írjuk meg a rombusz osztály hasonlóképpen
    Rombusznak legyen:
        - 3 double adattagja: átló1, átló2, oldalhossz
        (Rombusz területe T = 1/2 * átló1 * átló2;
                 kerülete K = 4 * oldalhossz;)
    - mainben hozzunk létre egy példányt amelynek oldalhossza 3, átlói 4.24 hosszúak.
    - hívjuk meg rá a print és az azonosító függvényeket
*/

#endif