<?php
/**
 *	PPager.class.php
 *
 *	@author Zoltan Pazsit <pazsitz@gmail.com>
 *	@copyright Copyright (c) 2009, Zoltan Pazsit
 *
 *	@version v1.0b 2010.10.08.
 **/

/**
 *	@property PPager $pager
 *  @var <string> $pagerTemplate
 *  @var <string> $separatorTemplate
 */
class PPager{
	private $pagelimit;
	private $rownum;
	private $actpage;

	public $pagerTemplate = '<a class="pagerlink" href="[!PAGEURL]">[!PAGECNTFROM] - [!PAGECNTTO]</a>';
	public $separatorTemplate = " | ";

	/**
	 *
	 * @global <int> $ppage
	 * @global <int> $pagelimit
	 * @param <int> $rownnum			Sum of all listable rows
	 * @param <int> $param_ppage		actual page Number
	 * @param <int> $param_pagelimit	item Number on a page
	 */
	public function  __construct($rownum, $param_ppage = false, $param_pagelimit = false) {
		global $ppage, $pagelimit;

		$this->rownum = $rownum;
		if ($param_ppage != false) $this->actpage = $param_ppage;
		else $this->actpage = $ppage;
		if ($param_pagelimit != false) $this->pagelimit = $param_pagelimit;
		else $this->pagelimit = $pagelimit;
	}
	/**
	 *
	 * @return int
	 */
	public function getPager(){
		$PagesData = array();

		$counter = 1;
		$Pcounter = 0;

		do{
			$PagesData[] = array($counter, ($counter+$this->pagelimit)-1, ($Pcounter == $this->actpage));
			$counter += $this->pagelimit;
			$Pcounter ++;
		}while($counter <= $this->rownum);

		return $PagesData;
	}
	/**
	 *
	 * @param <string> $template
	 * @param <string> $separator
	 * @return <string>
	 */
	public function getHTMLPager($url = false, $template = false, $separator = false){
		if ($url === false ) $url = "[!BASEPAGEURL]&ppage=[!PAGECNT]";
		if ($template == false) $template = $this->pagerTemplate;
		if ($separator == false) $separator = $this->separatorTemplate;

		$PagesData = $this->getPager();

		$PagesHTML = "";
		foreach($PagesData as $pageCnt => $data){
			list($pagecntfrom, $pagecntto, $nonActive) = $data;

			$item = $template;
			if ($nonActive)	$item = str_replace (array('class="','href="[!PAGEURL]"'), array('class="actpage ',''), $item);
			$item = str_replace("[!PAGEURL]", $url, $item);
			$item = str_replace(array("[!PAGECNTFROM]","[!PAGECNTTO]","[!PAGECNT]"), array("$pagecntfrom","$pagecntto","$pageCnt"), $item);
			$item = str_replace("[!BASEPAGEURL]", $_SERVER['REQUEST_URI'], $item);

			replace($pageurl, $item, false, "pageurl");
			$PagesHTML .= $item.$separator;
		}

		$PagesHTML = mb_substr($PagesHTML,0,-mb_strlen($separator));
		$pagesHTML = "<center>$PagesHTML</center>";
		return $PagesHTML;
	}
}
?>