<?php
/**
 *	Template.class.php
 *
 *	@author Zoltan Pazsit <pazsitz@gmail.com>
 *	@copyright Copyright (c) 2010, Zoltan Pazsit
 *
 *	@version v0.3 Experimental Alpha 2010.06.17.
 **/
class Template{
	private static $templateArr;
	private static $Template;
	/**
	 * Singelton Template Class
	 * @param <string> $temp_Name
	 * @param <bool> $multi
	 * @param <string> $varname
	 */
	private function __construct(){
		Template::$templateArr = array();
	}

	/**
	 * Singleton __constructor
	 */
	public static function _create(){
		 if (!isset(self::$Template)) {
            $class = __CLASS__;
            self::$Template = new $class;
        }

        return self::$Template;
	}
	/**
	 * Disable clone
	 */
	public function __clone(){
        trigger_error('Clone is not allowed.', E_USER_ERROR);
    }

	public function  __destruct() {
		Template::$templateArr = array();
		self::$Template = null;
	}
	/**
	 * Inserts the given variable into the given replace array key
	 * It builds a hierarchical replace array
	 * @param <type> $method
	 * @param <type> $args
	 * @return <type>
	 */
	public static function _addTemplateVar($var,$vname,$temp_Name="html",$multi=false){
		
		if ($multi) self::$templateArr[$temp_Name][]["[!".strtoupper($vname)."]"]=$var;
		else self::$templateArr[$temp_Name]["[!".strtoupper($vname)."]"]=$var;
    }

	/**
	 * Makes the replace in the given template inside the array
	 *
	 * @param <string> $repArrkey
	 * @param <bool> $concat
	 */
	public static function _makeTemplate(&$repArrkey,$vname,$concat=false){

		$repArrkey_original = $repArrkey;
		$firstval = $temp_templates = "";
		if ($concat){
			$firstval = key(current(self::$templateArr[$vname]));
			$repArrkey = "";	//var_export(self::$templateArr[$vname]);
			foreach(self::$templateArr[$vname] as $key => $value){
				if(!is_array($value)) echo "$firstval key[$key]=> $value";
				if ($firstval == key($value)){
					$temp_templates.=isset($repArrkey)?$repArrkey:"";
					$repArrkey = $repArrkey_original;
				}
				$repArrkey = str_replace(key($value), current($value), $repArrkey);
			}
			$temp_templates.=isset($repArrkey)?$repArrkey:"";
			$repArrkey = $repArrkey_original;
			unset(self::$templateArr[$vname]);
			$vname="[!".strtoupper($vname)."]";
			self::$templateArr['html'][$vname] = $temp_templates;
		}
		else{
			$repName="[!".strtoupper(array_keys(self::$templateArr[$vname]))."]";
			$temp_template = str_replace($repName, self::$templateArr[$vname], $repArrkey);
			unset(self::$templateArr[$vname]);
			self::$templateArr['html'][$vname] = $temp_template;
		}
	}
	/**
	 * Makes the replace in the whole template
	 *
	 * @global <string> $html
	 * @param <bool> $ajax
	 * @return <string>
	 */
	public static function _makeFinalTemplate($ajax=false){
		global $html;
		if ($ajax!==false) $html = "[!SUBHTML]";
		foreach(self::$templateArr as $key => $data){		//	completes unresovles templates arrays
			if ($key!="html" && is_array($data)) makeTemplate($data,$key);
		}

		$html = str_replace("[!SUBHTML]", self::$templateArr['html']["[!SUBHTML]"], $html);
		unset(self::$templateArr['html']["subhtml"]);

		foreach(self::$templateArr["html"] as $key => $data){
			if (preg_match("/\[!.*\]/",$key)) $insKey = $key;
			else $insKey = "[!".strtoupper($key)."]";
			$html = str_replace($insKey, $data, $html);
		}

		return $html;
	}

}

?>