<?PHP
/**
 *	baselib.php	
 *
 *	@author Zoltan Pazsit <pazsitz@gmail.com>
 *	@copyright Copyright (c) 2009, Zoltan Pazsit
 *
 *	@version v0.6.5 Alfa 2010.12.10.
 **/	

////////////////////////////////////////////////////////////////////////////////
//	auto load handle functions
define("CLASSPATH",	DIR_INCLUDE."/classPaths.inc.gen.php");
require_once(DIR_INCLUDE."/classPaths.inc.gen.php");
/**
 * Class File Auto Loader
 * @global <array> $classPathArr
 * @param <string> $class_name
 * @return <bool>
 */
function __autoload($class_name){
	global $classPathArr;
	//$class_name = strtolower($class_name);
	if(!isset($classPathArr[$class_name])){
		printClassPathFile(genClassPaths());	// generate if class missing
		if(!isset($classPathArr[$class_name])){		//	no such class
			if(!isset($classPathArr)){
				trigger_error ("Fail to load classPathArr ".CLASSPATH, E_USER_WARNING);
				return false;
			}
			else{
				trigger_error ("Fail to load from array path / class: $class_name", E_USER_WARNING);
				return false;
			}
		}
	}
	// load class
	$classPath = $classPathArr[$class_name];
    if(is_file("$classPath/{$class_name}.class.php")){
		require_once("$classPath/{$class_name}.class.php");		//	class
	}
	else{
		$iaFileName = mb_substr($class_name,1);
		if( ((substr($class_name,0,1)=="i") || (substr($class_name,0,1)=="a"))		//	interface or abstract class from class file
			&& is_file("$classPath/{$class_name}.class.php")
		){
			require_once("$classPath/{$class_name}.class.php");
		}
		else trigger_error ("Fail to load path / class: $classPath / $class_name", E_USER_WARNING);
	}
}
/**
 * Generates Path of Class Files into an Array
 * @global <array> $classPathArr	Class Files Array
 * @param <string> $dir				default:"../../inc/class"
 * @return <array>
 */
function genClassPaths($dir="class"){
	global $classPathArr;
	if ($handle = opendir("$dir/")) {
		while (false !== ($file = readdir($handle))) {
			if ($file != "." && $file != "..") {
				if(!is_dir("$dir/$file/")){
					if(substr($file, -10)==".class.php"){				 
						$tempfile = str_replace(".class.php","",$file);
						//$tempfile = strtolower($tempfile);
						$classPathArr[$tempfile] = "$dir/";
					}
				}
				else $tempArr = genClassPaths("$dir/$file");
			}
		}
		closedir($handle);
	}
	return $classPathArr;
}
/**
 * Makes ClassPathArray PHP
 * @param <array> $arr
 */
function printClassPathFile($arr){
	$arrString = "\n";
	if(!empty($arr)) foreach($arr as $key => $value) $arrString .= "\t\"$key\" => \"$value\", \n";
	file_put_contents(CLASSPATH, "<?php \$classPathArr = array($arrString);?>");
}

////////////////////////////////////////////////////////////////////////////////
//	define base variables

$now = date("Y-m-d H:i:s");
list($today, $timenow) = explode(" ", $now);
$reportLog = "";

////////////////////////////////////////////////////////////////////////////////
//	template functions

/**
 *
 * @param <string> $fileName
 * @return <string>
 */
function getFile($fileName){
	global $adminsession,$sumtime1,$sumtime2;

	if (!file_exists(DIR_TEMPLATE."/$fileName")) return (!empty($adminsession)) ? "missing file: $fileName" : "missing file";

	$html = file_get_contents(DIR_TEMPLATE."/$fileName","r");

	if ($html != false) return $html;
	else return (!empty($adminsession)) ? "fail on load $fileName" : "fail on load";
}
/**
 * Inserts the given variable into the given replace array key
 * It builds a hierarchical replace array
 *
 * @global <array> $content_arr
 * @param <string> $var
 * @param <string> $varname
 * @param <string> $temp_Name
 * @param <bool> $multi
 */
function addTemplateVar(&$var,$vname,$temp_Name="html",$multi=false){
	Template::_addTemplateVar($var, $vname, $temp_Name, $multi);
}
/**
 * Makes the replace in the given template inside the array
 *
 * @global <array> $content_arr
 * @param <string> $repArrkey
 * @param <string> $vname
 * @param <bool> $concat
 */
function makeTemplate(&$repArrkey,$vname,$concat=false){
	Template::_makeTemplate($repArrkey, $vname, $concat);
}
/**
 * Makes the replace in the whole template
 *
 * @global <array> $content_arr
 * @global <string> $html
 * @param <bool> $ajax
 * @return <string>
 */
function makeFinalTemplate($ajax=false){
	return Template::_makeFinalTemplate($ajax);
}
/**
 * replaces the given variable in the given template
 *
 * @param <string> $var
 * @param <string> $template
 * @param <bool> $speChar
 * @param <string> $varname
 */
function replace(&$var,&$template,$speChar=true,$varname=""){
	if(empty($varname)){
		//	get variable name - starts
		$prefix = 'unique';$suffix = 'value';
		$vals = $GLOBALS;
		$old = $var;
		$var = $new = $prefix.rand().$suffix;
		$vname = FALSE;
		foreach($vals as $key => $val) {
			if($val === $new) $vname = $key;
		}
		$var = $old;
	}
	//	get variable name - ends
	if(empty($vname) && !empty($varname)) $vname = $varname;
	elseif (empty($vname) && empty($varname)) return false;

	if ($speChar) $rep_temp_Var = myhtmlspecchar($var,true);
	else $rep_temp_Var = $var;

	$template = str_replace("[!".strtoupper($vname)."]",$rep_temp_Var,$template);
}
/**
 * Use as echo/print/var_export instead of messing up the html content ;)
 * @global <string> $reportLog
 * @param <variable> $reportVar
 */
function reportVar(&$reportVar){
	global $reportLog;
	$varName = vname($reportVar);
	$reportLog .= "<@$varName> -> $reportVar";
}
/**
 *
 * @global <string> $reportLog
 * @param <variable> $reportString
 */
function report($reportString){
	global $reportLog;
	$reportLog .= "logmsg: $reportString";
}
/**
 *
 * @param <array> $array
 * @param <string> $selected
 * @return string
 */
function createSelect($array, $selected){
	$select = "";

	foreach ($array as $key => $val)
	{
		$select .= "<option value=\"$key\"".((string)$key == (string)$selected?" selected='selected'":"").">$val</option>\n";
	}

	return $select;
}

////////////////////////////////////////////////////////////////////////////////
//	filter functions

define("FILTERLIST_NUM",		"/[^0-9%separator%]*/");
define("FILTERLIST_CHAR",		"/[^a-zA-z%separator%]*/");
define("FILTERLIST_SEP",		",");
/**
 * filters the given chars and corrects spearator by regexp
 * or just filters if $filterseparator is empty
 *
 * @param <string> $str
 * @param <string> $filterregexp
 * @param <string> $filterseparator
 * @return <string>
 */
function filterList($str, $filterregexp=FILTERLIST_NUM, $filterseparator=FILTERLIST_SEP){
	if (is_array($str)) $str = implode(',',$str);

	$filterregexp = str_replace("%separator%",$filterseparator,$filterregexp);
	$str = preg_replace($filterregexp,"",$str);
	if (!empty($filterseparator)){
		$i = 0;	// failsafe variable
		do{
			$str = preg_replace("/$filterseparator$filterseparator/","$filterseparator",$str);
		}while(preg_match("/$filterseparator$filterseparator/",$str,$x) || $i<1000);
		$str = trim($str,"$filterseparator");
	}

	return $str;
}
/**
 * makes htmlspecailchar() but prevents duplicate entites
 *
 * @param <string> $strin
 * @param <string> $giveReturn
 * @return <string>
 */
function myhtmlspecchar(&$strin,$giveReturn=false)
{
	$str = $strin;
	$str = str_replace("&amp;","&",$str);
	$str = htmlspecialchars($str);

	$from = array("&ampquot;","&ampgt;","&amplt;");
	$to   = array("&quot;","&gt;","&lt;");
	$str  = str_replace($from, $to, $str);

	if ($giveReturn) return $str;
	else $strin = $str;
}
/**
 * addslashes and escapes sensitive chars by LIKE query search
 *
 * @param <string> $strin
 * @param <string> $giveReturn
 * @return <string>
 */
function filterLike(&$strin,$giveReturn=false)
{
	$str = $strin;
	$str = addslashes($str);
	$str = str_ireplace(array("%"),array("\%"),$str);
	
	if ($giveReturn) return $str;
	else $strin = $str;
}
/**
 * addslashes and escapes sensitive chars by MATCH AGAINST query search
 *
 * @param <string> $strin
 * @param <string> $giveReturn
 * @return <string>
 */
function filterMatch(&$strin,$giveReturn=false)
{
	$str = $strin;
	$str = str_replace(array("-","~","<",">","(",")","\""),"",$str);
	$str = addslashes($str);
	$str = str_ireplace(array("+","*"),array("\+","\*"),$str);

	if ($giveReturn) return $str;
	else $strin = $str;
}

////////////////////////////////////////////////////////////////////////////////
//	other functions

/**
 * Determine if request is ajax
 * @return <bool>
 */
function isAjax(){
	return (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest' && empty($ajaxOverWrite));
}

/**
 * returns with the name of given variable
 *
 * @param <string> $var
 * @param <bool> $scope
 * @return <string>
 */
function vname(&$var, $scope=0)
{
    $old = $var;
    if (($key = array_search($var = 'unique'.rand().'value', !$scope ? $GLOBALS : $scope)) && $var = $old)

	return $key;
}
/**
 * returns with the name of given variable
 *
 * @param <string> $var
 * @param <bool> $scope
 * @param <string> $prefix
 * @param <string> $suffix
 * @return <string>
 */
function vname2(&$var, $scope=false, $prefix='unique', $suffix='value'){
	if($scope) $vals = $scope;
	else $vals = $GLOBALS;
	$old = $var;
	$var = $new = $prefix.rand().$suffix;
	$vname = FALSE;
	foreach($vals as $key => $val) {
		if($val === $new) $vname = $key;
	}
	$var = $old;
	return $vname;
}

/**
 * returns with the given or (default) the actual URL params
 *
 * @param <string> $urlstring
 * @return <array>
 */
function getUrlParams($urlstring='QUERY_STRING'){	
	if ($urlstring == 'QUERY_STRING') $urlstring = $_SERVER['QUERY_STRING'];
	
	$params_arr = array();
	$url_arr = explode('&',$urlstring);
	foreach($url_arr as $item){
		if (mb_strpos($item,'=')) list($key,$data) = explode('=',$item);
		else {
			$key = $item;
			$data = "";
		}
		
		$params_arr[$key] = $data;
		
	}
	return $params_arr;
}

/**
 * returns with the IP "real" address
 *
 * @return <string>
 */
function get_IP(){
	$ip = "";
	if(!empty($_SERVER['REMOTE_ADDR'])) $ip = $_SERVER['REMOTE_ADDR'];
	if(!empty($_SERVER["HTTP_CLIENT_IP"])) $ip = $_SERVER["HTTP_CLIENT_IP"];
	if(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
		$ips = explode (", ",$_SERVER['HTTP_X_FORWARDED_FOR']);
		if($ip){
			array_unshift($ips, $ip);
			$ip = FALSE;
		}
		for($i=0; $i<count($ips); $i++){
			if(!preg_match('/^(?:10|172\.(?:1[6-9]|2\d|3[01])|192\.168)\./',$ips[$i])){
				if(version_compare(phpversion(),"5.0.0",">=")){
					if(ip2long($ips[$i]) != false){
						$ip = $ips[$i];
						break;
					}
				}
				else if (getenv('HTTP_X_FORWARDED_FOR')) $ip = getenv('HTTP_X_FORWARDED_FOR');
			}
		}
	}
	
	return $ip;
}

function convert($size){
	$unit=array('b','kb','mb','gb','tb','pb');
	return @round($size/pow(1024,($i=floor(log($size,1024)))),2).' '.$unit[$i];
}

?>