<?PHP
/**
 *	plib.inc.php	
 *
 *	@author Zoltan Pazsit <pazsitz@gmail.com>
 *	@copyright Copyright (c) 2009, Zoltan Pazsit
 *
 *	@version v1.0b 2010.12.08.
 **/		 

//	Array functions
/**
 * in_array function for multi dimensional arrays
 *
 * @param <string> $needle
 * @param <array> $haystack
 * @return boolean
 */
function in_multi_array($needle, $haystack) {
	$in_multi_array = false;
	if(in_array($needle, $haystack)) {
		$in_multi_array = true;
	}
	else {   
		for($i = 0; $i < sizeof($haystack); $i++) {
			if(is_array($haystack[$i]))	{
				if(local_in_multi_array($needle, $haystack[$i])) {
					$in_multi_array = true;
					break;
				}
			}
		}
	}
	return $in_multi_array;
}
/**
 * isNonemptyItemCheck function checks if exists non empty item
 *
 * @param <string> $needle			(simple or multidimensional array)
 * @return <boolean>
 */
function isNonemptyItemCheck($needle){
	if (is_array($needle)){
		for(;current($needle)!=FALSE;next($needle)){
			$val=current($needle);
			echo $needle[key($needle)]."\n<br>";
			if(is_array($needle[key($needle)]))	{
				echo key($needle);
				if (isNonemptyItemCheck($needle[key($needle)])) return true;
			}
			else{
				if (!empty($val)) return true;
			}
		}
	}
	else if (!empty($needle))  return true;

	return false;
}
	
//	String handle functions
/**
 * removes F like words from the string
 * @param <string> $comment
 * @return <string>
 */
function imbecilewords($comment) {
	$arr2=array("szar","fasz","sz@r","f@sz","fos","hülye","hüje","sex","szex","mi");			//	teljes szó (nem fordul elő más szóban)
	$arr=array("jelö","komi","jelo","jeli","jєℓ","komy","geci","cigány","anyád","punci",
	"kurva","pina","zsidó","pöcs","szopj","szopd","pénisz","lófasz","lofasz","napiszar",
	"puruttya");		//	szódarab
	$comment=mb_strtolower($comment);
	
	foreach ($arr2 as $str){
		if ($str==$comment) return true;
	}
	
	foreach ($arr as $str){
		if (mb_strpos($comment,$str)!==false) return true;
	}

	return false;
}
/**
 * remove smileys from the string
 * @param <string> $comment
 * @return <string>
 */
function unsmiley($comment) {
	$arrsm=array(":)",":D","XD","^^",":P");
	return str_ireplace($arrsm,array(""),$comment);
}
/**
 * urldecodes an UTF-8 string
 *
 * @param <string> $str
 * @return <string>
 */
function utf8_urldecode($str) {
	$str = preg_replace("/%u([0-9a-f]{3,4})/i","&#x\\1;",urldecode($str));
	$str = iconv('ISO-8859-2','UTF-8',$str);
	return html_entity_decode($str,null,'UTF-8');
}
/**
 * converts quotes
 * @param <string> $str
 * @return <string>
 */
function convert_quote($str){
	$search = array( '&','<','>','"',chr(212),chr(213),chr(210),chr(211),chr(209),chr(208),chr(201),chr(145),chr(146),chr(147),chr(148),chr(151),chr(150),chr(133) );
	$replace = array( '&amp;','&lt;','&gt;','&quot;','&#8216;','&#8217;','&#8220;','&#8221;','&#8211;','&#8212;','&#8230;','&#8216;','&#8217;','&#8220;','&#8221;','&#8211;','&#8212;','&#8230;' );
	return str_replace($search,$replace,$str);
}


//	Tools
/**
 * Checks a numeric value if exists and if it's a real numeric Value
 * Sets the given Value name to global
 * @param <string> $Var
 * @param int $defaultValue
 * @return <bool>
 */
function emptyNumeric($Var,$defaultValue=0){
	global $$Var;

	if (empty($$Var) && empty($_REQUEST[$Var])){
		$$Var = $defaultValue;
		return true;
	}
	else{
		if(!isset($$Var)) $$Var = $_REQUEST[$Var];
		$$Var *= 1;
		return (empty($$Var)) ? true : false;
	}
}
/**
 * returns with the array printed in html table structure
 * @param <array> $TheArray
 * @param <string> $arrayname
 * @return string
 */
function print_a($TheArray, $arrayname="") {
	$out='';
	$started=false;
	if(ob_get_level()==0) {
		ob_start();
		$started=true;
	}
	if (!empty($arrayname))	{
		$out.= "<strong><u>$arrayname</u>:</strong><br>";
	}

	$out.= "<table border=1>\n";
	$Keys = array_keys( $TheArray );
	$i=0;
	foreach( $Keys as $OneKey )	{
		$i++;
		$out.= "<tr>\n";
		$out.= "<td  style=\"font-size: 11px;\" bgcolor='#727450'>";
		$out.= "<B>" . $OneKey . "</B>";
		$out.= "</td>\n";
		$out.= "<td style=\"font-size: 11px;\" bgcolor='#C4C2A6'>";
		if ( is_array($TheArray[$OneKey]) ) $out.= print_a($TheArray[$OneKey]);
		else $out.= $TheArray[$OneKey];
		$out.= "</td>\n";
		$out.= "</tr>\n";
		if($i%100==0) {
			ob_flush();
			flush();
		}
	}
	$out.= "</table>\n";
	if($started === true) ob_end_flush();
	return $out;
}
/**
 * Gives the time in normal float value
 * @return <float>
 */
function microtime_float()
{
   list($usec, $sec) = explode(" ", microtime());
   return ((float)$usec + (float)$sec);
}
/**
 * returns with the array of time difference
 * @param <integer> $start_time
 * @param <integer> $end_time
 * @return <array>
 */
function time_diff_past($start_time,$end_time){
	
	$end = date("Y-m-d H:i:s",strtotime($end_time));
	
	$start = date("Y-m-d H:i:s",strtotime($start_time));
	
	//echo "$end - $start<br>\n";
	$diff = strtotime($end) - strtotime($start);
	if ($diff<0) $diff*=(-1);
	//convert to min and sec
	
	$convert_min = $diff/60;
	$convert_hr = floor($convert_min/60);
	$convert_day = floor($convert_hr/24);	
	
	$time_arr=array($convert_min,$convert_hour,$convert_day);
	
	return $time_arr;
}


//	Debug functions
/**
 * Do the print into variable trick
 * @return <type>
 */

function debug_string_backtrace($backtrace){
	global $needLargeDetailedLog;
	$trace = "";
	$traceArr = $backtrace;
	$counter = count($traceArr);
	foreach($traceArr as $key => $value){
		if($key>0){
			$counter--;
			if (strpos($value["function"],"sql_query")!==false) $traceargs = "\n args:".var_export($value["args"],true);
			else $traceargs = "";
			if(strpos($value["function"],"sql_fetch_row")!==false) $needLargeDetailedLog = 1;
			if(isset($value["file"])) $trace .= "#".$counter." in: ".$value["file"].":".$value["line"]." line >".$value["function"]."() $traceargs\n";
			else $trace .= "#".$counter." in: ".$value["class"].$value["type"].$value["function"]." $traceargs\n";
		}
	}
	return $trace;
}

/**
 * @uses include_once("../../inc/lib/pLib.inc.php");
 * @uses $my_error_handler = set_error_handler("pErrorHandler");
 * @uses deactivate with: restore_error_handler();
 * @global <string> $now
 * @global string $errorHandlerDebugScript	string output about errors
 * @global int $needLargeDetailedLog		triggers automaticly if mysql error occurs
 */
function pErrorHandler($errno, $errstr, $errfile, $errline){
	global $now,$errorHandlerDebugScript,$needLargeDetailedLog;
	$needLargeDetailedLog = 0;
	//	defined exceptions
	$skipTypes = array(
		2048	=>	"E_STRICT",
	);
	// The backtrace
	$backtrace = debug_backtrace();
	//	log the desired errorHandler events
	if(!isset($skipTypes[$errno]) && empty($skipThis)){
		if(is_array($errstr)) $errstr = print_r($errstr,true);
		$errStr = "error [$errno]: in file:$errfile:$errline line; $errstr\n";
		$errStr .= debug_string_backtrace($backtrace);
		$errStr .= "\n--------------------\n";
		$fp=fopen("log/pErrors.log","a");
		fwrite($fp,"$now - ".$errStr);
		fclose($fp);
//	if(!isset($errorHandlerDebugScript)) $debugscript = "";
		$errorHandlerDebugScript .= $errStr;
	}
	//	Large detailed log
	if($needLargeDetailedLog){
		$errDetailedStr = "$now - error [$errno]: in file:$errfile:$errline line; $errstr\n";
		$errDetailedStr .= print_r($backtrace,true);
		$errDetailedStr .= "\n--------------------\n";
		$fp2=fopen("log/pErrors_detailed.log","a");
		fwrite($fp2,$errDetailedStr);
		fclose($fp2);
	}

	return false;	//	restore the normal error handler to continues
}


?>