<?php
/**
 *	PH_movies_lib.inc.php
 *
 *	@author Zoltan Pazsit <pazsitz@gmail.com>
 *	@copyright Copyright (c) 2010, Zoltan Pazsit
 *
 *	@version v0.75 2010.12.09.
 **/

/////////////////////////////////
//	Constants

$pagelimit = 100;
$voteArr = array(
	0	=>	0,
	1	=>	1,
	2	=>	2,
	3	=>	3,
	4	=>	4,
	5	=>	5,
	6	=>	6,
	7	=>	7,
	8	=>	8,
	9	=>	9,
	10	=>	10,
	11	=>	11,
	12	=>	12,
	13	=>	13,
	14	=>	14,
	15	=>	15,
	16	=>	16,
	17	=>	17,
	18	=>	18,
	19	=>	19,
	20	=>	20,
);

/**
*	check if movieID exists, single id or ids array
*	@param int/array $id
*	@param bool $array
*	@return bool/array $ids
**/
function isMovie($id,$array=false){
	if (is_array($id)){
		$idItems="";
		foreach($id as $item){
			if (!is_array($item)){
				$idItems.="$item, ";
			}
			else return false;
		}
		$idItems=mb_substr($idItems, 0, -1);
		isMovie($idItems,true);
	}
	else{
		$sql="SELECT ID FROM ph_movies WHERE ID IN ( $id )";
		$result=mysql_query($sql);
		while(list($id)=mysql_fetch_row($result)) $ids[$id]=$id;
		if(empty($ids)) return false;
		else{
			if ($array){
				return $ids;
			}
			else return true;
		}
	}
}

/**
 * check if movie name exists
 * @param <string> $name
 * @return <bool> $var
 */

function isMovieName($name,$doNotAddslash=false){
	if (!$doNotAddslash) $name=addslashes($name);
	$db = PSQL::create();
	$db->doQuery("SELECT or_title FROM PH_movies WHERE or_title='$name'");
	$db->pSQLnumrows;
	return ($row>0) ? true : false;
}

class GetData{

	public $template;
	public $isPublic;
	private $moviesids;
	private $movies;
	private $pagelimit;
	protected $db;
	protected $dbvar;
	protected $loguservote;

	/**
	 *
	 * @global <int> $pagelimit
	 * @global <instance> $db
	 * @global <instance> $dbvar
	 * @param <int> $pagelimit
	 * @param <bool> $isPublic
	 */
	function  __construct($pagelimit=false,$isPublic=false) {
		global $pagelimit;

		if ($pagelimit === false) $this->pagelimit = $pagelimit;
		$this->db = PSQL::_create();
		$this->dbvar = PSQL::$var;
		$this->movies = array();
		$this->moviesids = array();
		$this->isPublic = $isPublic;
	}

	function  __destruct() {
		//$this->db = null;
		//$this->dbvar = null;
		PSQL::$var->_empty();
		$this->movies = array();
		$this->moviesids = array();
	}
	/**
	 *
	 * @global  $db
	 * @global  $dbvar
	 * @global <int> $pagelimit
	 * @param <int> $queryFrom
	 * @param <int> $param_pagelimit
	 * @return <int>
	 */
	private function getMoviesData($queryFrom, $param_pagelimit=false){
		global $db, $dbvar, $pagelimit;

		if ($param_pagelimit==false) $param_pagelimit = $pagelimit;
		$this->db->doQuery("SELECT id, or_title, eng_title, hun_title, imdb_ref, port_ref, vote FROM PH_movies ORDER BY vote DESC, or_title LIMIT $queryFrom, $param_pagelimit");
		//$this->db->printQuery();
		$this->db->doFetch();
		do{
			$this->movies[$dbvar->id] = array("or_title"=>$this->dbvar->or_title, "eng_title"=>$this->dbvar->eng_title, "hun_title"=>$this->dbvar->hun_title, "imdb_ref"=>$this->dbvar->imdb_ref, "port_ref"=>$this->dbvar->port_ref, "votep"=>$this->dbvar->vote, "votecnt"=>0, "loguservote"=>false, "iscomment"=>0);
			$this->moviesids[$dbvar->id] = $dbvar->id;
		}while($this->db->doFetch());
		//false után még van egy query sor -> echo $this->dbvar->or_title;
		$this->db->globalGarbageCollect();
		$this->dbvar->_empty();
		return $this->db->pSQLnumrows;
	}
	/**
	 * Builds movieListt template in movielist
	 * @param <string> $template
	 * @param <int> $queryFrom
	 */
	public function getMoviesHTML($template=false, $queryFrom=0){
		global $voteArr,$content_arr;
		
		if ($template!==false) $this->template = $template;
		else  $this->template = "";
		if($this->getMoviesData($queryFrom)){
			$this->setVoteData($this->moviesids, $this->movies);
			$modbtn = ($this->isPublic) ? getFile("list_base_item_mod.html") : "";
			$count = $queryFrom+1;
			foreach($this->movies as $id => $moviedata){
				extract($moviedata);
			//	echo var_export($moviedata,true).";";
				$voteChanger = createSelect($voteArr, $loguservote);
				if (!empty($iscomment)){
					$commentitem = getFile('list_base_item_comment.html');
					replace($iscomment, $commentitem, false, "COMMENTCOUNT");
				}
				else $commentitem = "";
				addTemplateVar($commentitem,"commentitem",'movielist',true);
				addTemplateVar($count,"count",'movielist',true);
				addTemplateVar($modbtn,"modbtn",'movielist',true);
				addTemplateVar($id,"id",'movielist',true);
				addTemplateVar($or_title,"or_title",'movielist',true);
				addTemplateVar($eng_title,"eng_title",'movielist',true);
				addTemplateVar($hun_title,"hun_title",'movielist',true);
				addTemplateVar($imdb_ref,"imdb_ref",'movielist',true);
				addTemplateVar($port_ref,"port_ref",'movielist',true);
				addTemplateVar($votep,"votep",'movielist',true);
				addTemplateVar($votecnt,"votecnt",'movielist',true);
				addTemplateVar($voteChanger,"votechanger",'movielist',true);
				addTemplateVar($loguservote,"vote","movielist",true);
				$count++;
			}
		}
	}

	/**
	 * set the votes data for listing from votes table modifies the $movies table
	 * modified keys: "votecnt"=>int, "loguservote"=>bool, "iscomment"=>bool
	 * @param <array> $moviesids
	 * @param <array> $movies
	 */
	private function setVoteData($moviesids,&$movies){
		global $s_logid,$ajax;
		$tempMovies;
		$resArr = $this->db->doQuery("SELECT movieid, PHuser, vote, comm  FROM `PH_votes` WHERE movieID IN (".implode(',',$moviesids).")",false,RET_FETCHARR);
	//	if (empty($ajax)) $this->db->printQuery();
		while($resArr = $this->db->doFetch(QUERY_EMPTY, true)){
			extract($resArr);
			$comm = (empty($comm)) ? 0 : 1;
			$movievotes[$movieid][$PHuser] = array("vote"=>$vote, "iscomment"=>$comm);
		}
		if(!empty($movievotes))
		foreach($movievotes as $moviekey => $data){
			$votecnt = 0;
			$this->loguservote = false;
			foreach ($data as $userkey => $votedata){
				$movies[$moviekey]["votecnt"]++;
				if ($userkey == $s_logid){//echo $votedata["vote"].",";
					$movies[$moviekey]["loguservote"] = $this->loguservote = $votedata["vote"];
				}
				else $this->loguservote=null;
				if (!empty($votedata["iscomment"])) $movies[$moviekey]["iscomment"]++;
			}
		}
		$this->db->globalGarbageCollect();
		$this->dbvar->_empty();
	}

}


?>
