<?php
/**
 *	pSQLlib.inc.php
 *
 *	@author Zoltan Pazsit <pazsitz@gmail.com>
 *	@copyright Copyright (c) 2009, Zoltan Pazsit
 *
 *	@version v0.9.4b 2010.12.07.
 *
 *  @todo ability to store more resources
 *  @todo singleton instance per database (for multiple database connection)
 **/

define("RET_RESOURCE",		1);
define("RET_FETCHGLOBAL",	2);
define("RET_FETCHARR",		3);
define("RET_AFFROWS",		4);

define("QUERY_EMPTY",		"default empty Query");

define("DOFETCH_JUSTSET_FALSE",	false);
define("DOFETCH_JUSTSET_TRUE",	true);
define("DOFETCH_JUSTSET_RENEW",	"setAndFalse");

global $dbvar;					//	direct connection to result variables ($pSQL->vars->)

/**
* @property PSQL $db
**/
class PSQL extends Pvars{

	private $pSQLconnection;		//	connection resource

	/** @var $db pSQL **/
	private static $db;					//	base global pSQL instance
	private static $localpSQLResult;
	public $pSQLResource;			//	actual running resource
	public $pSQLquery;				//	last runned query
	public $pSQLnumrows;			//	last runned query mysql_num_rows() value
	public $pSQLlastInsertId;		//	last runned query mysql_insert_id() value
	public $pSQLaffRowsNum;			//	last runned query mysql_affected_rows() value
	public $listQueries;
	/** instance of Pvars query variable container class **/
	public static $var = null;

	private $DML_modifiers = array(
		"INSERT "=>"INSERT ",
		"UPDATE "=>"UPDATE ",
		"REPLACE"=>"REPLACE",
		"DELETE "=>"DELETE ",
	);

	/**
	 * Singleton SQL Class
	 * @param <bool> $setconnection
	 **/
	private function __construct($setconnection = true){
		global $dbvar;
		if ($setconnection) $this->_setConnection();
		$dbvar = PSQL::$var = Pvars::_create();
	}
	/**
	 * Singleton __constructor
	 */
	public static function _create(){
		 if (!isset(self::$db)) {
            $class = __CLASS__;
            self::$db = new $class;
        }

        return self::$db;
	}
	/**
	 * Disable clone
	 */
	public function __clone(){
        trigger_error('Clone is not allowed.', E_USER_ERROR);
    }
	/**
	 * Prevent memory leaks
	 */
	public function  __destruct() {
		global $dbvar,$db;
		PSQL::$var->__destruct();
		PSQL::$var = null;
		unset($dbvar);
		unset($db);
		if ($this->pSQLconnection!=null) $this->_closeConnection();
		self::$db = null;
	}

	private function _setConnection(){
		global $dataBase, $dbhost, $dbuser, $dbpass;

		$this->pSQLconnection = @mysql_connect($dbhost, $dbuser, $dbpass);
		mysql_query("SET NAMES utf8");
		mysql_query("SET CHARACTER SET utf8");
		if (!$this->pSQLconnection) {
			die('Connection error.' . mysql_error());
		}
		if (!mysql_select_db($dataBase, $this->pSQLconnection)) die('The Site is down. :(' . mysql_error());
	}
	public function _closeConnection(){
		if(is_resource($this->pSQLconnection)) mysql_close($this->pSQLconnection);
		$this->pSQLconnection = null;
	}
	private function isModifier($sql){ return (isset($this->DML_modifiers[strtoupper(mb_substr($sql,0,7))])); }
	/**
	 * executes query with option: -return type RET_*
	 * @param <string> $sql
	 * @param <bool> $doFetch	false by default	(true/false/DOFETCH_JUSTSET_RENEW)
	 * @param <const> $returnVar	RET_FETCHGLOBAL by default (RET_RESOURCE, RET_FETCHGLOBAL, RET_FETCHARR)
	 * @return <bool> $fetchedGlobals/resource $result/int $affected_rows
	 */
	public function doQuery($sql, $doFetch=false, $returnVar = RET_FETCHGLOBAL){
		global $adminsession;

		$this->pSQLquery = $sql;
		$isModifier = $this->isModifier($sql);

		$this->pSQLResource = mysql_query($sql);

		if ((mysql_errno()>0 && !empty($adminsession)) || $this->listQueries) $this->printQuery();
		//else $this->clearResource();

		if (!$isModifier) $this->pSQLnumrows = mysql_num_rows($this->pSQLResource);
		else $this->pSQLnumrows = null;

		if ($isModifier) {
			$this->pSQLlastInsertId = mysql_insert_id($this->pSQLconnection);	// mysql_insert_id($this->pSQLnumrows);
			return $this->pSQLaffRowsNum = mysql_affected_rows($this->pSQLconnection);	// mysql_affected_rows($this->pSQLnumrows);
		}
		else{	// Not modifier Query
			self::$localpSQLResult = null;
		}

		if($returnVar == RET_FETCHGLOBAL) return $this->doFetch($this->pSQLResource,false,!$doFetch);			// set resource and return with true
		elseif($returnVar == RET_RESOURCE) return $result;
		elseif($returnVar == RET_FETCHARR) return $this->doFetch($this->pSQLResource,true,!$doFetch);	// set resource and return with true
		else return false;
	}
	/**
	 *
	 * @staticvar <resource> $localpSQLResult
	 * @param <resource> $result		SQL resource
	 * @param <bool> $returnArray		return type
	 * @param <bool> $justSetQuery		set Query (localpSQLResult)
	 * @return <bool/resource>
	 */
	public function doFetch($result = QUERY_EMPTY,$returnArray = false,$justSetQuery = DOFETCH_JUSTSET_FALSE){
		if (empty(self::$localpSQLResult) || $justSetQuery){
			if ($result == QUERY_EMPTY) self::$localpSQLResult = $this->pSQLResource;
			else self::$localpSQLResult = $result;
			if ($justSetQuery === DOFETCH_JUSTSET_TRUE) return true;
		}

		if (!$returnArray){
			$fetchResult = mysql_fetch_assoc(self::$localpSQLResult);
			if ($fetchResult){
				$this->set_pVar($fetchResult);//echo var_export($fetchResult,true)."<br>";
				return true;
			}
			else {
				//unset(self::$localpSQLResult);
				self::$localpSQLResult = null;
				return false;
			}
		}
		else{
			if ($justSetQuery === DOFETCH_JUSTSET_TRUE) return true;			// just set it
			else return mysql_fetch_array(self::$localpSQLResult, MYSQL_BOTH);	// launch it
		}
	}
	/**
	 * Checks sql result, waits for SQL write
	 * @param <string> $sql
	 * @param <int> $resultRows
	 * @param <int> $maxIteration
	 * @return <resource/bool>
	 */
	public function waitforSQL($sql,$resultRows,$maxIteration = 20){
		$iteration = 0;
		do{
			$resource = $this->doQuery($sql,RET_RESOURCE,true);
			if($this->pSQLnumrows == $resultRows) return $resource;
			usleep(100000);
			$iteration++;
		}while($iteration < $maxIteration);
		return false;
	}

	/**
	 * @param <array> $fetchResult
	 * @param <bool> $set
	 **/
	private function set_pVar($fetchResult = array()){
		foreach($fetchResult as $var_name => $var_value)
		{
			PSQL::$var->_set($var_name, $var_value);
		}
		return (empty($fetchResult)) ? false : true;
	}

	/**
	*	unsets the SQL result variables
	*	@return <bool>
	**/
	public function globalGarbageCollect(){
		return PSQL::$var->_empty();
	}
	/**
	*	unsets the $pSQLresource resource
	*	@return <bool>
	**/
	public function clearResource(){
		return $this->pSQLResource = null;
	}
	/**
	*	prints the last query ($pSQLquery) and the mysql_error() if exists
	**/
	public function printQuery(){

		print("<div style='background-color: #ffffff; color: #000000; border-bottom: 1px dotted #000000; padding: 2px;'><b>".htmlspecialchars($this->pSQLquery)."</b>");
		if (mysql_errno()>0) print("<br><span style='color: #ff0000;'>".mysql_error()."</span>");
		print "</div>";

		flush();
	}
	/**
	*	addslashes the given variable
	*	@param <string> $variable
	*	@param <bool> $giveReturn
	*	optional @return <string> $slashVar
	**/
	public static function slashIt(&$variable,$giveReturn = false){
		$slashVar = $variable;
		$slashVar = addslashes($slashVar);

		if ($giveReturn) return $slashVar;
		else $variable = $slashVar;
	}

}
/**
 * Query variable container class
 */
class Pvars{
	/** List of all generated and live variable */
	private $pvarsGlobalArr;
	private static $pvarsInstance;

	private function __construct(){}

	public function __destruct(){
		$this->_empty();
	}
	/**
	 * Singleton __constructor
	 */
	public static function _create(){
		 if (!isset(self::$pvarsInstance)) {
            $class = __CLASS__;
            self::$pvarsInstance = new $class;
        }

        return self::$pvarsInstance;
	}
	/**
	 * Disable clone
	 */
	public function __clone(){
        trigger_error('Clone is not allowed.', E_USER_ERROR);
    }
	
	public function _empty(){
		if(!empty($this->pvarsGlobalArr))
		foreach($this->pvarsGlobalArr as $key => $value){
			unset($this->$key);
			unset($this->pvarsGlobalArr[$key]);
		}
	}
	/** default case is private, only for testing!!!*/
	public function _get(){
		global $adminsession;
		
		return var_export($this->pvarsGlobalArr,true);
	}
	/**
	 * Sets the given variable
	 * @param <string> $name
	 * @param <type> $value
	 * @return <bool>
	 */
	protected function _set($name, $value){
		if ($name != "pvarsGlobalArr"){
			$this->$name = $value;
			$this->pvarsGlobalArr[$name] = $value;
			return true;
		}
		else return false;
	}
}

?>
