package writerIdentification;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;

import org.opencv.core.Core;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Point;
import org.opencv.core.Rect;
import org.opencv.core.Scalar;
import org.opencv.imgcodecs.Imgcodecs;
import org.opencv.imgproc.Imgproc;

public class Functions {
	
	static double[] black = {0,0,0};
	static double[] red = {0,0,255};
	static double[] green = {0,255,0};
	static double[] blue = {255,0,0};
	static double[] white = {255,255,255};
	
	List<Double> feature = new ArrayList<Double>();
	
	private List<Rect> listOfRects;
	private List<Mat> listOfInnerCircles;
	private List<List<Rect>> linesList = new ArrayList<List<Rect>>();
	private Rect startIndex;
	private Mat gradient_X;
	private Mat gradient_Y;
	private Mat absGradient_X;
	private Mat absGradient_Y;
	private Mat gradientMagnitude;
	private Mat gradientDirection;
	
	// extracted features
	
	private double[] directionHistogramByMagnitude;
	private double[] directionHistogramByNumber;
	private double rectAvgRatio;
	private double LTLDistance;
	private double WTWDistance;
	private double slopeSize;
	private double uppercaseHeight;
	private double lowercaseHeight;
	private double rectAvgHeight;
	private double innerCircleRatio;
	private double avgCircleSize;

	//Puts the extracted features in to a list
	public void addInfoToList() {
		
		feature = new ArrayList<Double>();
		
		magnitudeNormalization();
		
		for(int i=0;i<directionHistogramByMagnitude.length;i++) {
			feature.add(directionHistogramByMagnitude[i]*100);
		}
		
		for(int i=0;i<directionHistogramByNumber.length;i++) {
			feature.add(directionHistogramByNumber[i]/10000);
		}
		
		feature.add(LTLDistance);
		feature.add(WTWDistance);
		feature.add(uppercaseHeight/10);
		feature.add(lowercaseHeight);
		feature.add(rectAvgHeight);
		feature.add(slopeSize*10);
		feature.add(rectAvgRatio/10);
		feature.add(innerCircleRatio*10);
		feature.add(avgCircleSize/10);
		
	}
	
	public List<Double> getFeature() {
		return feature;
	}
	
	//Loads in the pictures one-by-one
	public Mat load_img() {
		
		Mat img = null;
		
		GUI gui = new GUI();
		
		img  = Imgcodecs.imread(gui.getChosenPath());
		
		return img;
		
	}
	
	//Calls the methods in the correct order
	public Mat methodList() {
		
		Mat img = load_img();
		
		gradientXY(img);
		gradientDirection(img);

		findContours(img);
		findInnerCircle(img);
		removeSmallObject(img);
		drawBoundingBox(img,black,listOfRects);

		rectAverageHeight();
		
		rectThreader(img);
		
		drawCircles(img);
		letterHeight(img);
		slopeSize(img);
		letterAndWordDistances(img);
		
		drawBoundingBox(img,red,listOfRects);
		
		return img;
		
	}
	
	//Searches for contours on the picture
	public void findContours(Mat img) {
		
		Core.bitwise_not(img, img);
		
		int thresh = 100;
		Mat src_gray = new Mat();
		Mat threshold_output = new Mat();
		List<MatOfPoint> contours = new ArrayList<MatOfPoint>();
		Mat hierarchy = new Mat();
		
		Rect normalRect = new Rect();
		
		Imgproc.cvtColor( img, src_gray, Imgproc.COLOR_BGR2GRAY );
		
		Imgproc.threshold( src_gray, threshold_output, thresh, 255, Imgproc.THRESH_BINARY );
		
		Imgproc.findContours(threshold_output, contours, hierarchy, Imgproc.RETR_EXTERNAL, Imgproc.CHAIN_APPROX_SIMPLE);
		
		listOfRects = new ArrayList<Rect>();
		
		for (int i = 0; i < contours.size() ; i++) {
			
			normalRect = Imgproc.boundingRect(new MatOfPoint(contours.get(i).toArray()));
			listOfRects.add(normalRect);
			
		}
		
		Core.bitwise_not(img, img);
		
	}
	
	//Searches for circles, inside the letters
	public void findInnerCircle(Mat img) {
		
		innerCircleRatio = 0;
		listOfInnerCircles = new ArrayList<Mat>();
		
		Mat src_gray = img.clone();
		
		Imgproc.cvtColor( img, src_gray, Imgproc.COLOR_BGR2GRAY );
		
		Mat labels = new Mat();
		Mat stats = new Mat();
		Mat centroids = new Mat();
		Imgproc.connectedComponentsWithStats(src_gray, labels, stats, centroids);
		
		Imgproc.cvtColor( src_gray, src_gray, Imgproc.COLOR_GRAY2RGB );
		for(int i = 0; i < centroids.rows(); i++) {
			if(i!=0 && i!=1) {
				listOfInnerCircles.add(stats.row(i));
			}
		}
		
		for(int i = 0; i < listOfInnerCircles.size(); i++) {
			innerCircleRatio += listOfInnerCircles.get(i).get(0, 2)[0] / listOfInnerCircles.get(i).get(0, 3)[0];
		}
		innerCircleRatio /= listOfInnerCircles.size();
		
		for(int i = 0; i < listOfInnerCircles.size(); i++) {
			avgCircleSize += listOfInnerCircles.get(i).get(0, 4)[0];
		}
		avgCircleSize /= listOfInnerCircles.size();
		
	}
	
	//Searches for the first letters of the lines
	public void leftCornerRect(Mat img) {
		
		Rect startingPoint = listOfRects.get(0);
		
		for(int i = 0; i < listOfRects.size();i++) {

			if(listOfRects.get(i).y + listOfRects.get(i).height < startingPoint.y && listOfRects.get(i).x < startingPoint.x + 100) {
				startingPoint = listOfRects.get(i);
			}else if (listOfRects.get(i).x < startingPoint.x && listOfRects.get(i).y < startingPoint.y + startingPoint.height) {
				startingPoint = listOfRects.get(i);
			}
			
		}
		
		startIndex = startingPoint;
		
	}
	
	//Creates the X and Y gradients
	public void gradientXY(Mat img) {
		
		Mat scr_clone = img.clone();
		Mat grad = new Mat();
		
		Mat grad_x = new Mat();
		Mat grad_y = new Mat();
		Mat abs_grad_x = new Mat();
		Mat abs_grad_y = new Mat();
		
		int ddepth = CvType.CV_32F;
		int scale = 1;
		int delta = 0;
		
		Imgproc.Sobel( scr_clone, grad_x, ddepth, 1, 0, 3, scale, delta, Core.BORDER_DEFAULT );
		Core.convertScaleAbs( grad_x, abs_grad_x );
		
		Imgproc.Sobel( scr_clone, grad_y, ddepth, 0, 1, 3, scale, delta, Core.BORDER_DEFAULT );
		Core.convertScaleAbs( grad_y, abs_grad_y );
		
		Core.addWeighted( abs_grad_x, 0.5, abs_grad_y, 0.5, 0, grad );
		
		gradient_X = grad_x;
		gradient_Y = grad_y;
		absGradient_X = abs_grad_x;
		absGradient_Y = abs_grad_y;
		gradientMagnitude = grad;
		
	}
	
	//Calculates the directions, for the points of the gradient 
	//and sorts them into a gradient histogram
	public void gradientDirection(Mat img) {

		directionHistogramByMagnitude = new double[8];
		directionHistogramByNumber = new double[8];
		
		Mat orientation = Mat.zeros(absGradient_X.rows(), absGradient_Y.cols(), CvType.CV_32F);
		gradientDirection= new Mat(orientation.size(),CvType.CV_32F);
		
		
		gradient_X.convertTo(gradient_X,CvType.CV_32F);
		gradient_Y.convertTo(gradient_Y,CvType.CV_32F);
		
		Core.phase(gradient_X, gradient_Y, orientation , true);
		
		gradientDirection = orientation;
		
		for(int i = 0; i < absGradient_X.rows(); i++){
	        for(int j = 0; j < absGradient_Y.cols(); j++){
	        	if(gradientDirection.get(i, j)[0] != 0.0f) {
		        	if(gradientDirection.get(i, j)[0] >= 337.5 || gradientDirection.get(i, j)[0] < 22.5) {
		        		directionHistogramByMagnitude[0] += gradientMagnitude.get(i, j)[0];
		        		directionHistogramByNumber[0]++;
		        	}
		        	else if(gradientDirection.get(i, j)[0] >= 22.5 && gradientDirection.get(i, j)[0] < 67.5) {
		        		directionHistogramByMagnitude[1] += gradientMagnitude.get(i, j)[0];
		        		directionHistogramByNumber[1]++;
		        	}
		        	else if(gradientDirection.get(i, j)[0] >= 67.5 && gradientDirection.get(i, j)[0] < 112.5) {
		        		directionHistogramByMagnitude[2] += gradientMagnitude.get(i, j)[0];
		        		directionHistogramByNumber[2]++;
		        	}
		        	else if(gradientDirection.get(i, j)[0] >= 112.5 && gradientDirection.get(i, j)[0] < 157.5) {
		        		directionHistogramByMagnitude[3] += gradientMagnitude.get(i, j)[0];
		        		directionHistogramByNumber[3]++;
		        	}
		        	else if(gradientDirection.get(i, j)[0] >= 157.5 && gradientDirection.get(i, j)[0] < 202.5) {
		        		directionHistogramByMagnitude[4] += gradientMagnitude.get(i, j)[0];
		        		directionHistogramByNumber[4]++;
		        	}
		        	else if(gradientDirection.get(i, j)[0] >= 202.5 && gradientDirection.get(i, j)[0] < 247.5) {
		        		directionHistogramByMagnitude[5] += gradientMagnitude.get(i, j)[0];
		        		directionHistogramByNumber[5]++;
		        	}
		        	else if(gradientDirection.get(i, j)[0] >= 247.5 && gradientDirection.get(i, j)[0] < 292.5) {
		        		directionHistogramByMagnitude[6] += gradientMagnitude.get(i, j)[0];
		        		directionHistogramByNumber[6]++;
		        	}
		        	else if(gradientDirection.get(i, j)[0] >= 292.5 && gradientDirection.get(i, j)[0] < 337.5) {
		        		directionHistogramByMagnitude[7] += gradientMagnitude.get(i, j)[0];
		        		directionHistogramByNumber[7]++;
		        	}
	        	}
	        }
		}
	}

	//Normalizes the gradient histogram
	public void magnitudeNormalization() {
		
		int sum = 0;
		for(int i=0;i<directionHistogramByMagnitude.length;i++) {
			sum += directionHistogramByMagnitude[i];
		}
		for(int i=0;i<directionHistogramByMagnitude.length;i++) {
			directionHistogramByMagnitude[i] /= sum;
		}
		
	}
	
	//Calculates the average height of the letters
	public void rectAverageHeight() {
		
		float count = 0;
		
		for(int i = 0; i < listOfRects.size();i++) {
			count += listOfRects.get(i).height;
		}
		
		rectAvgHeight = count / listOfRects.size();
		
	}
	
	//Threads the letters into a line
	public void rectThreader(Mat img) {
		
		List<Rect> line;
		List<Integer> lineAvg = new ArrayList<>();
		Set<Rect> lineHash = new LinkedHashSet<Rect>();
		int lineAvgCurrent;
		
		int prevHeights[];
		int arrayIndex;
		int minHeight;
		double distance;
		Rect nextPoint;
		Rect currentPoint;
		
		all:
		while(listOfRects.size() != 0) {
			leftCornerRect(img);
			
			line = new ArrayList<Rect>();
			
			prevHeights = new int[10]; 
			arrayIndex = 0;
			minHeight = 0;
			lineAvgCurrent = 0;
			
			distance = 1000;
			nextPoint = new Rect();
			currentPoint = startIndex;
			
			Mat a;
			Mat b;
			
			ciklus:
			for(int x = 0; x < 100 ;x++) {
				a = new MatOfPoint2f(new Point(currentPoint.x+currentPoint.width,currentPoint.y));
				
				prevHeights[arrayIndex] = currentPoint.y + currentPoint.height;
				minHeight = calculateMinHeight(prevHeights,arrayIndex);
				
				if(arrayIndex < 9) {
					arrayIndex++;
				}else {
					arrayIndex=0;
				}
				
				for(int i = 0; i < listOfRects.size(); i++) {
					b = new MatOfPoint2f(new Point(listOfRects.get(i).x,listOfRects.get(i).y));
					if(Core.norm(a, b) < distance && Core.norm(a, b) != 0 && currentPoint.x < listOfRects.get(i).x && minHeight > listOfRects.get(i).y && Core.norm(a, b) < 250) {
						distance = Core.norm(a, b);
						nextPoint = listOfRects.get(i);
					}
				}
				
				if(nextPoint.x == 0 && nextPoint.y == 0 ) {
					break all;
				}
				
				lineAvgCurrent += currentPoint.y + currentPoint.height/2;
				
				Imgproc.line(img, new Point(currentPoint.x + currentPoint.width, currentPoint.y), new Point(nextPoint.x, nextPoint.y), new Scalar(0,0,0), 4);
				
				line.add(currentPoint);
				listOfRects.remove(currentPoint);
				
				for(int i = 0; i < listOfRects.size(); i++) {
					if(listOfRects.get(i).y < minHeight && listOfRects.get(i).x < currentPoint.x + currentPoint.width && listOfRects.get(i).x > currentPoint.x - 100) {
						line.add(currentPoint);
						listOfRects.remove(i);
						i=0;
					}
				}
				
				if(currentPoint == nextPoint) {
					
					lineHash = new LinkedHashSet<Rect>(line);
					line = new ArrayList<Rect>(lineHash);
					linesList.add(line);
					
					lineAvg.add(lineAvgCurrent / line.size());
					break ciklus;
				}
				
				currentPoint = nextPoint;
				distance = 1000;
				
			}
			
		}
		
		for(int j = 0; j < listOfRects.size();j++) {
			linesList.get(sortTheRest(lineAvg,j)).add(listOfRects.get(j));
			listOfRects.remove(j);
		}
	}
	
	//Draws circles on to the picture for testing purposes
	public void drawCircles(Mat img) {
		
		for(int i = 0; i < linesList.size();i++) {
			
			List<Rect> line = new ArrayList<Rect>(linesList.get(i));
			
			Random r = new Random();
			Scalar szin = new Scalar(r.nextInt(256),r.nextInt(256),r.nextInt(256));
			
			for(int j = 0; j < line.size(); j++) {
				Imgproc.circle(img,new Point(line.get(j).x, line.get(j).y), 4, szin, 15);
			}
			
		}
		
	}
	
	//Calculates the average width between letters and words
	public void letterAndWordDistances(Mat img) {
		
		float avg = 0;
		
		for(int i = 0; i < linesList.size();i++) {
			
			int var = 0;
			int varCount = 0;
			
			List<Rect> line = new ArrayList<Rect>(linesList.get(i));
			
			for(int j = 0; j < line.size(); j++) {
				
				if(j != line.size()-1) {
					var +=  line.get(j+1).x - (line.get(j).x + line.get(j).width);
					varCount++;
				}
				
			}
			
			avg += var / varCount;
			
		}
		
		avg /= linesList.size();
		
		float letDist = 0;
		int letDistCount = 0;
		float wordDist = 0;
		int wordDistCount = 0;
		
		for(int i = 0; i < linesList.size();i++) {
			List<Rect> line = new ArrayList<Rect>(linesList.get(i));
			
			for(int j = 0; j < line.size(); j++) {
				if(j != line.size()-1) {
					if(line.get(j+1).x - (line.get(j).x + line.get(j).width) > avg) {
						wordDist += line.get(j+1).x - (line.get(j).x + line.get(j).width);
						wordDistCount++;
						Imgproc.line(img, new Point(line.get(j).x + line.get(j).width, line.get(j).y + line.get(j).height/2), new Point(line.get(j+1).x, line.get(j+1).y + line.get(j+1).height/2), new Scalar(0,255,0), 4);
					}else {
						if(line.get(j+1).x - (line.get(j).x + line.get(j).width) > 0) {
							letDist += line.get(j+1).x - (line.get(j).x + line.get(j).width);
							letDistCount++;
						}else {
							letDistCount++;
						}
					}
				}
			}
		}

		WTWDistance = wordDist/wordDistCount;
		LTLDistance = letDist/letDistCount;

	}
	
	//Calculates the slope of the lines
	public void slopeSize(Mat img) {
		
		double avg = 0;
		int rectPerLineAvg = 0;
		int lineCount = 0;
		
		for(int i = 0; i < linesList.size();i++) {
			List<Rect> line = new ArrayList<Rect>(linesList.get(i));
			rectPerLineAvg += line.size();
		}
		rectPerLineAvg /= linesList.size();
		
		for(int i = 0; i < linesList.size();i++) {
			
			double y = 0;
			
			double count = 0;
			double sumX = 0;
			double sumY = 0;
			double sumX2 = 0;
			double sumXY = 0;
			double xMean = 0;
			double yMean = 0;
			double slope = 0;
			double yInt = 0;
			
			List<Rect> line = new ArrayList<Rect>(linesList.get(i));
			
			
			if(line.size() <= rectPerLineAvg/2) {
				break;
			}
			lineCount++;
			
			count = line.size();
			for(int j = 0; j < line.size(); j++) {
				sumX += line.get(j).x;
				sumY += line.get(j).y + line.get(j).height/2;
				sumX2 += line.get(j).x * line.get(j).x;
				sumXY += line.get(j).x * (line.get(j).y + line.get(j).height/2);
			}

			xMean = sumX/count;
			yMean = sumY/count;
			slope = (sumXY - sumX * yMean) / (sumX2 - sumX * xMean);
			yInt = yMean - slope * xMean;
			
			y = slope * line.get(line.size()-1).x + yInt;
			
			
			int lineEndX = line.get(0).x;
			for(int j = 0; j < line.size(); j++) {
				if(line.get(j).x > lineEndX) {
					lineEndX = line.get(j).x;
				}
			}
			
			avg += Math.toDegrees(Math.atan((y - (line.get(0).y+line.get(0).height/2)) / (lineEndX - line.get(0).x)));
			
		}
		
		slopeSize = avg/(lineCount);
		
	}
	
	// Calculates the average height of the letters
	public void letterHeight(Mat img) {
		
		int lowerCount = 0;
		float lower = 0;
		int upperCount = 0;
		float upper = 0;
		
		for(int i = 0; i < linesList.size();i++) {
		
			List<Rect> line = new ArrayList<Rect>(linesList.get(i));
			
			for(int j = 0; j < line.size(); j++) {
				
				
				if(line.get(j).height <= rectAvgHeight + rectAvgHeight/5) {
					lower += line.get(j).height;
					lowerCount++;
					Imgproc.circle(img,new Point(line.get(j).x, line.get(j).y), 4, new Scalar(0,0,0), 6);
				}else {
					upper += line.get(j).height;
					upperCount++;
					Imgproc.circle(img,new Point(line.get(j).x, line.get(j).y), 4, new Scalar(255,255,255), 6);
				}
			}
			
		}
		
		lowercaseHeight = lower / lowerCount;
		uppercaseHeight = upper / upperCount;
		
	}
	
	// Puts the remaining letters in to the most fitting line
	public int sortTheRest(List<Integer> lineAvg, int j) {
		
		int result=0;

		for(int i = 0; i < lineAvg.size();i++) {
			if(i == 0) {
				result=i;
			}else {
				if(Math.abs(lineAvg.get(i) - (listOfRects.get(j).y + listOfRects.get(j).height)) < Math.abs(lineAvg.get(result) - (listOfRects.get(j).y + listOfRects.get(j).height))) {
					result = i;
				}
			}
		}
		
		return result;
	}
	
	//Calculates the average of the lowercase letters
	public int calculateMinHeight(int prevHeights[],int arrayIndex) {
		
		int result = 0;
		int notNullNum = 0;
		
		for(int i = 0; i < prevHeights.length; i++) {
			if(prevHeights[i] != 0) {
				result += prevHeights[i];
				notNullNum++;
			}
		}
		
		if(result != 0 && notNullNum != 0) {
			result = result / notNullNum;
		}
		return result;
	}
	
	//Removes the dots and commas from the picture
	public void removeSmallObject(Mat img) {
		
		int average = 0;
		int sideRatio = 0;
		
		for(int i = 0; i < listOfRects.size(); i++) {
			average += listOfRects.get(i).area();
			sideRatio += listOfRects.get(i).width / listOfRects.get(i).height;
		}
		
		average = Math.round(average / listOfRects.size());
		
		rectAvgRatio = sideRatio;
		
		for(int i = 0; i < listOfRects.size(); i++) {
			if(listOfRects.get(i).area() < Math.round(average/4)) {
				
				for(int x = listOfRects.get(i).x; x < listOfRects.get(i).x + listOfRects.get(i).width; x++) {
					for(int y = listOfRects.get(i).y; y < listOfRects.get(i).y + listOfRects.get(i).height; y++) {
						img.put(y, x , white);
					}
				}
				listOfRects.remove(i);
				i = 0;
			}
		}
		
	}
	
	//Draws a bounding box, for the letters on the picture, for testing purposes
	public void drawBoundingBox(Mat img,double[] color, List<Rect> rectList) {
		
		for(int i = 0; i < rectList.size(); i++) {
			Imgproc.rectangle(img,new Point(rectList.get(i).x, rectList.get(i).y),new Point(rectList.get(i).x + rectList.get(i).width, rectList.get(i).y + rectList.get(i).height),new Scalar(color),2);
		}
		
	}

}
