package writerIdentification;

import java.awt.*;
import java.awt.event.*;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import javax.swing.*;
import javax.swing.border.MatteBorder;
import javax.swing.filechooser.FileFilter;

import org.opencv.core.Mat;
import org.opencv.imgcodecs.Imgcodecs;

public class GUI {
	
	static Training training = new Training();
	
	static String chosenPath;
	static String outputPath;
	static String logFilePath;
	private String fileName;
	private File[] fileList;
	
	private String currentlyChosen;
	
	private String csvFileName;
	private String filepath;
	
	public String getChosenPath() {
		return chosenPath;
	}

	public void LoadGUI() {
		
		//Creates the graphical user interface
		
		// Creates the window frame
		JFrame frame = new JFrame("Writer_Identification");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setSize(900, 200);
		frame.setLocation(500, 300);
		frame.setLayout(new GridLayout(0,1));
		frame.setVisible(true);
		
		//Creates the panels and layouts
		JPanel upperPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		JPanel middlePanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
		JPanel bottomPanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
		JPanel miscPanel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		
		//Adds the layouts to the frame
		frame.add(upperPanel);
		frame.add(middlePanel);
		frame.add(bottomPanel);
		frame.add(miscPanel);
		
		//Puts the elements to the upper panel
		JLabel chooseLabel = new JLabel("Chosen file path:");
		chooseLabel.setFont(new Font("Serif", Font.PLAIN, 20));
		JLabel chosenPathLabel = new JLabel("-Nothing chosen yet!-");
		chosenPathLabel.setFont(new Font("Serif", Font.PLAIN, 20));
		upperPanel.add(chooseLabel);
		upperPanel.add(chosenPathLabel);
		
		//Puts the elements to the middle panel
		JButton addPathButton = new JButton("Add path");
		JButton calculateButton = new JButton("Calculate");
		ButtonGroup radioGroup = new ButtonGroup();
		JRadioButton fileRadioButton = new JRadioButton("File");
		JRadioButton folderRadioButton = new JRadioButton("Folder");
		radioGroup.add(fileRadioButton);
		radioGroup.add(folderRadioButton);
		middlePanel.add(fileRadioButton);
		middlePanel.add(folderRadioButton);
		middlePanel.add(addPathButton);
		middlePanel.add(calculateButton);
		calculateButton.setVisible(false);
		
		//Puts the elements to the bottom panel
		JLabel result = new JLabel("Result: N/A",SwingConstants.CENTER);
		result.setPreferredSize(new Dimension(880, 25));
		result.setBorder(new MatteBorder(0, 0, 1, 0, Color.BLACK));
		bottomPanel.add(result);
		
		//Puts the elements to the misc panel
		JButton logButton = new JButton("Use existing log");
		JLabel logLabel = new JLabel(" - Nothing chosen yet! - ");
		miscPanel.add(logButton);
		miscPanel.add(logLabel);
		
		//Action listeners for each button
		fileRadioButton.addActionListener(new ActionListener() {
			@Override
				public void actionPerformed(ActionEvent e) {
					if(currentlyChosen == "folder") {
						chosenPath = null;
						chosenPathLabel.setText("-Nothing chosen yet!-");
						currentlyChosen = "file";
						calculateButton.setVisible(false);
					}
					if(currentlyChosen == null) {
						currentlyChosen = "file";
					}
			}
		});
		
		folderRadioButton.addActionListener(new ActionListener() {
			@Override
				public void actionPerformed(ActionEvent e) {
					if(currentlyChosen == "file") {
						chosenPath = null;
						chosenPathLabel.setText("-Nothing chosen yet!-");
						currentlyChosen = "folder";
						calculateButton.setVisible(false);
					}
					if(currentlyChosen == null) {
						currentlyChosen = "folder";
					}
			}
		});
		
		logButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				JFileChooser chooser = new JFileChooser();
				
				FileFilter  filter = new FileFilter() {
					
					@Override
					public String getDescription() {
						return "Comma-separated values (*.csv)";
					}
					
					@Override
					public boolean accept(File f) {
						if (f.isDirectory()) {
				            return true;
				        } else {
				            return f.getName().toLowerCase().endsWith(".csv");
				        }
					}
				};
				
				chooser.setFileFilter(filter);
				int returnVal = chooser.showDialog(frame,"Choose");
				if(returnVal == JFileChooser.APPROVE_OPTION) {
					logFilePath = chooser.getSelectedFile().getAbsolutePath();
					logLabel.setText(logFilePath);
					calculateButton.setVisible(true);
				}
			}
		});
		
		addPathButton.addActionListener(new ActionListener() {
		@Override
			public void actionPerformed(ActionEvent e) {
			
				if(fileRadioButton.isSelected()) {
					JFileChooser chooser = new JFileChooser();
					int returnVal = chooser.showDialog(frame,"Choose");
					if(returnVal == JFileChooser.APPROVE_OPTION) {
						
						chosenPath = chooser.getSelectedFile().getAbsolutePath();
						fileName = chosenPath.substring(chosenPath.lastIndexOf("\\") + 1);
						outputPath = chosenPath.substring(0, chosenPath.lastIndexOf("\\",chosenPath.lastIndexOf("\\")-2)) + "\\_output";
						
						chosenPathLabel.setText(chosenPath);
					}
				}else if(folderRadioButton.isSelected()){
					
					JFileChooser chooser = new JFileChooser();
					chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
					int returnVal = chooser.showDialog(frame,"Choose");
					if(returnVal == JFileChooser.APPROVE_OPTION) {
						
						chosenPath = chooser.getSelectedFile().getAbsolutePath();
						outputPath = chosenPath.substring(0, chosenPath.lastIndexOf("\\")) + "\\_output";
						
						chosenPathLabel.setText(chosenPath);
					}
					
				}
				
				if(chosenPath != null) {
					calculateButton.setVisible(true);
				}
				
				frame.repaint();
				
			}
		});
		
		calculateButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				
				if(logFilePath == null) {
					createFolder();
				}
				
				if(logFilePath == null) {
					createCsvNameAndFile();
				}

				if(chosenPath != null && fileRadioButton.isSelected()) {

					training.setToDefault();
					MainCode(false);
					
					System.out.println("FINISHED");
					
					logLabel.setText("-Nothing chosen yet!-");
					logFilePath = null;
							
				}else if(chosenPath != null && folderRadioButton.isSelected() || logFilePath != null) {
					
					if(logFilePath == null) {
						training.setToDefault();
								
						System.out.println("FOLDER IS SELECTED");
						
						File folderPath = new File(chosenPath);
						fileList = folderPath.listFiles();
						
						for(int i=0; i<fileList.length; i++) {
							chosenPath = fileList[i].getAbsolutePath();
							fileName = chosenPath.substring(chosenPath.lastIndexOf("\\") + 1);
							System.out.println(fileName);
							MainCode(true);
						}
					}else {
						filepath = logFilePath;
						training.setToDefault();
					}
					
					try {
						csvRead(training);
						
						training.createLabels();
						//training.kNearestNeighbors();
						training.supportVectorMachines();
						
					}catch (Exception exc) {
						System.out.println("Error while training");
					}
					
					System.out.println("FINISHED");
					
					result.setText("Result: " + training.getCorrectPercent() +"%");
					
					System.gc();
					
					chosenPathLabel.setText("-Nothing chosen yet!-");
					calculateButton.setVisible(false);
					
					logLabel.setText("-Nothing chosen yet!-");
					logFilePath = null;
					
				}
			}
		});
		
	}
	
	// Method for instantiating the Function class
	public void MainCode(boolean isFolder) {
		
		Mat img;
		
		try {
			Functions function = new Functions();
			img = function.load_img();
			
			img = function.methodList();
			
			function.addInfoToList();
			
			if(isFolder) {
				csvWrite(function.getFeature(),fileName);
			}
			
			Imgcodecs.imwrite(outputPath +"\\"+ "test_" +fileName , img );
		}catch (Exception e) {
			System.out.println("Error while processing file");
		}
		
	}
	
	//Creates a name for the CSV file by using the current date and time
	public void createCsvNameAndFile() {
		DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH-mm-ss");
		LocalDateTime now = LocalDateTime.now();
		
		csvFileName = dtf.format(now);
		filepath = outputPath + "\\" + csvFileName + ".csv";
		
	}
	
	//Gets the information from the pictures and writes them in to the CSV file
	public void csvWrite(List<Double> row, String fileName) {
		
		try (PrintWriter writer = new PrintWriter(new FileWriter(filepath,true))) {
			
			StringBuilder sb = new StringBuilder();
			
			for(int i=0;i<row.size();i++) {
				if(i==0) {
					sb.append(fileName);
					sb.append(',');
				}
				sb.append(row.get(i));
				if(i != row.size()-1) {
					sb.append(',');
				}
			}
			sb.append('\n');

		    writer.write(sb.toString());
		    writer.close();
		    
		} catch (Exception e) {
			System.out.println("CSV writing error");
		}
		
	}
	
	//Reads out the information from the CSV file, and splits them
	public void csvRead(Training training) {
		
		List<List<String>> records = new ArrayList<>();
		try (BufferedReader br = new BufferedReader(new FileReader(filepath))) {
			
			String line;
			
			while ((line = br.readLine()) != null) {
		        String[] values = line.split(",");
		        records.add(Arrays.asList(values));
		    }
			
			training.setImageResults(records);
			
		}catch (Exception e) {
			System.out.println("CSV read error");
		}
		
	}
	
	// Creates the output folder
	public void createFolder() {
		if(Files.notExists(Paths.get(outputPath))) {
			new File(outputPath).mkdirs();
		}
	}

}
