//
//  MenuViewController.swift
//  08_MVCs
//
//  Created by janki.zoltan on 2016. 08. 30..
//  Copyright © 2016. janki.zoltan. All rights reserved.
//

import UIKit

class MenuViewController: UIViewController {
    
    fileprivate let images: Dictionary<String, String> = [
        "irinyi": "irinyi.jpg",
        "bolyai": "bolyai.jpg",
        "rektori": "rektori.jpg"
    ]

    
    // In a storyboard-based application, you will often want to do a little preparation before navigation
    override func prepare(for segue: UIStoryboardSegue, sender: Any?) {
        // Get the new view controller using segue.destinationViewController.
        // Pass the selected object to the new view controller.
        
        let destinationvc = segue.destination
        
        if let imagevc = destinationvc as? ImageViewController {
            if let identifier = segue.identifier {
                if let fileName = images[identifier] {
                    imagevc.image = fileName
                    if let sendingButton = sender as? UIButton {
                        imagevc.navigationItem.title = sendingButton.currentTitle
                    }
                }
            }
        }
        
        
        
    }

}
