#!/bin/gawk -f

# Az AWK szkriptek 3 fő részből állnak:
#   - A BEGIN blokk rögtön a szkript elindítása után fog lefutni (pontosan 1-szer fut le).
#     Itt szoktunk változókat létrehozni, valamint itt állíthatjuk be a mezőelválasztó karaktert.
#   - A főprogram lényegében egy ciklus, ami végigmegy a paraméterként kapott fájl sorain, és
#     a főprogramban szereplő utasítások minden sor esetén végrehajtódnak. A főprogramban a $0
#     jelöli a teljes aktuális sor, a $1 a sor első oszlopát, a $2 a sor második oszlopát stb.
#   - Az END blokk a program végén lefutó utasításblokk, ami azután kerül végrehajtásra, miután
#     a teljes bemeneti fájlt feldolgoztuk (pontosan 1-szer fut le ez is, a BEGIN-hez hasonlóan).
#
# A felsorolt 3 fő rész közül bármelyik tetszőlegesen elhagyható, ha nincs rá szükségünk.

BEGIN {
	# Ha a bemeneti fájl soraiban NEM szóközzel vannak elválasztva az adatok, akkor át kell állítani a
	# mezőelválasztó karaktert (FS = Field Separator). Most pontosvesszővel vannak elválasztva az oszlopok.
	FS = ";"
}

# Csak azokat a sorokat szeretnénk bejárni, amelyekben a szakok között (azaz a 2. oszlopban) szerepel a
# "mernokinfo" szöveg. Ez megoldható úgy, hogy reguláris kifejezést illesztünk a 2. oszlopra.

$2~/mernokinfo/ {
	# Minden mérnökinformatikus esetén kiíratjuk a nevet (1. oszlop) és az állapotot (3. oszlop).
	print $1 " - " $3
}

# Ebben a szkriptben nincs szükségünk END blokkra, ezért azt ki sem írjuk.
