#!/bin/gawk -f

# Ha a teljes fájlra vonatkozóan kell számolni valamit, akkor még a fájl feldolgozása előtt, a
# BEGIN blokkban létrehozunk egy számláló változót erre a célra.

BEGIN {
	# Ebben a változóban fogjuk megszámolni, hogy hány macskás videót találtunk.
	macskas_videok_szama = 0
}

# Itt most két reguláris kifejezést kell illesztenünk (ezeket logikai ÉS művelettel kapcsoljuk össze):
#   - Meg kell mondanunk, hogy az 1. oszlopnak kötőjellel kell kezdődnie.
#   - Meg kell mondanunk, hogy a 9. oszlopnak a "macska" szöveggel kell kezdődnie, ami után
#     tetszőleges mennyiségű (akár 0 darab) betű/szám/alulvonás/pont karakter szerepelhet, majd 
#     ezután a ".mp4" szöveg jelzi a fájlnév végét. Itt arra kell figyelnünk, hogy a pont karakternek 
#     speciális jelentése van a reguláris kifejezések világában, ezért, amikor a pont karakterre 
#     illesztünk, akkor escape-elnünk kell azt a következőképpen: \.
#
# Az első alpontot a ^- reguláris kifejezéssel írhatjuk le (ez fejezi ki a kötőjellel való kezdődést).
# A második alpontot a ^macska[A-Za-z0-9_.]*\.mp4$ reguláris kifejezéssel írhatjuk le. Magyarázat:
#   - ^macska - az állomány nevének a "macska" szöveggel kell kezdődnie
#   - [A-Za-z0-9_.]* - tetszőleges mennyiségű (akár 0 darab) betű/szám/alulvonás/pont karakter
#   - \.mp4$ - a ".mp4" szöveg jelzi a fájlnév végét.

$1~/^-/ && $9~/^macska[A-Za-z0-9_.]*\.mp4$/ {
	# Minden illeszkedő sor esetén kiíratjuk a fájl nevét (9. oszlop), valamint megnöveljük a
	# számláló változónk értékét 1-gyel.
	
	print $9
	macskas_videok_szama++
}

# A fájl feldolgozása után kiíratjuk, hogy hány macskás videót találtunk.

END {
	print "-----------------------------------"
	print macskas_videok_szama " macskás videót találtam."
}
