#!/bin/gawk -f

BEGIN {
	# Mivel nem szóközzel vannak elválasztva az oszlopok, ezért átállítjuk a mezőelválasztó karaktert.
	FS = ";"
	
	# Létrehozunk egy változót, amiben majd a megfelelő játékosok összpontszámát fogjuk kiszámolni.
	osszpontszam = 0
}

# Reguláris kifejezést illesztünk a játékosnévre (1. oszlop). A megoldás részletes magyarázata:
#  - ^(\[admin\])? - a név elején opcionálisan szerepel az "[admin]" szöveg (itt figyelnünk kell arra,
#    hogy a []-ek speciális jelentéssel bíró szimbólumok, ezért ezeket escape-elnünk kell)
#  - [A-Za-z0-9 _\.]+ - legalább 1 darab betű/számjegy/alulvonás/pont karakter
#  - [0-9]{2,}$ - a játékosnév végén legalább 2 darab számjegy szerepel.

$1~/^(\[admin\])?[A-Za-z0-9 _\.]+[0-9]{2,}$/ {
	# Az illeszkedő sorokban összeadogatjuk a pontszámokat (3. oszlop).
	osszpontszam += $3
}

END {
	# A program végén kiíratjuk a kiszámolt összpontszámot.
	print osszpontszam
}
