#!/bin/gawk -f

# Ebben a programban nincs szükségünk sem BEGIN, sem pedig END blokkra (néha van ilyen is).
# Csak a fájl sorainak feldolgozását végző főprogramot kell megírnunk.

{
	# Végig szeretnénk menni a szavakon, azaz a sorokon belül szereplő oszlopokon. Ezt egy ciklussal
	# tesszük meg: az 1. oszloptól megyünk az utolsó oszlopig (NF = Number of Fields = oszlopok száma).
	
	for (i = 1; i <= NF; i++) {
		# A cikluson belül az i-edik oszlopra (tehát az aktuális szóra) $i-vel hivatkozhatunk.
		
		# Az aktuális szót kiíratjuk akkor, ha teljesül rá a következő 2 feltétel:
		#  - 1 karakternél hosszabb (length függvénnyel kérhetjük le egy szöveg hosszát) ÉS
		#  - csupa nagybetűket tartalmaz, majd a szó végén opcionálisan írásjel szerepel.
		
		if (length($i) > 1 && $i~/^[A-Z]+[\.!\?,]?$/) {
			print $i
		}
	}
}
