#!/bin/gawk -f

# Mivel nem tudjuk előre, hogy milyen csapatneveink lesznek, ezért ebben a feladatban is asszociatív
# tömböt fogunk használni. A kulcsok a csapatnevek lesznek, a kulcsokhoz tartozó értékek pedig azt
# fogják megmondani, hogy az adott csapat tagjai összesen hány pontot értek el a versenyen.

BEGIN {
	# Mivel nem szóközzel vannak elválasztva az oszlopok, ezért átállítjuk a mezőelválasztó karaktert.
	FS = ";"
	
	# Változók a maximális pontszámnak és a legtöbb pontot elérő csapat nevének.
	max_pont = 0
	nyertes_csapat = ""
}

# A bemeneti fájl első sora egy fejlécet tartalmaz, amit nem szeretnénk feldolgozni. Emiatt csak az első 
# soron kívüli sorokat vizsgáljuk (NR = Number of Records = az aktuális sor sorszáma).

NR != 1 {
	# A nagybetűsített csapatok összpontszámait egy eredmeny nevű tömbben fogjuk eltárolni.
	# A kulcs mindig a csapatnév lesz, az érték pedig az adott csapat tagjai által elért pontszámok összege lesz.
	eredmeny[toupper($2)] += $3
}

END {
	# A program végén kiíratjuk az eredmeny nevű tömbben tárolt statisztikát (a csapat változó fogja tárolni a
	# csapatnevet (a kulcsot), míg az eredmeny[csapat] a csapat által elért összpontszám lesz (az érték)).
	# Végrehajtunk egy egyszerű maximumkeresést is: ha egy csapat több pontot ért el, mint az eddigi legtöbb pontszám,
	# akkor frissítjük a max_pont és a nyertes_csapat változók értékét ennek megfelelően.
	
	for (csapat in eredmeny) {
		print csapat " csapat pontszáma: " eredmeny[csapat]
	
		if (eredmeny[csapat] > max_pont) {
			max_pont = eredmeny[csapat]
			nyertes_csapat = csapat
		}
	}
	
	# Kiíratjuk a győztes csapat nevét is.
	print "-------------------------------------------------"
	print "A legtöbb pontot a(z) "nyertes_csapat" csapat érte el."
}
